/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class MaterialBlockRenderer {
    public static final String LAYER_2_SUFFIX = "_layer2";
    private static final Set<MaterialBlockRenderer> MODELS = new HashSet<MaterialBlockRenderer>();
    private final Block block;
    private final MaterialIconType type;
    private final MaterialIconSet iconSet;

    public static void create(Block block, MaterialIconType type, MaterialIconSet iconSet) {
        MODELS.add(new MaterialBlockRenderer(block, type, iconSet));
    }

    public static void reinitModels() {
        for (MaterialBlockRenderer model : MODELS) {
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)model.block);
            ResourceLocation modelId = blockId.withPrefix("block/");
            GTDynamicResourcePack.addBlockModel(blockId, (Supplier<JsonElement>)new DelegatedModel(model.type.getBlockModelPath(model.iconSet, true)));
            GTDynamicResourcePack.addBlockState(blockId, (Supplier<JsonElement>)BlockModelGenerators.createSimpleBlock((Block)model.block, (ResourceLocation)modelId));
            GTDynamicResourcePack.addItemModel(BuiltInRegistries.ITEM.getKey((Object)model.block.asItem()), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.getModelLocation((Block)model.block)));
        }
    }

    protected MaterialBlockRenderer(Block block, MaterialIconType type, MaterialIconSet iconSet) {
        this.block = block;
        this.type = type;
        this.iconSet = iconSet;
    }
}

