/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.client.util.ModelUtils;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCoverRenderer
implements ICoverRenderer {
    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite sprite = null;
    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite emissiveSprite = null;

    public SimpleCoverRenderer(ResourceLocation texture) {
        this(texture, null);
    }

    public SimpleCoverRenderer(ResourceLocation texture, ResourceLocation emissiveTexture) {
        ModelUtils.registerAtlasStitchedEventListener(false, InventoryMenu.BLOCK_ATLAS, event -> {
            TextureAtlas atlas = event.getAtlas();
            this.sprite = atlas.getSprite(texture);
            if (emissiveTexture != null) {
                this.emissiveSprite = atlas.getSprite(emissiveTexture);
            } else {
                ResourceLocation emissiveTex = texture.withSuffix("_emissive");
                if (atlas.getTextureLocations().contains(emissiveTex)) {
                    this.emissiveSprite = atlas.getSprite(emissiveTex);
                }
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderCover(List<BakedQuad> quads, Direction side, RandomSource rand, @NotNull CoverBehavior coverBehavior, BlockPos pos, BlockAndTintGetter level, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (side == null || side == coverBehavior.attachedSide) {
            quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.COVER_OVERLAY, coverBehavior.attachedSide, this.sprite));
            if (this.emissiveSprite != null) {
                quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.COVER_OVERLAY, coverBehavior.attachedSide, this.emissiveSprite));
            }
        }
    }
}

