/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.item.decorator;

import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Range;

public class GTTankItemFluidPreview
implements IItemDecorator {
    public static final GTTankItemFluidPreview DRUM = new GTTankItemFluidPreview(){

        @Override
        public boolean render(GuiGraphics guiGraphics, Font font, ItemStack itemStack, int x, int y) {
            if (!ConfigHolder.INSTANCE.client.tankItemFluidPreview.drum) {
                return false;
            }
            return super.render(guiGraphics, font, itemStack, x, y);
        }
    };
    public static final GTTankItemFluidPreview QUANTUM_TANK = new GTTankItemFluidPreview(){

        @Override
        public boolean render(GuiGraphics guiGraphics, Font font, ItemStack itemStack, int x, int y) {
            if (!ConfigHolder.INSTANCE.client.tankItemFluidPreview.quantumTank) {
                return false;
            }
            return super.render(guiGraphics, font, itemStack, x, y);
        }
    };
    private static final float[][] OFFSET = new float[][]{{8.0f, 8.0f}, {0.0f, 8.0f}, {8.0f, 0.0f}, {0.0f, 0.0f}};
    private @Range(from=0L, to=4L) int maxRenderCount = 1;
    private boolean renderOnTopOfItem = true;
    private boolean requireShiftKeyDown = false;

    public void setMaxRenderCount(int maxRenderCount) {
        if (maxRenderCount < 0 || maxRenderCount > 4) {
            throw new IllegalArgumentException("maxRenderCount must be between 0 and 4");
        }
        this.maxRenderCount = maxRenderCount;
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack itemStack, int x, int y) {
        if (this.isRequireShiftKeyDown() && !GTUtil.isShiftDown()) {
            return false;
        }
        Optional optional = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (optional.isEmpty()) {
            return false;
        }
        if (this.isRenderOnTopOfItem()) {
            RenderSystem.disableDepthTest();
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)optional.get();
        int renderedCount = 0;
        for (int index = 0; index < fluidHandler.getTanks() && renderedCount < this.getMaxRenderCount(); ++index) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(index);
            if (fluidInTank.isEmpty()) continue;
            DrawerHelper.drawFluidForGui((GuiGraphics)guiGraphics, (com.lowdragmc.lowdraglib.side.fluid.FluidStack)FluidHelperImpl.toFluidStack((FluidStack)fluidInTank), (float)((float)x + OFFSET[renderedCount][0]), (float)((float)y + OFFSET[renderedCount][1]), (float)8.0f, (float)8.0f);
            ++renderedCount;
        }
        return true;
    }

    @Generated
    public int getMaxRenderCount() {
        return this.maxRenderCount;
    }

    @Generated
    public boolean isRenderOnTopOfItem() {
        return this.renderOnTopOfItem;
    }

    @Generated
    public void setRenderOnTopOfItem(boolean renderOnTopOfItem) {
        this.renderOnTopOfItem = renderOnTopOfItem;
    }

    @Generated
    public boolean isRequireShiftKeyDown() {
        return this.requireShiftKeyDown;
    }

    @Generated
    public void setRequireShiftKeyDown(boolean requireShiftKeyDown) {
        this.requireShiftKeyDown = requireShiftKeyDown;
    }
}

