/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.machine.feature.multiblock.IFluidRenderMulti;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.RenderTypeHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class FluidAreaRender
extends DynamicRender<IFluidRenderMulti, FluidAreaRender> {
    public static final List<RelativeDirection> DEFAULT_FACES = Collections.singletonList(RelativeDirection.UP);
    public static final Codec<FluidAreaRender> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidBlockRenderer.CODEC.forGetter(FluidAreaRender::getFluidBlockRenderer), (App)BuiltInRegistries.FLUID.byNameCodec().optionalFieldOf("fixed_fluid").forGetter(FluidAreaRender::getFixedFluid), (App)RelativeDirection.CODEC.listOf().optionalFieldOf("drawn_faces", DEFAULT_FACES).forGetter(FluidAreaRender::getDrawFaces)).apply((Applicative)instance, FluidAreaRender::new));
    public static final DynamicRenderType<IFluidRenderMulti, FluidAreaRender> TYPE = new DynamicRenderType(CODEC);
    private final FluidBlockRenderer fluidBlockRenderer;
    private final boolean fixedFluid;
    private final List<RelativeDirection> drawFaces;
    @Nullable
    private Fluid cachedFluid;
    @Nullable
    private ResourceLocation cachedRecipe;

    public FluidAreaRender(FluidBlockRenderer fluidBlockRenderer, Optional<Fluid> fixedFluid, List<RelativeDirection> drawFaces) {
        this.fluidBlockRenderer = fluidBlockRenderer;
        if (fixedFluid.isPresent()) {
            this.fixedFluid = true;
            this.cachedFluid = fixedFluid.get();
        } else {
            this.fixedFluid = false;
        }
        this.drawFaces = drawFaces.isEmpty() ? DEFAULT_FACES : drawFaces;
    }

    @Override
    public DynamicRenderType<IFluidRenderMulti, FluidAreaRender> getType() {
        return TYPE;
    }

    @Override
    public int getViewDistance() {
        return 32;
    }

    @Override
    public void render(IFluidRenderMulti machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!ConfigHolder.INSTANCE.client.renderer.renderFluids) {
            return;
        }
        if (!machine.isFormed() || machine.getFluidOffsets() == null) {
            return;
        }
        if (!this.fixedFluid) {
            GTRecipe lastRecipe = machine.getRecipeLogic().getLastRecipe();
            if (lastRecipe == null) {
                this.cachedRecipe = null;
                this.cachedFluid = null;
            } else if (machine.self().getOffsetTimer() % 20L == 0L || lastRecipe.id != this.cachedRecipe) {
                this.cachedRecipe = lastRecipe.id;
                this.cachedFluid = machine.isActive() ? RenderUtil.getRecipeFluidToRender(lastRecipe) : null;
            }
        }
        if (this.cachedFluid == null) {
            return;
        }
        RenderType fluidRenderType = ItemBlockRenderTypes.getRenderLayer((FluidState)this.cachedFluid.defaultFluidState());
        VertexConsumer consumer = buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)fluidRenderType, (boolean)false));
        for (RelativeDirection face : this.drawFaces) {
            poseStack.pushPose();
            Matrix4f pose = poseStack.last().pose();
            Direction dir = face.getRelative(machine.self().getFrontFacing(), machine.self().getUpwardsFacing(), machine.self().isFlipped());
            if (dir.getAxis() != Direction.Axis.Y) {
                dir = dir.getOpposite();
            }
            this.fluidBlockRenderer.drawPlane(dir, machine.getFluidOffsets(), pose, consumer, this.cachedFluid, RenderUtil.FluidTextureType.STILL, packedOverlay, machine.self().getPos());
            poseStack.popPose();
        }
    }

    private Optional<Fluid> getFixedFluid() {
        if (this.fixedFluid) {
            return Optional.ofNullable(this.cachedFluid);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldRenderOffScreen(IFluidRenderMulti machine) {
        return true;
    }

    @Override
    public AABB getRenderBoundingBox(IFluidRenderMulti machine) {
        AABB box = super.getRenderBoundingBox(machine);
        Set<BlockPos> offsets = machine.getFluidOffsets();
        for (BlockPos offset : offsets) {
            box = box.minmax(new AABB(offset));
        }
        return box.inflate((double)this.getViewDistance());
    }

    @Generated
    public FluidBlockRenderer getFluidBlockRenderer() {
        return this.fluidBlockRenderer;
    }

    @Generated
    public List<RelativeDirection> getDrawFaces() {
        return this.drawFaces;
    }
}

