/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.mojang.math.Transformation;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockMath;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.QuadTransformers;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class StaticFaceBakery {
    public static final AABB SLIGHTLY_OVER_BLOCK = new AABB((double)-0.001f, (double)-0.001f, (double)-0.001f, (double)1.001f, (double)1.001f, (double)1.001f);
    public static final AABB OUTPUT_OVERLAY = new AABB((double)-0.006f, (double)-0.006f, (double)-0.006f, (double)1.006f, (double)1.006f, (double)1.006f);
    public static final AABB AUTO_OUTPUT_OVERLAY = new AABB((double)-0.008f, (double)-0.008f, (double)-0.008f, (double)1.008f, (double)1.008f, (double)1.008f);
    public static final AABB COVER_OVERLAY = new AABB((double)-0.008f, (double)-0.008f, (double)-0.008f, (double)1.008f, (double)1.008f, (double)1.008f);
    private static final int VERTEX_INT_SIZE = 8;
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    private static final int VERTEX_COUNT = 4;
    private static final int POSITION_INDEX = 0;
    private static final int COLOR_INDEX = 3;
    private static final int UV_INDEX = 4;

    public static BakedQuad bakeFace(AABB cube, Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity, boolean cull, boolean shade) {
        return StaticFaceBakery.bakeQuad(new Vector3f((float)cube.minX * 16.0f, (float)cube.minY * 16.0f, (float)cube.minZ * 16.0f), new Vector3f((float)cube.maxX * 16.0f, (float)cube.maxY * 16.0f, (float)cube.maxZ * 16.0f), new BlockElementFace((Direction)(cull ? face : null), tintIndex, sprite.contents().name().toString(), new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)), sprite, face, rotation, null, shade, emissivity);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity, boolean cull, boolean shade) {
        return StaticFaceBakery.bakeFace(FaceQuad.BLOCK, face, sprite, rotation, tintIndex, emissivity, cull, shade);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex, int emissivity) {
        return StaticFaceBakery.bakeFace(face, sprite, rotation, tintIndex, emissivity, true, true);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation, int tintIndex) {
        return StaticFaceBakery.bakeFace(face, sprite, rotation, tintIndex, 0);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite, ModelState rotation) {
        return StaticFaceBakery.bakeFace(face, sprite, rotation, -1);
    }

    public static BakedQuad bakeFace(Direction face, TextureAtlasSprite sprite) {
        return StaticFaceBakery.bakeFace(face, sprite, (ModelState)BlockModelRotation.X0_Y0);
    }

    public static BakedQuad bakeFace(AABB cube, Direction face, TextureAtlasSprite sprite) {
        return StaticFaceBakery.bakeFace(cube, face, sprite, (ModelState)BlockModelRotation.X0_Y0, -1, 0, true, true);
    }

    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transform, @Nullable BlockElementRotation partRotation, boolean shade, int emissivity) {
        BlockFaceUV uvs = face.uv;
        if (transform.isUvLocked()) {
            uvs = StaticFaceBakery.recomputeUVs(face.uv, facing, transform.getRotation());
        }
        float[] originalUVs = new float[uvs.uvs.length];
        System.arraycopy(uvs.uvs, 0, originalUVs, 0, originalUVs.length);
        float shrinkRatio = sprite.uvShrinkRatio();
        float uMiddle = (uvs.uvs[0] * 2.0f + uvs.uvs[2] * 2.0f) / 4.0f;
        float vMiddle = (uvs.uvs[1] * 2.0f + uvs.uvs[3] * 2.0f) / 4.0f;
        uvs.uvs[0] = Mth.lerp((float)shrinkRatio, (float)uvs.uvs[0], (float)uMiddle);
        uvs.uvs[2] = Mth.lerp((float)shrinkRatio, (float)uvs.uvs[2], (float)uMiddle);
        uvs.uvs[1] = Mth.lerp((float)shrinkRatio, (float)uvs.uvs[1], (float)vMiddle);
        uvs.uvs[3] = Mth.lerp((float)shrinkRatio, (float)uvs.uvs[3], (float)vMiddle);
        int[] vertices = StaticFaceBakery.makeVertices(uvs, sprite, facing, StaticFaceBakery.setupShape(posFrom, posTo), transform.getRotation(), partRotation, shade);
        Direction direction = FaceBakery.calculateFacing((int[])vertices);
        System.arraycopy(originalUVs, 0, uvs.uvs, 0, originalUVs.length);
        if (partRotation == null) {
            StaticFaceBakery.recalculateWinding(vertices, direction);
        }
        ForgeHooksClient.fillNormal((int[])vertices, (Direction)direction);
        ForgeFaceData data = face.getFaceData();
        BakedQuad quad = new BakedQuad(vertices, face.tintIndex, direction, sprite, shade, data.ambientOcclusion());
        if (!ForgeFaceData.DEFAULT.equals((Object)data)) {
            QuadTransformers.applyingLightmap((int)data.blockLight(), (int)data.skyLight()).processInPlace(quad);
            QuadTransformers.applyingColor((int)data.color()).processInPlace(quad);
        }
        if (emissivity > 0) {
            QuadTransformers.settingEmissivity((int)emissivity).processInPlace(quad);
        }
        return quad.gtceu$setTextureKey(face.texture);
    }

    public static BlockFaceUV recomputeUVs(BlockFaceUV uv, Direction facing, Transformation modelRotation) {
        float vMax;
        float vMin;
        float uMax;
        float uMin;
        Matrix4f uvLock = BlockMath.getUVLockTransform((Transformation)modelRotation, (Direction)facing, () -> "Unable to resolve UVLock for model").getMatrix();
        float maybeUMin = uv.getU(uv.getReverseIndex(0));
        float maybeVMin = uv.getV(uv.getReverseIndex(0));
        Vector4f lockedUVMin = uvLock.transform(new Vector4f(maybeUMin / 16.0f, maybeVMin / 16.0f, 0.0f, 1.0f));
        float uMinScaled = 16.0f * lockedUVMin.x();
        float vMinScaled = 16.0f * lockedUVMin.y();
        float maybeUMax = uv.getU(uv.getReverseIndex(2));
        float maybeVMax = uv.getV(uv.getReverseIndex(2));
        Vector4f lockedUVMax = uvLock.transform(new Vector4f(maybeUMax / 16.0f, maybeVMax / 16.0f, 0.0f, 1.0f));
        float uMaxScaled = 16.0f * lockedUVMax.x();
        float vMaxScaled = 16.0f * lockedUVMax.y();
        if (Math.signum(maybeUMax - maybeUMin) == Math.signum(uMaxScaled - uMinScaled)) {
            uMin = uMinScaled;
            uMax = uMaxScaled;
        } else {
            uMin = uMaxScaled;
            uMax = uMinScaled;
        }
        if (Math.signum(maybeVMax - maybeVMin) == Math.signum(vMaxScaled - vMinScaled)) {
            vMin = vMinScaled;
            vMax = vMaxScaled;
        } else {
            vMin = vMaxScaled;
            vMax = vMinScaled;
        }
        float rotation = (float)Math.toRadians(uv.rotation);
        Matrix3f uvMat3 = new Matrix3f((Matrix4fc)uvLock);
        Vector3f rotVector = uvMat3.transform(new Vector3f(Mth.cos((float)rotation), Mth.sin((float)rotation), 0.0f));
        int rotationDegrees = Math.floorMod(-((int)Math.round(Math.toDegrees(Math.atan2(rotVector.y(), rotVector.x())) / 90.0)) * 90, 360);
        return new BlockFaceUV(new float[]{uMin, vMin, uMax, vMax}, rotationDegrees);
    }

    private static int[] makeVertices(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] shape, Transformation rotation, @Nullable BlockElementRotation partRotation, boolean shade) {
        int[] vert = new int[32];
        for (int i = 0; i < 4; ++i) {
            StaticFaceBakery.bakeVertex(vert, i, orientation, uvs, sprite, shape, rotation, partRotation, shade);
        }
        return vert;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUV, TextureAtlasSprite sprite, float[] shape, Transformation rotation, @Nullable BlockElementRotation partRotation, boolean shade) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.fromFacing((Direction)facing).getVertexInfo(vertexIndex);
        Vector3f face = new Vector3f(shape[vertexInfo.xFace], shape[vertexInfo.yFace], shape[vertexInfo.zFace]);
        StaticFaceBakery.applyElementRotation(face, partRotation);
        StaticFaceBakery.applyModelRotation(face, rotation);
        StaticFaceBakery.fillVertex(vertexData, vertexIndex, face, sprite, blockFaceUV);
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f face, TextureAtlasSprite sprite, BlockFaceUV blockFaceUV) {
        int i = vertexIndex * 8;
        vertexData[i + 0] = Float.floatToRawIntBits(face.x());
        vertexData[i + 0 + 1] = Float.floatToRawIntBits(face.y());
        vertexData[i + 0 + 2] = Float.floatToRawIntBits(face.z());
        vertexData[i + 3] = -1;
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.getU((double)blockFaceUV.getU(vertexIndex) * 0.999 + (double)blockFaceUV.getU((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 4 + 1] = Float.floatToRawIntBits(sprite.getV((double)blockFaceUV.getV(vertexIndex) * 0.999 + (double)blockFaceUV.getV((vertexIndex + 2) % 4) * 0.001));
    }

    private static float[] setupShape(Vector3f min, Vector3f max) {
        float[] shape = new float[Direction.values().length];
        shape[FaceInfo.Constants.MIN_X] = min.x() / 16.0f;
        shape[FaceInfo.Constants.MIN_Y] = min.y() / 16.0f;
        shape[FaceInfo.Constants.MIN_Z] = min.z() / 16.0f;
        shape[FaceInfo.Constants.MAX_X] = max.x() / 16.0f;
        shape[FaceInfo.Constants.MAX_Y] = max.y() / 16.0f;
        shape[FaceInfo.Constants.MAX_Z] = max.z() / 16.0f;
        return shape;
    }

    private static void applyElementRotation(Vector3f vec, @Nullable BlockElementRotation partRotation) {
        if (partRotation != null) {
            Vector3f axis;
            Vector3f scale = switch (partRotation.axis()) {
                case Direction.Axis.X -> {
                    axis = new Vector3f(1.0f, 0.0f, 0.0f);
                    yield new Vector3f(0.0f, 1.0f, 1.0f);
                }
                case Direction.Axis.Y -> {
                    axis = new Vector3f(0.0f, 1.0f, 0.0f);
                    yield new Vector3f(1.0f, 0.0f, 1.0f);
                }
                case Direction.Axis.Z -> {
                    axis = new Vector3f(0.0f, 0.0f, 1.0f);
                    yield new Vector3f(1.0f, 1.0f, 0.0f);
                }
                default -> throw new IllegalArgumentException("There are only 3 axes");
            };
            Quaternionf rotation = new Quaternionf().rotationAxis(partRotation.angle() * ((float)Math.PI / 180), (Vector3fc)axis);
            if (partRotation.rescale()) {
                if (Math.abs(partRotation.angle()) == 22.5f) {
                    scale.mul(RESCALE_22_5);
                } else {
                    scale.mul(RESCALE_45);
                }
                scale.add(1.0f, 1.0f, 1.0f);
            } else {
                scale.set(1.0f, 1.0f, 1.0f);
            }
            StaticFaceBakery.rotateVertexBy(vec, new Vector3f((Vector3fc)partRotation.origin()), new Matrix4f().rotation((Quaternionfc)rotation), scale);
        }
    }

    public static void applyModelRotation(Vector3f pos, Transformation transform) {
        if (transform != Transformation.identity()) {
            StaticFaceBakery.rotateVertexBy(pos, new Vector3f(0.5f, 0.5f, 0.5f), transform.getMatrix(), new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    private static void rotateVertexBy(Vector3f pos, Vector3f origin, Matrix4f transform, Vector3f scale) {
        Vector4f transformed = new Vector4f(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z(), 1.0f).mul((Matrix4fc)transform);
        transformed.mul((Vector4fc)new Vector4f((Vector3fc)scale, 1.0f));
        pos.set(transformed.x() + origin.x(), transformed.y() + origin.y(), transformed.z() + origin.z());
    }

    private static void recalculateWinding(int[] vertices, Direction direction) {
        int[] verticesCopy = new int[vertices.length];
        System.arraycopy(vertices, 0, verticesCopy, 0, vertices.length);
        float[] shape = new float[Direction.values().length];
        shape[FaceInfo.Constants.MIN_X] = 999.0f;
        shape[FaceInfo.Constants.MIN_Y] = 999.0f;
        shape[FaceInfo.Constants.MIN_Z] = 999.0f;
        shape[FaceInfo.Constants.MAX_X] = -999.0f;
        shape[FaceInfo.Constants.MAX_Y] = -999.0f;
        shape[FaceInfo.Constants.MAX_Z] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int element = 8 * i;
            float x = Float.intBitsToFloat(verticesCopy[element]);
            float y = Float.intBitsToFloat(verticesCopy[element + 1]);
            float z = Float.intBitsToFloat(verticesCopy[element + 2]);
            if (x < shape[FaceInfo.Constants.MIN_X]) {
                shape[FaceInfo.Constants.MIN_X] = x;
            }
            if (y < shape[FaceInfo.Constants.MIN_Y]) {
                shape[FaceInfo.Constants.MIN_Y] = y;
            }
            if (z < shape[FaceInfo.Constants.MIN_Z]) {
                shape[FaceInfo.Constants.MIN_Z] = z;
            }
            if (x > shape[FaceInfo.Constants.MAX_X]) {
                shape[FaceInfo.Constants.MAX_X] = x;
            }
            if (y > shape[FaceInfo.Constants.MAX_Y]) {
                shape[FaceInfo.Constants.MAX_Y] = y;
            }
            if (!(z > shape[FaceInfo.Constants.MAX_Z])) continue;
            shape[FaceInfo.Constants.MAX_Z] = z;
        }
        FaceInfo faceInfo = FaceInfo.fromFacing((Direction)direction);
        for (int vert1 = 0; vert1 < 4; ++vert1) {
            int e1 = vert1 * 8;
            FaceInfo.VertexInfo vertexInfo = faceInfo.getVertexInfo(vert1);
            float x1 = shape[vertexInfo.xFace];
            float y1 = shape[vertexInfo.yFace];
            float z1 = shape[vertexInfo.zFace];
            vertices[e1 + 0] = Float.floatToRawIntBits(x1);
            vertices[e1 + 0 + 1] = Float.floatToRawIntBits(y1);
            vertices[e1 + 0 + 2] = Float.floatToRawIntBits(z1);
            for (int vert2 = 0; vert2 < 4; ++vert2) {
                int e2 = vert2 * 8;
                float x2 = Float.intBitsToFloat(verticesCopy[e2 + 0]);
                float y2 = Float.intBitsToFloat(verticesCopy[e2 + 0 + 1]);
                float z2 = Float.intBitsToFloat(verticesCopy[e2 + 0 + 2]);
                if (!Mth.equal((float)x1, (float)x2) || !Mth.equal((float)y1, (float)y2) || !Mth.equal((float)z1, (float)z2)) continue;
                vertices[e1 + 4] = verticesCopy[e2 + 4];
                vertices[e1 + 4 + 1] = verticesCopy[e2 + 4 + 1];
            }
        }
    }
}

