/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BatteryBlock
extends Block {
    private final IBatteryData data;

    public BatteryBlock(BlockBehaviour.Properties properties, IBatteryData data) {
        super(properties);
        this.data = data;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        if (this.data.getTier() == -1) {
            tooltip.add((Component)Component.translatable((String)"block.gtceu.substation_capacitor.tooltip_empty"));
        } else {
            tooltip.add((Component)Component.translatable((String)"block.gtceu.substation_capacitor.tooltip_filled", (Object[])new Object[]{FormattingUtil.formatNumbers(this.data.getCapacity())}));
        }
    }

    @Generated
    public IBatteryData getData() {
        return this.data;
    }

    @MethodsReturnNonnullByDefault
    public static enum BatteryPartType implements StringRepresentable,
    IBatteryData
    {
        EMPTY_TIER_I,
        EV_LAPOTRONIC(4, 150000000L),
        IV_LAPOTRONIC(5, 1500000000L),
        EMPTY_TIER_II,
        LuV_LAPOTRONIC(6, 6000000000L),
        ZPM_LAPOTRONIC(7, 24000000000L),
        EMPTY_TIER_III,
        UV_LAPOTRONIC(8, 96000000000L),
        UHV_ULTIMATE(9, Long.MAX_VALUE);

        private final int tier;
        private final long capacity;

        private BatteryPartType() {
            this.tier = -1;
            this.capacity = 0L;
        }

        private BatteryPartType(int tier, long capacity) {
            this.tier = tier;
            this.capacity = capacity;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        public String getBatteryName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getSerializedName() {
            return this.getBatteryName();
        }
    }
}

