/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.client.renderer.block.LampRenderer;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LampBlock
extends Block
implements IBlockRendererProvider {
    public static final BooleanProperty BLOOM = GTBlockStateProperties.BLOOM;
    public static final BooleanProperty LIGHT = BlockStateProperties.LIT;
    public static final BooleanProperty INVERTED = GTBlockStateProperties.INVERTED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final String TAG_INVERTED = "inverted";
    public static final String TAG_BLOOM = "bloom";
    public static final String TAG_LIT = "lit";
    public static final int BLOOM_FLAG = 1;
    public static final int LIGHT_FLAG = 2;
    public static final int INVERTED_FLAG = 4;
    public static final int POWERED_FLAG = 8;
    public final DyeColor color;
    public final boolean bordered;
    private final Map<BlockState, LampRenderer> renderers = new IdentityHashMap<BlockState, LampRenderer>();

    public LampBlock(BlockBehaviour.Properties properties, DyeColor color, boolean bordered) {
        super(properties);
        this.color = color;
        this.bordered = bordered;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)GTBlockStateProperties.BLOOM, (Comparable)Boolean.valueOf(true))).setValue((Property)LIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)INVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        for (BlockState state : this.getStateDefinition().getPossibleStates()) {
            this.renderers.put(state, new LampRenderer(this, state));
        }
    }

    public static boolean isLightActive(BlockState state) {
        return state.getValue((Property)INVERTED) != state.getValue((Property)POWERED);
    }

    public static boolean isInverted(BlockState state) {
        return (Boolean)state.getValue((Property)INVERTED);
    }

    public static boolean isLightEnabled(BlockState state) {
        return (Boolean)state.getValue((Property)LIGHT);
    }

    public static boolean isBloomEnabled(BlockState state) {
        return (Boolean)state.getValue((Property)GTBlockStateProperties.BLOOM);
    }

    public static boolean isInverted(CompoundTag tag) {
        return tag.getBoolean(TAG_INVERTED);
    }

    public static boolean isLightEnabled(CompoundTag tag) {
        return tag.getBoolean(TAG_LIT);
    }

    public static boolean isBloomEnabled(CompoundTag tag) {
        return tag.getBoolean(TAG_BLOOM);
    }

    public CompoundTag getTagFromState(BlockState state) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(TAG_BLOOM, ((Boolean)state.getValue((Property)GTBlockStateProperties.BLOOM)).booleanValue());
        tag.putBoolean(TAG_LIT, ((Boolean)state.getValue((Property)LIGHT)).booleanValue());
        tag.putBoolean(TAG_INVERTED, ((Boolean)state.getValue((Property)INVERTED)).booleanValue());
        return tag;
    }

    public ItemStack getStackFromIndex(int i) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(TAG_INVERTED, (i & 4) == 0);
        tag.putBoolean(TAG_BLOOM, (i & 1) == 0);
        tag.putBoolean(TAG_LIT, (i & 2) == 0);
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.setTag(tag);
        return stack;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{INVERTED, GTBlockStateProperties.BLOOM, LIGHT, POWERED}));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIGHT) != false && LampBlock.isLightActive(state) ? 15 : 0;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        boolean powered;
        if (!level.isClientSide && (powered = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(!powered)), (Boolean)state.getValue((Property)LIGHT) != false ? 10 : 2);
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean powered;
        if (!level.isClientSide && (powered = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(!powered)), (Boolean)state.getValue((Property)LIGHT) != false ? 10 : 2);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), (Boolean)state.getValue((Property)LIGHT) != false ? 10 : 2);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        stack.setTag(this.getTagFromState(state));
        return stack;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.hasTag()) {
            CompoundTag tag = stack.getTag();
            if (LampBlock.isInverted(tag)) {
                tooltip.add((Component)Component.translatable((String)"block.gtceu.lamp.tooltip.inverted"));
            }
            if (!LampBlock.isBloomEnabled(tag)) {
                tooltip.add((Component)Component.translatable((String)"block.gtceu.lamp.tooltip.no_bloom"));
            }
            if (!LampBlock.isLightEnabled(tag)) {
                tooltip.add((Component)Component.translatable((String)"block.gtceu.lamp.tooltip.no_light"));
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List returnValue = super.getDrops(state, params);
        for (ItemStack stack : returnValue) {
            if (!stack.is(this.asItem())) continue;
            stack.setTag(this.getTagFromState(state));
            break;
        }
        return returnValue;
    }

    @Nullable
    public IRenderer getRenderer(BlockState state) {
        return (IRenderer)this.renderers.get(state);
    }
}

