/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.SurfaceRockBlockItem;
import com.gregtechceu.gtceu.client.renderer.block.SurfaceRockRenderer;
import com.gregtechceu.gtceu.integration.map.cache.server.ServerCache;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SurfaceRockBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape AABB_NORTH = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)3.0);
    private static final VoxelShape AABB_SOUTH = Block.box((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.box((double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0);
    private static final VoxelShape AABB_EAST = Block.box((double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape AABB_UP = Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape AABB_DOWN = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    private final Material material;

    public SurfaceRockBlock(BlockBehaviour.Properties properties, Material material) {
        super(properties);
        this.material = material;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN));
        if (GTCEu.isClientSide()) {
            SurfaceRockRenderer.create(this);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide) {
            ServerCache.instance.prospectSurfaceRockMaterial((ResourceKey<Level>)level.dimension(), this.material, pos, (ServerPlayer)player);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide) {
            ServerCache.instance.prospectSurfaceRockMaterial((ResourceKey<Level>)level.dimension(), this.material, pos, (ServerPlayer)player);
        }
        if (level.destroyBlock(pos, true, (Entity)player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> AABB_DOWN;
            case Direction.UP -> AABB_UP;
            case Direction.NORTH -> AABB_NORTH;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.WEST -> AABB_WEST;
            case Direction.EAST -> AABB_EAST;
        };
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter view, BlockPos pos) {
        return false;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos attachedBlock = pos.relative(facing);
        return level.getBlockState(attachedBlock).isFaceSturdy((BlockGetter)level, attachedBlock, facing.getOpposite());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            Block.updateOrDestroy((BlockState)state, (BlockState)Blocks.AIR.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos, (int)3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForDirection(context.getNearestLookingVerticalDirection());
    }

    public BlockState getStateForDirection(Direction direction) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedBlockColor() {
        return (state, reader, pos, tintIndex) -> {
            Block patt6139$temp = state.getBlock();
            if (patt6139$temp instanceof SurfaceRockBlock) {
                SurfaceRockBlock block = (SurfaceRockBlock)patt6139$temp;
                return block.material.getMaterialRGB();
            }
            return -1;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintedItemColor() {
        return (stack, tintIndex) -> {
            Item patt6431$temp = stack.getItem();
            if (patt6431$temp instanceof SurfaceRockBlockItem) {
                SurfaceRockBlockItem surfaceRock = (SurfaceRockBlockItem)patt6431$temp;
                return surfaceRock.getMat().getMaterialRGB();
            }
            return -1;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public String getDescriptionId() {
        return "block.surface_rock";
    }

    public MutableComponent getName() {
        return Component.translatable((String)"block.surface_rock", (Object[])new Object[]{this.material.getLocalizedName()});
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }
}

