/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.pipelike.cable.AveragingPerTickCounter;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNet;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNetHandler;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.cable.LevelEnergyNet;
import com.gregtechceu.gtceu.common.pipelike.cable.PerTickLongCounter;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CableBlockEntity
extends PipeBlockEntity<Insulation, WireProperties>
implements IDataInfoProvider {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CableBlockEntity.class, PipeBlockEntity.MANAGED_FIELD_HOLDER);
    protected WeakReference<EnergyNet> currentEnergyNet = new WeakReference<Object>(null);
    private static final int meltTemp = 3000;
    private final EnumMap<Direction, EnergyNetHandler> handlers = new EnumMap(Direction.class);
    private final PerTickLongCounter maxVoltageCounter = new PerTickLongCounter();
    private final AveragingPerTickCounter averageVoltageCounter = new AveragingPerTickCounter();
    private final AveragingPerTickCounter averageAmperageCounter = new AveragingPerTickCounter();
    private EnergyNetHandler defaultHandler;
    private int heatQueue;
    @Persisted
    @DescSynced
    private int temperature = this.getDefaultTemp();
    private TickableSubscription heatSubs;

    public CableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static CableBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new CableBlockEntity(type, pos, blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            IEnergyContainer container = this.getEnergyContainer(side);
            if (container != null) {
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> container));
            }
        } else {
            if (cap == GTCapability.CAPABILITY_COVERABLE) {
                return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(this::getCoverContainer));
            }
            if (cap == GTCapability.CAPABILITY_TOOLABLE) {
                return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> this));
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.level != null) {
            if (this.level.getBlockEntity(this.getBlockPos().relative(side)) instanceof CableBlockEntity) {
                return false;
            }
            return GTCapabilityHelper.getEnergyContainer(this.level, this.getBlockPos().relative(side), side.getOpposite()) != null;
        }
        return false;
    }

    @Nullable
    private EnergyNet getEnergyNet() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EnergyNet currentEnergyNet = (EnergyNet)this.currentEnergyNet.get();
        if (currentEnergyNet != null && currentEnergyNet.isValid() && currentEnergyNet.containsNode(this.getBlockPos())) {
            return currentEnergyNet;
        }
        LevelEnergyNet worldENet = LevelEnergyNet.getOrCreate(serverLevel);
        currentEnergyNet = (EnergyNet)worldENet.getNetFromPos(this.getBlockPos());
        if (currentEnergyNet != null) {
            this.currentEnergyNet = new WeakReference<EnergyNet>(currentEnergyNet);
        }
        return currentEnergyNet;
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            EnergyNet current = this.getEnergyNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (EnergyNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    @Nullable
    public IEnergyContainer getEnergyContainer(@Nullable Direction side) {
        if (side != null && !this.isConnected(side)) {
            return null;
        }
        if (this.isRemote()) {
            return IEnergyContainer.DEFAULT;
        }
        if (this.handlers.isEmpty()) {
            this.initHandlers();
        }
        this.checkNetwork();
        return this.handlers.getOrDefault(side, this.defaultHandler);
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    private void initHandlers() {
        EnergyNet net = this.getEnergyNet();
        if (net == null) {
            return;
        }
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.handlers.put(facing, new EnergyNetHandler(net, this, facing));
        }
        this.defaultHandler = new EnergyNetHandler(net, this, null);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.setTemperature(this.temperature);
            if (this.temperature > this.getDefaultTemp()) {
                this.subscribeHeat();
            }
        }
    }

    private void subscribeHeat() {
        if (this.heatSubs == null) {
            this.heatSubs = this.subscribeServerTick(this::update);
        }
    }

    private void unsubscribeHeat() {
        if (this.heatSubs != null) {
            this.unsubscribe(this.heatSubs);
            this.heatSubs = null;
        }
    }

    public CableBlock getPipeBlock() {
        return (CableBlock)super.getPipeBlock();
    }

    public double getAverageAmperage() {
        return this.averageAmperageCounter.getAverage(this.getLevel());
    }

    public long getCurrentMaxVoltage() {
        return this.maxVoltageCounter.get(this.getLevel());
    }

    public double getAverageVoltage() {
        return this.averageVoltageCounter.getAverage(this.getLevel());
    }

    public long getMaxAmperage() {
        return ((WireProperties)this.getNodeData()).getAmperage();
    }

    public long getMaxVoltage() {
        return ((WireProperties)this.getNodeData()).getVoltage();
    }

    public int getDefaultTemp() {
        return 293;
    }

    public static int getMeltTemp() {
        return 3000;
    }

    public boolean incrementAmperage(long amps, long voltage) {
        if (voltage > this.maxVoltageCounter.get(this.getLevel())) {
            this.maxVoltageCounter.set(this.getLevel(), voltage);
        }
        this.averageVoltageCounter.increment(this.getLevel(), voltage * amps);
        this.averageAmperageCounter.increment(this.getLevel(), amps);
        int dif = GTMath.saturatedCast(this.averageAmperageCounter.getLast(this.getLevel()) - this.getMaxAmperage());
        if (dif > 0) {
            this.applyHeat(dif * 40);
            return true;
        }
        return false;
    }

    public void applyHeat(int amount) {
        this.heatQueue += amount;
        if (!this.level.isClientSide && this.heatSubs == null && this.temperature + this.heatQueue > this.getDefaultTemp()) {
            this.subscribeHeat();
        }
    }

    private boolean update() {
        if (this.heatQueue > 0) {
            this.setTemperature(this.temperature + this.heatQueue);
        }
        if (this.temperature >= 3000) {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.FIRE.defaultBlockState());
            return false;
        }
        if (this.temperature <= this.getDefaultTemp()) {
            this.unsubscribeHeat();
            return false;
        }
        if (((Insulation)this.getPipeType()).insulationLevel >= 0 && this.temperature >= 1500 && (double)GTValues.RNG.nextFloat() < 0.1) {
            this.uninsulate();
            return false;
        }
        if (this.heatQueue == 0) {
            this.setTemperature((int)((double)this.temperature - Math.pow(this.temperature - this.getDefaultTemp(), 0.35)));
        } else {
            this.heatQueue = 0;
        }
        return true;
    }

    private void uninsulate() {
        int temp = this.temperature;
        this.setTemperature(this.getDefaultTemp());
        int index = ((Insulation)this.getPipeType()).insulationLevel;
        CableBlock newBlock = (CableBlock)((Object)((BlockEntry)GTMaterialBlocks.CABLE_BLOCKS.get((Object)Insulation.values()[index].tagPrefix, (Object)this.getPipeBlock().material)).get());
        this.level.setBlockAndUpdate(this.getBlockPos(), newBlock.defaultBlockState());
        CableBlockEntity newCable = (CableBlockEntity)this.level.getBlockEntity(this.getBlockPos());
        if (newCable != null) {
            newCable.setTemperature(temp);
            newCable.subscribeHeat();
            for (Direction facing : GTUtil.DIRECTIONS) {
                if (!this.isConnected(facing)) continue;
                newCable.setConnection(facing, true, true);
            }
            newCable.setChanged();
            newCable.scheduleRenderUpdate();
        }
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
        this.level.getLightEngine().checkBlock(this.worldPosition);
        if (!this.level.isClientSide && temperature >= 3000) {
            Direction facing = Direction.UP;
            float xPos = (float)facing.getStepX() * 0.76f + (float)this.worldPosition.getX() + 0.25f;
            float yPos = (float)facing.getStepY() * 0.76f + (float)this.worldPosition.getY() + 0.25f;
            float zPos = (float)facing.getStepZ() * 0.76f + (float)this.worldPosition.getZ() + 0.25f;
            float ySpd = (float)facing.getStepY() * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat();
            float temp = GTValues.RNG.nextFloat() * 2.0f * (float)Math.PI;
            float xSpd = (float)Math.sin(temp) * 0.1f;
            float zSpd = (float)Math.cos(temp) * 0.1f;
            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)(xPos + GTValues.RNG.nextFloat() * 0.5f), (double)(yPos + GTValues.RNG.nextFloat() * 0.5f), (double)(zPos + GTValues.RNG.nextFloat() * 0.5f), 0, (double)xSpd, (double)ySpd, (double)zSpd, 1.0);
        }
    }

    public static void onBlockEntityRegister(BlockEntityType<CableBlockEntity> cableBlockEntityBlockEntityType) {
    }

    @Override
    public ResourceTexture getPipeTexture(boolean isBlock) {
        return isBlock ? GuiTextures.TOOL_WIRE_CONNECT : GuiTextures.TOOL_WIRE_BLOCK;
    }

    @Override
    public GTToolType getPipeTuneTool() {
        return GTToolType.WIRE_CUTTER;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_ELECTRICAL_INFO) {
            list.add((Component)Component.translatable((String)"behavior.portable_scanner.eu_per_sec", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(this.getAverageVoltage())).withStyle(ChatFormatting.RED)}));
            list.add((Component)Component.translatable((String)"behavior.portable_scanner.amp_per_sec", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(this.getAverageAmperage())).withStyle(ChatFormatting.RED)}));
        }
        return list;
    }

    @Generated
    public int getTemperature() {
        return this.temperature;
    }
}

