/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.misc.IOFluidHandlerList;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.PipeTankList;
import com.gregtechceu.gtceu.utils.EntityDamageUtil;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlockEntity
extends PipeBlockEntity<FluidPipeType, FluidPipeProperties>
implements IDataInfoProvider {
    public static final int FREQUENCY = 5;
    public byte lastReceivedFrom = 0;
    public byte oldLastReceivedFrom = 0;
    private PipeTankList pipeTankList;
    private final EnumMap<Direction, PipeTankList> tankLists = new EnumMap(Direction.class);
    private CustomFluidTank[] fluidTanks;
    private long timer = 0L;
    private final int offset = GTValues.RNG.nextInt(20);
    private TickableSubscription updateSubs;

    public FluidPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void onBlockEntityRegister(BlockEntityType<FluidPipeBlockEntity> fluidPipeBlockEntityBlockEntityType) {
    }

    @Override
    public long getOffsetTimer() {
        return this.timer + (long)this.offset;
    }

    public void onLoad() {
        super.onLoad();
        if (this.updateSubs == null) {
            this.updateSubs = this.subscribeServerTick(this::update);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.updateSubs != null) {
            this.unsubscribe(this.updateSubs);
            this.updateSubs = null;
        }
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.level != null) {
            if (this.level.getBlockEntity(this.getBlockPos().relative(side)) instanceof FluidPipeBlockEntity) {
                return false;
            }
            return GTTransferUtils.hasAdjacentFluidHandler(this.level, this.getBlockPos(), side);
        }
        return false;
    }

    private Predicate<FluidStack> getFluidCapFilter(@Nullable Direction side, IO io) {
        FluidFilterCover filterCover;
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover && (filterCover = (FluidFilterCover)cover).getFilterMode().filters(io)) {
            return filterCover.getFluidFilter();
        }
        return fluid -> true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (facing != null && this.isConnected(facing)) {
                PipeTankList tankList = this.getTankList(facing);
                if (tankList == null) {
                    return LazyOptional.empty();
                }
                IOFluidHandlerList list = new IOFluidHandlerList(List.of(tankList), IO.BOTH, this.getFluidCapFilter(facing, IO.IN), this.getFluidCapFilter(facing, IO.OUT));
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(capability, LazyOptional.of(() -> list));
            }
        } else {
            if (capability == GTCapability.CAPABILITY_COVERABLE) {
                return GTCapability.CAPABILITY_COVERABLE.orEmpty(capability, LazyOptional.of(this::getCoverContainer));
            }
            if (capability == GTCapability.CAPABILITY_TOOLABLE) {
                return GTCapability.CAPABILITY_TOOLABLE.orEmpty(capability, LazyOptional.of(() -> this));
            }
        }
        return super.getCapability(capability, facing);
    }

    public int getCapacityPerTank() {
        return ((FluidPipeProperties)this.getNodeData()).getThroughput() * 20;
    }

    public void update() {
        ++this.timer;
        if (!this.level.isClientSide && this.getOffsetTimer() % 5L == 0L) {
            this.lastReceivedFrom = (byte)(this.lastReceivedFrom & 0x3F);
            if (this.lastReceivedFrom == 63) {
                this.lastReceivedFrom = 0;
            }
            boolean shouldDistribute = this.oldLastReceivedFrom == this.lastReceivedFrom;
            int tanks = ((FluidPipeProperties)this.getNodeData()).getChannels();
            int j = GTValues.RNG.nextInt(tanks);
            for (int i = 0; i < tanks; ++i) {
                int index = (i + j) % tanks;
                CustomFluidTank tank = this.getFluidTanks()[index];
                FluidStack fluid = tank.getFluid();
                if (fluid.isEmpty() || fluid.getFluid() == Fluids.EMPTY) continue;
                if (fluid.getAmount() <= 0) {
                    tank.setFluid(FluidStack.EMPTY);
                    continue;
                }
                if (!shouldDistribute) continue;
                this.distributeFluid(index, tank, fluid);
                this.lastReceivedFrom = 0;
            }
            this.oldLastReceivedFrom = this.lastReceivedFrom;
        }
    }

    private void distributeFluid(int channel, CustomFluidTank tank, FluidStack fluid) {
        ArrayList<FluidTransaction> tanks = new ArrayList<FluidTransaction>();
        int amount = fluid.getAmount();
        FluidStack maxFluid = fluid.copy();
        double availableCapacity = 0.0;
        byte j = (byte)GTValues.RNG.nextInt(6);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            ICoverable coverable;
            IFluidHandler fluidHandler;
            BlockEntity neighbor;
            byte side = (byte)((i + j) % 6);
            Direction facing = GTUtil.DIRECTIONS[side];
            if (!this.isConnected(facing) || (this.lastReceivedFrom & 1 << side) != 0 || (neighbor = this.getNeighbor(facing)) == null || (fluidHandler = (IFluidHandler)neighbor.getCapability(ForgeCapabilities.FLUID_HANDLER, facing.getOpposite()).resolve().orElse(null)) == null) continue;
            IFluidHandlerModifiable pipeTank = tank;
            CoverBehavior cover = this.getCoverContainer().getCoverAtSide(facing);
            if (cover == null ? (coverable = (ICoverable)neighbor.getCapability(GTCapability.CAPABILITY_COVERABLE, facing.getOpposite()).resolve().orElse(null)) != null && this.checkForPumpCover(cover = coverable.getCoverAtSide(facing.getOpposite())) : (pipeTank = cover.getFluidHandlerCap(pipeTank)) == null || this.checkForPumpCover(cover)) continue;
            FluidStack drainable = pipeTank.drain(maxFluid, IFluidHandler.FluidAction.SIMULATE);
            if (drainable.isEmpty() || drainable.getAmount() <= 0) continue;
            int filled = Math.min(fluidHandler.fill(maxFluid, IFluidHandler.FluidAction.SIMULATE), drainable.getAmount());
            if (filled > 0) {
                tanks.add(new FluidTransaction(fluidHandler, pipeTank, filled));
                availableCapacity += (double)filled;
            }
            maxFluid.setAmount(amount);
        }
        if (availableCapacity <= 0.0) {
            return;
        }
        double maxAmount = Math.min(this.getCapacityPerTank() / 2, fluid.getAmount());
        for (FluidTransaction transaction : tanks) {
            FluidStack toInsert;
            if (availableCapacity > maxAmount) {
                transaction.amount = Mth.floor((double)((double)transaction.amount * maxAmount / availableCapacity));
            }
            if (transaction.amount == 0) {
                if (tank.getFluidAmount() <= 0) break;
                transaction.amount = 1;
            } else if (transaction.amount < 0) continue;
            if ((toInsert = fluid.copy()).isEmpty() || toInsert.getFluid() == Fluids.EMPTY) continue;
            toInsert.setAmount(transaction.amount);
            int inserted = transaction.target.fill(toInsert, IFluidHandler.FluidAction.EXECUTE);
            if (inserted <= 0) continue;
            transaction.pipeTank.drain(inserted, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean checkForPumpCover(@Nullable CoverBehavior cover) {
        if (cover instanceof PumpCover) {
            PumpCover coverPump = (PumpCover)cover;
            int pipeThroughput = ((FluidPipeProperties)this.getNodeData()).getThroughput() * 20;
            if (coverPump.getTransferRate() > pipeThroughput) {
                coverPump.setTransferRate(pipeThroughput);
            }
            return coverPump.getManualIOMode() == ManualIOMode.DISABLED;
        }
        return false;
    }

    public void checkAndDestroy(@NotNull FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidPipeProperties prop = (FluidPipeProperties)this.getNodeData();
        boolean burning = prop.getMaxFluidTemperature() < fluid.getFluidType().getTemperature(stack);
        boolean leaking = !prop.isGasProof() && fluid.getFluidType().getDensity(stack) < 0;
        boolean shattering = !prop.isCryoProof() && fluid.getFluidType().getTemperature(stack) < 120;
        boolean corroding = false;
        boolean melting = false;
        if (fluid instanceof GTFluid) {
            GTFluid attributedFluid = (GTFluid)fluid;
            FluidState state = attributedFluid.getState();
            if (!prop.canContain(state)) {
                leaking = state == FluidState.GAS;
                boolean bl = melting = state == FluidState.PLASMA;
            }
            if (burning && state == FluidState.PLASMA && prop.canContain(FluidState.PLASMA)) {
                burning = false;
            }
            for (FluidAttribute attribute : attributedFluid.getAttributes()) {
                if (prop.canContain(attribute)) continue;
                corroding = true;
            }
        }
        if (burning || leaking || corroding || shattering || melting) {
            this.destroyPipe(stack, burning, leaking, corroding, shattering, melting);
        }
    }

    public void destroyPipe(FluidStack stack, boolean isBurning, boolean isLeaking, boolean isCorroding, boolean isShattering, boolean isMelting) {
        List entities;
        if (this.getOffsetTimer() % 10L == 0L) {
            this.level.playSound(null, this.getPipePos(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (isLeaking) {
            FluidPipeBlockEntity.spawnParticles(this.level, this.worldPosition, Direction.UP, (ParticleOptions)ParticleTypes.SMOKE, 7 + GTValues.RNG.nextInt(2));
            stack.setAmount(Math.max(0, stack.getAmount() * 9 / 10));
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getPipePos()).inflate(2.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getFluidType().getTemperature(stack), 2.0f, 10);
                }
            }
            if (GTValues.RNG.nextInt(isBurning ? 3 : 7) == 0) {
                this.doExplosion(1.0f + GTValues.RNG.nextFloat());
            }
        }
        if (isCorroding) {
            FluidPipeBlockEntity.spawnParticles(this.getPipeLevel(), this.getPipePos(), Direction.UP, (ParticleOptions)ParticleTypes.CRIT, 3 + GTValues.RNG.nextInt(2));
            stack.setAmount(Math.max(0, stack.getAmount() * 3 / 4));
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getPipePos()).inflate(1.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyChemicalDamage(entityLivingBase, 2);
                }
            }
            if (GTValues.RNG.nextInt(10) == 0) {
                stack.setAmount(0);
                this.level.removeBlock(this.getPipePos(), false);
            }
        }
        if (isBurning || isMelting) {
            FluidPipeBlockEntity.spawnParticles(this.level, this.getBlockPos(), Direction.UP, (ParticleOptions)ParticleTypes.FLAME, (isMelting ? 7 : 3) + GTValues.RNG.nextInt(2));
            stack.setAmount(Math.max(0, stack.getAmount() / 4));
            if (GTValues.RNG.nextInt(4) == 0) {
                FluidPipeBlockEntity.setNeighboursToFire(this.level, this.getBlockPos());
            }
            if (isMelting && this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getPipePos()).inflate(2.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getFluidType().getTemperature(stack), 2.0f, 10);
                }
            }
            if (GTValues.RNG.nextInt(10) == 0) {
                stack.setAmount(0);
                this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.FIRE.defaultBlockState());
            }
        }
        if (isShattering) {
            FluidPipeBlockEntity.spawnParticles(this.level, this.getBlockPos(), Direction.UP, (ParticleOptions)ParticleTypes.CLOUD, 3 + GTValues.RNG.nextInt(2));
            stack.setAmount(Math.max(0, stack.getAmount() / 4));
            if (this.getOffsetTimer() % 20L == 0L) {
                entities = this.getPipeLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getPipePos()).inflate(2.0));
                for (LivingEntity entityLivingBase : entities) {
                    EntityDamageUtil.applyTemperatureDamage(entityLivingBase, stack.getFluid().getFluidType().getTemperature(stack), 2.0f, 10);
                }
            }
            if (GTValues.RNG.nextInt(10) == 0) {
                stack.setAmount(0);
                this.level.removeBlock(this.getBlockPos(), false);
            }
        }
    }

    public void receivedFrom(Direction facing) {
        if (facing != null) {
            this.lastReceivedFrom = (byte)(this.lastReceivedFrom | 1 << facing.ordinal());
        }
    }

    public FluidStack getContainedFluid(int channel) {
        if (channel < 0 || channel >= this.getFluidTanks().length) {
            return null;
        }
        return this.getFluidTanks()[channel].getFluid();
    }

    private void createTanksList() {
        this.fluidTanks = new CustomFluidTank[((FluidPipeProperties)this.getNodeData()).getChannels()];
        for (int i = 0; i < ((FluidPipeProperties)this.getNodeData()).getChannels(); ++i) {
            this.fluidTanks[i] = new CustomFluidTank(this.getCapacityPerTank());
        }
        this.pipeTankList = new PipeTankList(this, null, this.fluidTanks);
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.tankLists.put(facing, new PipeTankList(this, facing, this.fluidTanks));
        }
    }

    public PipeTankList getTankList() {
        if (this.pipeTankList == null || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.pipeTankList;
    }

    public PipeTankList getTankList(Direction facing) {
        if (this.tankLists.isEmpty() || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.tankLists.getOrDefault(facing, this.pipeTankList);
    }

    public CustomFluidTank[] getFluidTanks() {
        if (this.pipeTankList == null || this.fluidTanks == null) {
            this.createTanksList();
        }
        return this.fluidTanks;
    }

    public FluidStack[] getContainedFluids() {
        FluidStack[] fluids = new FluidStack[this.getFluidTanks().length];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = this.fluidTanks[i].getFluid();
        }
        return fluids;
    }

    public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        ListTag list = new ListTag();
        for (int i = 0; i < this.getFluidTanks().length; ++i) {
            FluidStack stack1 = this.getContainedFluid(i);
            CompoundTag fluidTag = new CompoundTag();
            if (stack1 == null || stack1.getAmount() <= 0) {
                fluidTag.putBoolean("isNull", true);
            } else {
                stack1.writeToNBT(fluidTag);
            }
            list.add((Object)fluidTag);
        }
        tag.put("Fluids", (Tag)list);
    }

    public void loadCustomPersistedData(CompoundTag nbt) {
        super.loadCustomPersistedData(nbt);
        ListTag list = nbt.getList("Fluids", 10);
        this.createTanksList();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            if (tag.getBoolean("isNull")) continue;
            this.fluidTanks[i].setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag));
        }
    }

    public static void spawnParticles(Level worldIn, BlockPos pos, Direction direction, ParticleOptions particleType, int particleCount) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            serverLevel.sendParticles(particleType, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, particleCount, (double)direction.getStepX() * 0.2 + GTValues.RNG.nextDouble() * 0.1, (double)direction.getStepY() * 0.2 + GTValues.RNG.nextDouble() * 0.1, (double)direction.getStepZ() * 0.2 + GTValues.RNG.nextDouble() * 0.1, 0.1);
        }
    }

    public static void setNeighboursToFire(Level world, BlockPos selfPos) {
        for (Direction side : GTUtil.DIRECTIONS) {
            if (!GTValues.RNG.nextBoolean()) continue;
            BlockPos blockPos = selfPos.relative(side);
            BlockState blockState = world.getBlockState(blockPos);
            if (!world.isEmptyBlock(blockPos) && !blockState.isFlammable((BlockGetter)world, blockPos, side.getOpposite())) continue;
            world.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
        }
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        FluidStack[] fluids;
        ArrayList<Component> list = new ArrayList<Component>();
        if ((mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_MACHINE_INFO) && (fluids = this.getContainedFluids()) != null) {
            boolean allTanksEmpty = true;
            for (int i = 0; i < fluids.length; ++i) {
                if (fluids[i] == null || fluids[i].getFluid() == null || fluids[i].isEmpty()) continue;
                allTanksEmpty = false;
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.tank", (Object[])new Object[]{i, Component.translatable((String)FormattingUtil.formatNumbers(fluids[i].getAmount())).withStyle(ChatFormatting.GREEN), Component.translatable((String)FormattingUtil.formatNumbers(this.getCapacityPerTank())).withStyle(ChatFormatting.YELLOW), fluids[i].getDisplayName().copy().withStyle(ChatFormatting.GOLD)}));
            }
            if (allTanksEmpty) {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.tanks_empty"));
            }
        }
        return list;
    }

    private static class FluidTransaction {
        public final IFluidHandler target;
        public final IFluidHandler pipeTank;
        public int amount;

        private FluidTransaction(IFluidHandler target, IFluidHandler pipeTank, int amount) {
            this.target = target;
            this.pipeTank = pipeTank;
            this.amount = amount;
        }
    }
}

