/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cosmetics.CapeRegistry;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OrePlacer;
import com.gregtechceu.gtceu.api.gui.factory.GTUIEditorFactory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.GTRegistry;
import com.gregtechceu.gtceu.common.commands.arguments.GTRegistryArgument;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.apache.logging.log4j.Logger;

public class GTCommands {
    public static final SuggestionProvider<CommandSourceStack> OWNED_CAPES = (ctx, builder) -> SharedSuggestionProvider.suggestResource(GTCommands.findOwnedCapesFor((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> NOT_OWNED_CAPES = (ctx, builder) -> SharedSuggestionProvider.suggestResource(GTCommands.findNotOwnedCapesFor((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder);
    public static final DynamicCommandExceptionType ERROR_NO_SUCH_CAPE = new DynamicCommandExceptionType(id -> Component.translatable((String)"command.gtceu.cape.failure.does_not_exist", (Object[])new Object[]{id}));
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.gtceu.cape.give.failed"));
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.gtceu.cape.take.failed"));
    private static final Dynamic2CommandExceptionType ERROR_USE_FAILED = new Dynamic2CommandExceptionType((player, cape) -> Component.translatable((String)"command.gtceu.cape.use.failed", (Object[])new Object[]{player, cape}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gtceu").then(((LiteralArgumentBuilder)Commands.literal((String)"ui_editor").requires(ctx -> ctx.hasPermission(3))).executes(context -> {
            GTUIEditorFactory.INSTANCE.openUI((Object)GTUIEditorFactory.INSTANCE, ((CommandSourceStack)context.getSource()).getPlayerOrException());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dump_data").requires(ctx -> ctx.hasPermission(4))).then(Commands.literal((String)"bedrock_fluid_veins").executes(context -> GTCommands.dumpDataRegistry((CommandContext<CommandSourceStack>)context, GTRegistries.BEDROCK_FLUID_DEFINITIONS, BedrockFluidDefinition.FULL_CODEC, "gtceu/fluid_veins")))).then(Commands.literal((String)"bedrock_ore_veins").executes(context -> GTCommands.dumpDataRegistry((CommandContext<CommandSourceStack>)context, GTRegistries.BEDROCK_ORE_DEFINITIONS, BedrockOreDefinition.FULL_CODEC, "gtceu/bedrock_ore_veins")))).then(Commands.literal((String)"ore_veins").executes(context -> GTCommands.dumpDataRegistry((CommandContext<CommandSourceStack>)context, GTRegistries.ORE_VEINS, GTOreDefinition.FULL_CODEC, "gtceu/ore_veins"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"place_vein").requires(ctx -> ctx.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument((String)"vein", GTRegistryArgument.registry(GTRegistries.ORE_VEINS, ResourceLocation.class)).executes(context -> GTCommands.placeVein((CommandContext<CommandSourceStack>)context, BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition())))).then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> GTCommands.placeVein((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cape").then(((LiteralArgumentBuilder)Commands.literal((String)"give").requires(ctx -> ctx.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"cape", (ArgumentType)ResourceLocationArgument.id()).suggests(NOT_OWNED_CAPES).executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            Set<ResourceLocation> cape = Collections.singleton(ResourceLocationArgument.getId((CommandContext)ctx, (String)"cape"));
            return GTCommands.giveCapes((CommandSourceStack)ctx.getSource(), players, cape);
        }))).then(Commands.literal((String)"*").executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            return GTCommands.giveCapes((CommandSourceStack)ctx.getSource(), players, CapeRegistry.ALL_CAPES.keySet());
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"take").requires(ctx -> ctx.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"cape", (ArgumentType)ResourceLocationArgument.id()).suggests(OWNED_CAPES).executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            Set<ResourceLocation> cape = Collections.singleton(ResourceLocationArgument.getId((CommandContext)ctx, (String)"cape"));
            return GTCommands.takeCapes((CommandSourceStack)ctx.getSource(), players, cape);
        }))).then(Commands.literal((String)"*").executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            return GTCommands.takeCapes((CommandSourceStack)ctx.getSource(), players, CapeRegistry.ALL_CAPES.keySet());
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"use").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(ctx -> ctx.hasPermission(3))).then(Commands.argument((String)"cape", (ArgumentType)ResourceLocationArgument.id()).suggests(OWNED_CAPES).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            ResourceLocation cape = ResourceLocationArgument.getId((CommandContext)ctx, (String)"cape");
            return GTCommands.setActiveCape((CommandSourceStack)ctx.getSource(), player, cape);
        }))).then(Commands.literal((String)"none").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            return GTCommands.setActiveCape((CommandSourceStack)ctx.getSource(), player, null);
        })))).then(Commands.argument((String)"cape", (ArgumentType)ResourceLocationArgument.id()).suggests(OWNED_CAPES).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ResourceLocation cape = ResourceLocationArgument.getId((CommandContext)ctx, (String)"cape");
            return GTCommands.setActiveCape((CommandSourceStack)ctx.getSource(), player, cape);
        }))).then(Commands.literal((String)"none").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            return GTCommands.setActiveCape((CommandSourceStack)ctx.getSource(), player, null);
        })))));
    }

    public static Collection<ServerPlayer> findPlayersFrom(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        try {
            return EntityArgument.getPlayers(ctx, (String)"targets");
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            try {
                return EntityArgument.getPlayers(ctx, (String)"target");
            }
            catch (CommandSyntaxException | IllegalArgumentException ignored) {
                return Collections.singleton(((CommandSourceStack)ctx.getSource()).getPlayerOrException());
            }
        }
    }

    public static Collection<ResourceLocation> findOwnedCapesFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection<ServerPlayer> players = GTCommands.findPlayersFrom(ctx);
        if (players.isEmpty()) {
            return CapeRegistry.ALL_CAPES.keySet();
        }
        HashSet<ResourceLocation> validCapes = new HashSet<ResourceLocation>();
        for (ServerPlayer player : players) {
            validCapes.addAll(CapeRegistry.getUnlockedCapes(player.getUUID()));
        }
        return validCapes;
    }

    public static Collection<ResourceLocation> findNotOwnedCapesFor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection<ServerPlayer> players = GTCommands.findPlayersFrom(ctx);
        if (players.isEmpty()) {
            return CapeRegistry.ALL_CAPES.keySet();
        }
        Set<ResourceLocation> allCapes = CapeRegistry.ALL_CAPES.keySet();
        HashSet<ResourceLocation> validCapes = new HashSet<ResourceLocation>();
        for (ServerPlayer player : players) {
            HashSet<ResourceLocation> unlockedCapes = new HashSet<ResourceLocation>(CapeRegistry.getUnlockedCapes(player.getUUID()));
            validCapes.addAll((Collection<ResourceLocation>)Sets.difference(allCapes, unlockedCapes));
        }
        return validCapes;
    }

    public static int giveCapes(CommandSourceStack source, Collection<ServerPlayer> targets, Collection<ResourceLocation> capes) throws CommandSyntaxException {
        int successes = 0;
        for (ServerPlayer player : targets) {
            int playerSuccesses = 0;
            for (ResourceLocation cape : capes) {
                if (!CapeRegistry.unlockCape(player.getUUID(), cape)) continue;
                ++successes;
                ++playerSuccesses;
            }
            if (playerSuccesses <= 0) continue;
            player.sendSystemMessage((Component)Component.translatable((String)"gtceu.chat.cape"));
        }
        if (successes == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"command.gtceu.cape.give.success.single", (Object[])new Object[]{capes.size(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"command.gtceu.cape.give.success.multiple", (Object[])new Object[]{capes.size(), targets.size()}), true);
        }
        CapeRegistry.save();
        return successes;
    }

    private static int takeCapes(CommandSourceStack source, Collection<ServerPlayer> targets, Collection<ResourceLocation> capes) throws CommandSyntaxException {
        int successes = 0;
        for (ServerPlayer player : targets) {
            for (ResourceLocation cape : capes) {
                if (!CapeRegistry.removeCape(player.getUUID(), cape)) continue;
                ++successes;
            }
        }
        if (successes == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"command.gtceu.cape.take.success.single", (Object[])new Object[]{capes.size(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"command.gtceu.cape.take.success.multiple", (Object[])new Object[]{capes.size(), targets.size()}), true);
        }
        CapeRegistry.save();
        return successes;
    }

    private static int setActiveCape(CommandSourceStack source, ServerPlayer player, ResourceLocation cape) throws CommandSyntaxException {
        if (CapeRegistry.setActiveCape(player.getUUID(), cape)) {
            if (cape != null) {
                source.sendSuccess(() -> Component.translatable((String)"command.gtceu.cape.use.success", (Object[])new Object[]{player.getDisplayName(), cape.toString()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.gtceu.cape.use.success.none", (Object[])new Object[]{player.getDisplayName()}), true);
            }
            return 1;
        }
        throw ERROR_USE_FAILED.create((Object)player.getDisplayName(), (Object)cape);
    }

    private static <T> int dumpDataRegistry(CommandContext<CommandSourceStack> context, GTRegistry<ResourceLocation, T> registry, Codec<T> codec, String folder) {
        Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/data");
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
        int dumpedCount = 0;
        for (ResourceLocation id : registry.keys()) {
            T entry = registry.get(id);
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)ops, entry).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            GTDynamicDataPack.writeJson(id, folder, parent, json.toString().getBytes(StandardCharsets.UTF_8));
            ++dumpedCount;
        }
        int result = dumpedCount;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.gtceu.dump_data.success", (Object[])new Object[]{result, registry.getRegistryName().toString(), parent.toString()}), true);
        return result;
    }

    private static int placeVein(CommandContext<CommandSourceStack> context, BlockPos sourcePos) {
        GTOreDefinition vein = (GTOreDefinition)context.getArgument("vein", GTOreDefinition.class);
        ResourceLocation id = (ResourceLocation)GTRegistries.ORE_VEINS.getKey(vein);
        ChunkPos chunkPos = new ChunkPos(sourcePos);
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        GeneratedVeinMetadata metadata = new GeneratedVeinMetadata(id, chunkPos, sourcePos, vein);
        RandomSource random = level.random;
        OrePlacer placer = new OrePlacer();
        OreGenerator generator = placer.getOreGenCache().getOreGenerator();
        try (BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);){
            Optional<GeneratedVein> generated = generator.generateOres(new OreGenerator.VeinConfiguration(metadata, random), (WorldGenLevel)level, chunkPos);
            if (generated.isEmpty()) {
                throw new CommandRuntimeException((Component)Component.translatable((String)"command.gtceu.place_vein.failure", (Object[])new Object[]{id.toString(), sourcePos.toString()}));
            }
            for (ChunkPos pos : generated.get().getGeneratedChunks()) {
                placer.placeVein(pos, random, access, generated.get(), (RuleTest)AlwaysTrueTest.INSTANCE);
                level.getChunk(pos.x, pos.z).setUnsaved(true);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.gtceu.place_vein.success", (Object[])new Object[]{id.toString(), sourcePos.toString()}), true);
        }
        return 1;
    }
}

