/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.common.commands.arguments.MedicalConditionArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class MedicalConditionCommands {
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.effect.give.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"medical_condition").then(((LiteralArgumentBuilder)Commands.literal((String)"query").executes(ctx -> MedicalConditionCommands.queryMedicalConditions(((CommandSourceStack)ctx.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(context -> MedicalConditionCommands.queryMedicalConditions(EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(ctx -> ctx.hasPermission(3))).executes(ctx -> MedicalConditionCommands.clearMedicalConditions(Collections.singleton(((CommandSourceStack)ctx.getSource()).getPlayerOrException()), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> MedicalConditionCommands.clearMedicalConditions(EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), null))).then(Commands.argument((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(ctx -> {
            Collection targets = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            MedicalCondition condition = MedicalConditionArgument.getCondition(ctx, "condition");
            return MedicalConditionCommands.clearMedicalConditions(targets, condition);
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"apply").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(ctx -> {
            MedicalCondition condition = MedicalConditionArgument.getCondition(ctx, "condition");
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            return MedicalConditionCommands.applyMedicalConditions(players, condition, 1.0f);
        })).then(Commands.argument((String)"progression_multiplier", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            MedicalCondition condition = MedicalConditionArgument.getCondition(ctx, "condition");
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets");
            float strength = FloatArgumentType.getFloat((CommandContext)ctx, (String)"progression_multiplier");
            return MedicalConditionCommands.applyMedicalConditions(players, condition, strength);
        }))))));
    }

    private static int queryMedicalConditions(ServerPlayer target) throws CommandSyntaxException {
        IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)target);
        if (tracker == null) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        int count = tracker.getMedicalConditions().size();
        if (count == 0) {
            target.sendSystemMessage((Component)Component.translatable((String)"command.gtceu.medical_condition.get.empty", (Object[])new Object[]{target.getName()}));
        } else {
            target.sendSystemMessage((Component)Component.translatable((String)"command.gtceu.medical_condition.get", (Object[])new Object[]{target.getName()}));
        }
        for (Object2FloatMap.Entry entry : tracker.getMedicalConditions().object2FloatEntrySet()) {
            String langKey = "command.gtceu.medical_condition.get.element";
            if (((MedicalCondition)entry.getKey()).maxProgression * 2.0f <= entry.getFloatValue() && ((MedicalCondition)entry.getKey()).canBePermanent) {
                langKey = "command.gtceu.medical_condition.get.element.permanent";
            }
            float time = entry.getFloatValue();
            target.sendSystemMessage((Component)Component.translatable((String)langKey, (Object[])new Object[]{Component.translatable((String)("gtceu.medical_condition." + ((MedicalCondition)entry.getKey()).name)), (int)(time / 60.0f), (int)(time % 60.0f)}));
        }
        return count;
    }

    private static int clearMedicalConditions(Collection<ServerPlayer> targets, @Nullable MedicalCondition condition) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer target : targets) {
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)target);
            if (tracker == null) continue;
            if (condition == null) {
                count += tracker.getMedicalConditions().keySet().size();
                for (MedicalCondition medicalCondition : tracker.getMedicalConditions().keySet()) {
                    tracker.removeMedicalCondition(medicalCondition);
                }
                continue;
            }
            ++count;
            tracker.removeMedicalCondition(condition);
        }
        if (count == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        return count;
    }

    private static int applyMedicalConditions(Collection<ServerPlayer> targets, MedicalCondition condition, float strength) throws CommandSyntaxException {
        int success = 0;
        for (ServerPlayer player : targets) {
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) continue;
            tracker.progressCondition(condition, strength);
            ++success;
        }
        if (success == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        return success;
    }
}

