/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands.arguments;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.commands.arguments.MaterialParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class MaterialArgument
implements ArgumentType<Material> {
    private static final Collection<String> EXAMPLES = Arrays.asList("aluminium", "gtceu:steel");

    public static MaterialArgument material() {
        return new MaterialArgument();
    }

    public Material parse(StringReader reader) throws CommandSyntaxException {
        return MaterialParser.parseForMaterial(GTCEuAPI.materialManager, reader);
    }

    public static <S> Material getMaterial(CommandContext<S> context, String name) {
        return (Material)context.getArgument(name, Material.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return MaterialParser.fillSuggestions(GTCEuAPI.materialManager, builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

