/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import net.minecraft.core.Direction;
import net.minecraftforge.items.IItemHandler;

public class ItemDetectorCover
extends DetectorCover {
    public ItemDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return super.canAttach() && this.getItemHandler() != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return;
        }
        int storedItems = 0;
        int itemCapacity = handler.getSlots() * handler.getSlotLimit(0);
        if (itemCapacity == 0) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            storedItems += handler.getStackInSlot(i).getCount();
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedItems, itemCapacity, this.isInverted()));
    }

    protected IItemHandler getItemHandler() {
        return GTTransferUtils.getItemHandler(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide).resolve().orElse(null);
    }
}

