/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.core.Direction;

public class MaintenanceDetectorCover
extends DetectorCover {
    public MaintenanceDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        if (!ConfigHolder.INSTANCE.machines.enableMaintenance) {
            return false;
        }
        return super.canAttach() && GTCapabilityHelper.getMaintenanceMachine(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide) != null;
    }

    @Override
    protected void update() {
        boolean shouldSignal;
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IMaintenanceMachine maintenance = GTCapabilityHelper.getMaintenanceMachine(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide);
        int signal = this.getRedstoneSignalOutput();
        boolean bl = shouldSignal = this.isInverted() != maintenance.hasMaintenanceProblems();
        if (shouldSignal && signal != 15) {
            this.setRedstoneSignalOutput(15);
        } else if (!shouldSignal && signal == 15) {
            this.setRedstoneSignalOutput(0);
        }
    }
}

