/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.modifier.BiomePlacement;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.worldgen.modifier.RubberTreeChancePlacement;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class GTPlacements {
    public static final ResourceKey<PlacedFeature> RUBBER_CHECKED = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GTCEu.id("rubber_checked"));
    public static final ResourceKey<PlacedFeature> RED_GRANITE_BLOB = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GTCEu.id("red_granite_blob"));
    public static final ResourceKey<PlacedFeature> MARBLE_BLOB = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GTCEu.id("marble_blob"));
    public static final ResourceKey<PlacedFeature> RAW_OIL_SPROUT = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)GTCEu.id("raw_oil_sprout"));

    public static void bootstrap(BootstapContext<PlacedFeature> ctx) {
        HolderGetter featureLookup = ctx.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter biomeLookup = ctx.lookup(Registries.BIOME);
        PlacementUtils.register(ctx, RUBBER_CHECKED, (Holder)featureLookup.getOrThrow(GTConfiguredFeatures.RUBBER), (PlacementModifier[])new PlacementModifier[]{new BiomePlacement(List.of(new BiomeWeightModifier(() -> biomeLookup.getOrThrow(CustomTags.IS_SWAMP), 50))), RubberTreeChancePlacement.INSTANCE, InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome(), PlacementUtils.filteredByBlockSurvival((Block)((Block)GTBlocks.RUBBER_SAPLING.get()))});
        PlacementUtils.register(ctx, RED_GRANITE_BLOB, (Holder)featureLookup.getOrThrow(GTConfiguredFeatures.RED_GRANITE_BLOB), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), BiomeFilter.biome(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-8), (VerticalAnchor)VerticalAnchor.top())});
        PlacementUtils.register(ctx, MARBLE_BLOB, (Holder)featureLookup.getOrThrow(GTConfiguredFeatures.MARBLE_BLOB), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), BiomeFilter.biome(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-8), (VerticalAnchor)VerticalAnchor.top())});
        PlacementUtils.register(ctx, RAW_OIL_SPROUT, (Holder)featureLookup.getOrThrow(GTConfiguredFeatures.RAW_OIL_SPROUT), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64), InSquarePlacement.spread(), BiomeFilter.biome(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)40))});
    }
}

