/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.datafixers;

import com.gregtechceu.gtceu.utils.GTMath;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;

public class TagFixer {
    public static final String[] FLUID_TAGS = new String[]{"currentMilliBucketsPerTick", "globalTransferSizeMillibuckets", "minValue", "maxValue"};

    public static void fixFluidTags(CompoundTag tag) {
        if (tag.contains("cover", 10)) {
            CompoundTag t = tag.getCompound("cover");
            for (String key : t.getAllKeys()) {
                CompoundTag cover = t.getCompound(key);
                String id = cover.getCompound("uid").getString("id");
                if (!id.toLowerCase(Locale.ROOT).contains("fluid") && !id.toLowerCase(Locale.ROOT).contains("pump")) continue;
                CompoundTag data = cover.getCompound("payload").getCompound("d");
                for (String fix_key : FLUID_TAGS) {
                    if (!data.contains(fix_key, 4)) continue;
                    long l = data.getLong(fix_key);
                    data.putInt(fix_key, GTMath.saturatedCast(l));
                }
            }
        }
    }
}

