/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.entity;

import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTEntityTypes;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.GTBoatItem;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GTBoat
extends Boat {
    public GTBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public GTBoat(Level level, double x, double y, double z) {
        super((EntityType)GTEntityTypes.BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @Nullable
    public Component getCustomName() {
        return super.getCustomName();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Type", this.getBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type")) {
            this.entityData.set(DATA_ID_TYPE, (Object)BoatType.byName(compound.getString("Type")).ordinal());
        }
    }

    public Item getDropItem() {
        return switch (BoatType.byId((Integer)this.entityData.get(DATA_ID_TYPE))) {
            default -> throw new IncompatibleClassChangeError();
            case BoatType.RUBBER -> (GTBoatItem)((Object)GTItems.RUBBER_BOAT.get());
            case BoatType.TREATED_WOOD -> (GTBoatItem)((Object)GTItems.TREATED_WOOD_BOAT.get());
        };
    }

    public void setBoatType(BoatType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public BoatType getBoatType() {
        return BoatType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public void setVariant(Boat.Type variant) {
    }

    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }

    public static enum BoatType {
        RUBBER("rubber", (Block)GTBlocks.RUBBER_PLANK.get()),
        TREATED_WOOD("treated", (Block)GTBlocks.TREATED_WOOD_PLANK.get());

        private final String name;
        private final Block planks;
        private static final BoatType[] VALUES;

        private BoatType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            if (id < 0 || id >= VALUES.length) {
                id = 0;
            }
            return VALUES[id];
        }

        public static BoatType byName(String name) {
            return Arrays.stream(VALUES).filter(type -> type.getName().equals(name)).findFirst().orElse(VALUES[0]);
        }

        static {
            VALUES = BoatType.values();
        }
    }
}

