/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.entity;

import com.gregtechceu.gtceu.core.mixins.PrimedTntAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GTExplosiveEntity
extends PrimedTnt {
    public GTExplosiveEntity(EntityType<? extends GTExplosiveEntity> type, Level level, double x, double y, double z, @Nullable LivingEntity owner) {
        this(type, level);
        this.setPos(x, y, z);
        double d = level.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        ((PrimedTntAccessor)((Object)this)).setOwner(owner);
    }

    public GTExplosiveEntity(EntityType<? extends GTExplosiveEntity> type, Level world) {
        super(type, world);
    }

    protected abstract float getStrength();

    public abstract boolean dropsAllBlocks();

    protected int getRange() {
        return 2;
    }

    @NotNull
    public abstract BlockState getExplosiveState();

    protected void explode() {
        this.explode(this.level(), (Entity)this, this.getX(), this.getY(0.0625), this.getZ(), this.getStrength(), this.dropsAllBlocks());
    }

    protected void explode(Level level, @Nullable Entity source, double x, double y, double z, float radius, boolean dropBlocks) {
        Explosion explosion = new Explosion(level, source, x, y, z, radius, false, dropBlocks ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY);
        if (!ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
            explosion.explode();
            explosion.finalizeExplosion(false);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverplayer : serverLevel.players()) {
                if (!(serverplayer.distanceToSqr(x, y, z) < 4096.0)) continue;
                serverplayer.connection.send((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(serverplayer)));
            }
        }
    }
}

