/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.fluid.potion;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.data.GTFluids;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PotionFluid
extends ForgeFlowingFluid {
    public PotionFluid(ForgeFlowingFluid.Properties properties) {
        super(properties.bucket(() -> Items.AIR).block(() -> (LiquidBlock)Blocks.WATER));
        this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.createFluidStateDefinition(builder);
        builder.add(new Property[]{LEVEL});
    }

    public static FluidStack of(int amount, Potion potion) {
        FluidStack fluidStack = new FluidStack(((PotionFluid)((Object)GTFluids.POTION.get())).getSource(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        return fluidStack;
    }

    public static FluidStack withEffects(int amount, Potion potion, List<MobEffectInstance> customEffects) {
        FluidStack fluidStack = PotionFluid.of(amount, potion);
        PotionFluid.appendEffects(fluidStack, customEffects);
        return fluidStack;
    }

    public static FluidStack addPotionToFluidStack(FluidStack fluidStack, Potion potion) {
        ResourceLocation resourcelocation = BuiltInRegistries.POTION.getKey((Object)potion);
        if (potion == Potions.EMPTY) {
            fluidStack.removeChildTag("Potion");
            return fluidStack;
        }
        fluidStack.getOrCreateTag().putString("Potion", resourcelocation.toString());
        return fluidStack;
    }

    public static FluidStack appendEffects(FluidStack fluidStack, Collection<MobEffectInstance> customEffects) {
        if (customEffects.isEmpty()) {
            return fluidStack;
        }
        CompoundTag tag = fluidStack.getOrCreateTag();
        ListTag effects = tag.getList("CustomPotionEffects", 9);
        for (MobEffectInstance effect : customEffects) {
            effects.add((Object)effect.save(new CompoundTag()));
        }
        tag.put("CustomPotionEffects", (Tag)effects);
        return fluidStack;
    }

    public boolean isSource(FluidState state) {
        return this == ((PotionFluid)((Object)GTFluids.POTION.get())).getSource();
    }

    public int getAmount(FluidState state) {
        return (Integer)state.getValue((Property)LEVEL);
    }

    public static class PotionFluidType
    extends FluidType {
        private static final ResourceLocation texture = GTCEu.id("block/fluids/fluid.potion");

        public PotionFluidType(FluidType.Properties properties, ResourceLocation still, ResourceLocation flow) {
            super(properties);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return texture;
                }

                public ResourceLocation getFlowingTexture() {
                    return texture;
                }

                public int getTintColor(FluidStack stack) {
                    CompoundTag tag = stack.getOrCreateTag();
                    return PotionUtils.getColor((Collection)PotionUtils.getAllEffects((CompoundTag)tag)) | 0xFF000000;
                }
            });
        }

        public String getDescriptionId(FluidStack stack) {
            CompoundTag tag = stack.getOrCreateTag();
            return PotionUtils.getPotion((CompoundTag)tag).getName(Items.POTION.getDescriptionId() + ".effect.");
        }
    }
}

