/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.fluid.potion;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTFluids;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluid;
import com.gregtechceu.gtceu.core.mixins.forge.StrictNBTIngredientAccessor;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class PotionFluidHelper {
    public static final int BOTTLE_AMOUNT = 250;
    public static final int MB_PER_RECIPE = 750;

    public static Pair<FluidStack, ItemStack> emptyPotion(ItemStack stack, boolean simulate) {
        FluidStack fluid = PotionFluidHelper.getFluidFromPotionItem(stack, 250);
        if (!simulate) {
            stack.shrink(1);
        }
        return Pair.of((Object)fluid, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
    }

    public static FluidIngredient potionIngredient(Potion potion, int amount) {
        FluidStack stack = PotionFluidHelper.getFluidFromPotionItem(PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)potion), amount);
        stack.setAmount(amount);
        return FluidIngredient.of(stack);
    }

    public static FluidIngredient getPotionFluidIngredientFrom(Ingredient potion, int amount) {
        if (potion instanceof StrictNBTIngredientAccessor) {
            StrictNBTIngredientAccessor strict = (StrictNBTIngredientAccessor)potion;
            return FluidIngredient.fromValue(new FluidIngredient.FluidValue((Fluid)GTFluids.POTION.get()), amount, strict.getStack().getTag());
        }
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (ItemStack stack : potion.getItems()) {
            FluidStack fluidStack = PotionFluidHelper.getFluidFromPotionItem(stack, amount);
            if (fluidStack.isEmpty()) continue;
            fluids.add(fluidStack);
        }
        return FluidIngredient.of(fluids);
    }

    public static FluidStack getFluidFromPotionItem(ItemStack stack, int amount) {
        Potion potion = PotionUtils.getPotion((ItemStack)stack);
        if (potion == Potions.EMPTY) {
            return FluidStack.EMPTY;
        }
        List list = PotionUtils.getCustomEffects((ItemStack)stack);
        if (potion == Potions.WATER && list.isEmpty()) {
            return new FluidStack((Fluid)Fluids.WATER, amount);
        }
        return PotionFluid.withEffects(amount, potion, list);
    }

    public static FluidStack getFluidFromPotion(Potion potion, int amount) {
        if (potion == Potions.WATER) {
            return new FluidStack((Fluid)Fluids.WATER, amount);
        }
        return PotionFluid.of(amount, potion);
    }

    public static ItemStack fillBottle(ItemStack stack, FluidStack availableFluid) {
        CompoundTag tag = availableFluid.getOrCreateTag();
        if (stack.is(Items.GLASS_BOTTLE)) {
            int count = stack.getCount();
            CompoundTag stackTag = stack.getTag();
            stack = new ItemStack((ItemLike)Items.POTION);
            stack.setCount(count);
            stack.setTag(stackTag);
        }
        PotionUtils.setPotion((ItemStack)stack, (Potion)PotionUtils.getPotion((CompoundTag)tag));
        PotionUtils.setCustomEffects((ItemStack)stack, (Collection)PotionUtils.getCustomEffects((CompoundTag)tag));
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(FluidStack fs, Consumer<Component> tooltip) {
        List list = PotionUtils.getAllEffects((CompoundTag)fs.getOrCreateTag());
        ArrayList modifiers = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectInstance : list) {
                MutableComponent name = Component.translatable((String)effectInstance.getDescriptionId());
                MobEffect effect = effectInstance.getEffect();
                Map map = effect.getAttributeModifiers();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        AttributeModifier mutated = new AttributeModifier(modifier.getName(), effect.getAttributeModifierValue(effectInstance.getAmplifier(), modifier), modifier.getOperation());
                        modifiers.add(new Tuple((Object)((Attribute)entry.getKey()).getDescriptionId(), (Object)mutated));
                    }
                }
                if (effectInstance.getAmplifier() > 0) {
                    name = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{name, Component.translatable((String)("potion.potency." + effectInstance.getAmplifier()))});
                }
                if (!effectInstance.endsWithin(20)) {
                    name = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{name, MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f)});
                }
                tooltip.accept((Component)name.withStyle(effect.getCategory().getTooltipFormatting()));
            }
        }
        if (!modifiers.isEmpty()) {
            tooltip.accept((Component)Component.empty());
            tooltip.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Tuple tuple : modifiers) {
                AttributeModifier modifier2 = (AttributeModifier)tuple.getB();
                double d0 = modifier2.getAmount();
                double d1 = modifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && modifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier2.getAmount() : modifier2.getAmount() * 100.0;
                if (d0 > 0.0) {
                    tooltip.accept((Component)Component.translatable((String)("attribute.modifier.plus." + modifier2.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((String)tuple.getA()))}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.accept((Component)Component.translatable((String)("attribute.modifier.take." + modifier2.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)((String)tuple.getA()))}).withStyle(ChatFormatting.RED));
            }
        }
    }

    public static Component formatDuration(MobEffectInstance effect) {
        MutableComponent unit;
        Instant max;
        if (effect.isInfiniteDuration()) {
            return Component.translatable((String)"effect.duration.infinite");
        }
        int time = effect.getDuration();
        Instant start = Instant.now();
        Duration durationMax = Duration.between(start, max = Instant.now().plusSeconds(time / 20));
        if (durationMax.getSeconds() <= 60L) {
            time = GTMath.saturatedCast(durationMax.getSeconds());
            unit = Component.translatable((String)"item.gtceu.battery.charge_unit.second");
        } else if (durationMax.toMinutes() <= 60L) {
            time = GTMath.saturatedCast(durationMax.toMinutes());
            unit = Component.translatable((String)"item.gtceu.battery.charge_unit.minute");
        } else {
            time = GTMath.saturatedCast(durationMax.toHours());
            unit = Component.translatable((String)"item.gtceu.battery.charge_unit.hour");
        }
        return Component.literal((String)FormattingUtil.formatNumbers(time)).append((Component)unit);
    }
}

