/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record AntidoteBehavior(Set<MedicalCondition> types, int removePercent) implements IInteractionItem,
IAddInformation
{
    public AntidoteBehavior(int timeToRemove, MedicalCondition ... types) {
        this(new HashSet<MedicalCondition>(), timeToRemove);
        this.types.addAll(Arrays.asList(types));
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack itemstack = IInteractionItem.super.finishUsingItem(stack, level, livingEntity);
        IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)livingEntity);
        if (tracker == null) {
            return itemstack;
        }
        for (Object2FloatMap.Entry entry : tracker.getMedicalConditions().object2FloatEntrySet()) {
            MedicalCondition condition = (MedicalCondition)entry.getKey();
            if (condition == null || !this.types.contains(condition)) continue;
            if (this.removePercent == -1) {
                tracker.removeMedicalCondition(condition);
                continue;
            }
            float time = entry.getFloatValue();
            float timeToRemove = time * ((float)this.removePercent / 100.0f);
            if (timeToRemove > 0.05f * time) {
                tracker.removeMedicalCondition(condition);
                continue;
            }
            tracker.heal(condition, (int)timeToRemove);
        }
        return itemstack;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (!ConfigHolder.INSTANCE.gameplay.hazardsEnabled) {
            return;
        }
        if (GTUtil.isShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.medical_condition.antidote.description_shift"));
            for (MedicalCondition type : this.types) {
                tooltipComponents.add((Component)Component.translatable((String)("gtceu.medical_condition." + type.name)));
            }
            if (this.removePercent == -1) {
                tooltipComponents.add((Component)Component.translatable((String)"gtceu.medical_condition.antidote.description.effect_removed.all"));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"gtceu.medical_condition.antidote.description.effect_removed", (Object[])new Object[]{this.removePercent}));
            }
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"gtceu.medical_condition.antidote.description"));
    }
}

