/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.ResearchManager;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class DataItemBehavior
implements IInteractionItem,
IAddInformation,
IDataItem {
    private final boolean requireDataBank;
    private final int capacity;

    public DataItemBehavior(boolean requireDataBank, int capacity) {
        this.requireDataBank = requireDataBank;
        this.capacity = capacity;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(usedHand);
            stack.getOrCreateTag().putString("boundPlayerName", Component.Serializer.toJson((Component)player.getDisplayName()));
            int perm = 0;
            while (player.hasPermissions(perm)) {
                ++perm;
            }
            stack.getOrCreateTag().putInt("boundPlayerPermLevel", perm - 1);
            stack.getOrCreateTag().putString("boundPlayerUUID", player.getStringUUID());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public boolean requireDataBank() {
        return this.requireDataBank;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        ResearchManager.ResearchItem researchData;
        if (stack.getOrCreateTag().contains("boundPlayerName")) {
            MutableComponent name = Component.Serializer.fromJson((String)stack.getOrCreateTag().getString("boundPlayerName"));
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.tooltip.player_bind", (Object[])new Object[]{name}));
        }
        if (stack.getOrCreateTag().contains("targetX")) {
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.tooltip.wireless_transmitter_bind", (Object[])new Object[]{Component.literal((String)("" + stack.getOrCreateTag().getInt("targetX"))).withStyle(ChatFormatting.GOLD), Component.literal((String)("" + stack.getOrCreateTag().getInt("targetY"))).withStyle(ChatFormatting.GOLD), Component.literal((String)("" + stack.getOrCreateTag().getInt("targetZ"))).withStyle(ChatFormatting.GOLD), Component.literal((String)stack.getOrCreateTag().getString("face")).withStyle(ChatFormatting.DARK_PURPLE), Component.literal((String)stack.getOrCreateTag().getString("dim")).withStyle(ChatFormatting.GREEN)}));
        }
        if (stack.getOrCreateTag().contains("computer_monitor_cover_config")) {
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.tooltip.computer_monitor_config"));
        }
        if (stack.getOrCreateTag().contains("computer_monitor_cover_data")) {
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.tooltip.computer_monitor_data", (Object[])new Object[]{GTStringUtils.toComponent(stack.getOrCreateTag().getList("computer_monitor_cover_data", 8))}));
        }
        if ((researchData = ResearchManager.readResearchId(stack)) == null) {
            if (stack.getOrCreateTag().contains("pos", 11) && stack.hasTag()) {
                int[] posArray = stack.getOrCreateTag().getIntArray("pos");
                tooltipComponents.add((Component)Component.translatable((String)"gtceu.tooltip.proxy_bind", (Object[])new Object[]{Component.literal((String)("" + posArray[0])).withStyle(ChatFormatting.LIGHT_PURPLE), Component.literal((String)("" + posArray[1])).withStyle(ChatFormatting.LIGHT_PURPLE), Component.literal((String)("" + posArray[2])).withStyle(ChatFormatting.LIGHT_PURPLE)}));
            }
        } else {
            Collection<GTRecipe> recipes = researchData.recipeType().getDataStickEntry(researchData.researchId());
            if (recipes != null && !recipes.isEmpty()) {
                List<Content> contents;
                tooltipComponents.add((Component)Component.translatable((String)"behavior.data_item.title", (Object[])new Object[]{Component.translatable((String)researchData.recipeType().registryName.toLanguageKey())}));
                ObjectOpenHashSet addedItems = new ObjectOpenHashSet();
                ObjectOpenHashSet addedFluids = new ObjectOpenHashSet();
                block0: for (GTRecipe recipe : recipes) {
                    contents = recipe.getOutputContents(ItemRecipeCapability.CAP);
                    if (contents.isEmpty()) continue;
                    ItemStack outputItems = ((Ingredient)ItemRecipeCapability.CAP.of(contents.get((int)0).content)).getItems()[0];
                    for (ItemStack item : addedItems) {
                        if (!outputItems.is(item.getItem())) continue;
                        continue block0;
                    }
                    if (!addedItems.add(outputItems)) continue;
                    tooltipComponents.add((Component)Component.translatable((String)"behavior.data_item.data", (Object[])new Object[]{outputItems.getDisplayName()}));
                }
                block2: for (GTRecipe recipe : recipes) {
                    contents = recipe.getOutputContents(FluidRecipeCapability.CAP);
                    if (contents.isEmpty()) continue;
                    FluidStack outputFluids = ((FluidIngredient)FluidRecipeCapability.CAP.of(contents.get((int)0).content)).getStacks()[0];
                    for (FluidStack fluid : addedFluids) {
                        if (!outputFluids.isFluidStackIdentical(fluid)) continue;
                        continue block2;
                    }
                    if (!addedFluids.add(outputFluids)) continue;
                    tooltipComponents.add((Component)Component.translatable((String)"behavior.data_item.data", (Object[])new Object[]{outputFluids.getDisplayName()}));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        ICoverable coverable = GTCapabilityHelper.getCoverable(context.getLevel(), context.getClickedPos(), context.getClickedFace());
        if (coverable != null && (coverBehavior = coverable.getCoverAtSide(context.getClickedFace())) instanceof IDataStickInteractable) {
            IDataStickInteractable interactable = (IDataStickInteractable)((Object)coverBehavior);
            if (!context.isSecondaryUseActive()) return interactable.onDataStickUse(context.getPlayer(), itemStack);
            if (ResearchManager.readResearchId(itemStack) == null) {
                return interactable.onDataStickShiftUse(context.getPlayer(), itemStack);
            }
        }
        if (!((coverBehavior = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof MetaMachineBlockEntity)) return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
        MetaMachineBlockEntity blockEntity = (MetaMachineBlockEntity)((Object)coverBehavior);
        MetaMachine machine = blockEntity.getMetaMachine();
        if (!MachineOwner.canOpenOwnerMachine(context.getPlayer(), machine)) {
            return InteractionResult.FAIL;
        }
        if (!(machine instanceof IDataStickInteractable)) return InteractionResult.PASS;
        IDataStickInteractable interactable = (IDataStickInteractable)((Object)machine);
        if (!context.isSecondaryUseActive()) return interactable.onDataStickUse(context.getPlayer(), itemStack);
        if (ResearchManager.readResearchId(itemStack) != null) return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
        return interactable.onDataStickShiftUse(context.getPlayer(), itemStack);
    }

    @Override
    @Generated
    public int getCapacity() {
        return this.capacity;
    }
}

