/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class FertilizerBehavior
implements IInteractionItem {
    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(context.getClickedFace());
        if (BoneMealItem.applyBonemeal((ItemStack)context.getItemInHand(), (Level)level, (BlockPos)blockPos, (Player)context.getPlayer())) {
            if (!level.isClientSide) {
                level.levelEvent(1505, blockPos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockState blockState = level.getBlockState(blockPos);
        boolean bl = blockState.isFaceSturdy((BlockGetter)level, blockPos, context.getClickedFace());
        if (bl && BoneMealItem.growWaterPlant((ItemStack)context.getItemInHand(), (Level)level, (BlockPos)blockPos2, (Direction)context.getClickedFace())) {
            if (!level.isClientSide) {
                level.levelEvent(1505, blockPos2, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onAttached(Item item) {
        DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
                this.setSuccess(true);
                ServerLevel level = source.getLevel();
                BlockPos blockpos = source.getPos().relative((Direction)source.getBlockState().getValue((Property)DispenserBlock.FACING));
                if (!BoneMealItem.growCrop((ItemStack)stack, (Level)level, (BlockPos)blockpos) && !BoneMealItem.growWaterPlant((ItemStack)stack, (Level)level, (BlockPos)blockpos, null)) {
                    this.setSuccess(false);
                } else if (!level.isClientSide) {
                    level.levelEvent(1505, blockpos, 0);
                }
                return stack;
            }
        });
    }
}

