/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Triplet;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemMagnetBehavior
implements IInteractionItem,
IItemLifeCycle,
IAddInformation,
IItemUIFactory {
    public static final String FILTER_TAG = "MagnetFilter";
    public static final String FILTER_ORDINAL_TAG = "FilterOrdinal";
    private final int range;
    private final long energyDraw;

    public ItemMagnetBehavior(int range) {
        this.range = range;
        this.energyDraw = GTValues.V[range > 8 ? 3 : 1];
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, Player entityPlayer) {
        ItemStack held = holder.getHeld();
        CompoundTag tag = held.getOrCreateTag();
        Filter selected = Filter.get(tag.getInt(FILTER_ORDINAL_TAG));
        HashSet<Triplet> widgets = new HashSet<Triplet>();
        HashMap<Filter, ItemStack> stacks = new HashMap<Filter, ItemStack>();
        ModularUI ui = new ModularUI(176, 157, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new EnumSelectorWidget(146, 5, 20, 20, (Enum[])Filter.values(), (Enum)selected, val -> this.updateSelection(tag, (Filter)val, (Collection<Triplet<Filter, Widget, Widget>>)widgets))).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.getInventory(), (IGuiTexture)GuiTextures.SLOT, 7, 75, true));
        for (Filter f : Filter.values()) {
            ItemStack stack = f.getFilter(held);
            stack.setTag(tag.getCompound(FILTER_TAG).copy());
            stacks.put(f, stack);
            LabelWidget description = new LabelWidget(5, 5, stack.getDescriptionId());
            WidgetGroup config = ItemFilter.loadFilter(stack).openConfigurator(48, 17);
            boolean visible = f == selected;
            description.setVisible(visible);
            config.setVisible(visible);
            widgets.add(new Triplet((Object)f, (Object)description, (Object)config));
            ui.widget((Widget)description);
            ui.widget((Widget)config);
        }
        ui.registerCloseListener(() -> {
            Filter selection = Filter.get(tag.getInt(FILTER_ORDINAL_TAG));
            tag.put(FILTER_TAG, (Tag)((ItemStack)stacks.get(selection)).getOrCreateTag());
        });
        return ui;
    }

    private void updateSelection(CompoundTag tag, Filter filter, Collection<Triplet<Filter, Widget, Widget>> widgets) {
        tag.putInt(FILTER_ORDINAL_TAG, filter.ordinal());
        widgets.forEach(tri -> {
            boolean visible = tri.getA() == filter;
            ((Widget)tri.getB()).setVisible(visible);
            ((Widget)tri.getC()).setVisible(visible);
        });
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level world, @NotNull Player player, InteractionHand hand) {
        if (!player.level().isClientSide && player.isShiftKeyDown()) {
            player.displayClientMessage((Component)Component.translatable((String)(ItemMagnetBehavior.toggleActive(player.getItemInHand(hand)) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled")), true);
        } else {
            IItemUIFactory.super.use(item, world, player, hand);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    private static boolean isActive(ItemStack stack) {
        if (stack == ItemStack.EMPTY) {
            return false;
        }
        CompoundTag tag = stack.getTag();
        if (tag == null) {
            return false;
        }
        if (tag.contains("IsActive")) {
            return tag.getBoolean("IsActive");
        }
        return false;
    }

    private static boolean toggleActive(ItemStack stack) {
        boolean isActive = ItemMagnetBehavior.isActive(stack);
        stack.getOrCreateTag().putBoolean("IsActive", !isActive);
        return !isActive;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!entity.isShiftKeyDown() && entity.tickCount % 10 == 0 && ItemMagnetBehavior.isActive(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            Level world = entity.level();
            if (!ItemMagnetBehavior.drainEnergy(true, stack, this.energyDraw)) {
                return;
            }
            List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.getX(), entity.getY(), entity.getZ()).inflate((double)this.range, (double)this.range, (double)this.range));
            Predicate filter = null;
            boolean didMoveEntity = false;
            for (ItemEntity itemEntity : items) {
                Player closest;
                CompoundTag itemTag;
                if (itemEntity.isRemoved() || (itemTag = itemEntity.getPersistentData()).contains("PreventRemoteMovement") || itemEntity.getOwner() != null && itemEntity.getOwner().equals((Object)entity) && itemEntity.hasPickUpDelay() || (closest = world.getNearestPlayer((Entity)itemEntity, 4.0)) != null && closest != entity || world.isClientSide) continue;
                if (filter == null) {
                    filter = Filter.get(stack.getOrCreateTag().getInt(FILTER_ORDINAL_TAG)).loadFilter(stack);
                }
                if (!filter.test(itemEntity.getItem())) continue;
                if (itemEntity.hasPickUpDelay()) {
                    itemEntity.setNoPickUpDelay();
                }
                itemEntity.setDeltaMovement(0.0, 0.0, 0.0);
                itemEntity.setPos(entity.getX() - 0.2 + world.random.nextDouble() * 0.4, entity.getY() - 0.6, entity.getZ() - 0.2 + world.random.nextDouble() * 0.4);
                didMoveEntity = true;
            }
            if (didMoveEntity) {
                world.playSound(null, entity, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * ((world.random.nextFloat() - world.random.nextFloat()) * 0.7f + 2.0f));
            }
            List xp = world.getEntitiesOfClass(ExperienceOrb.class, new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.getX(), entity.getY(), entity.getZ()).inflate(4.0, 4.0, 4.0));
            for (ExperienceOrb orb : xp) {
                if (world.isClientSide || orb.isRemoved() || player.takeXpDelay != 0 || MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, orb))) continue;
                world.playSound(null, entity, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * ((world.random.nextFloat() - world.random.nextFloat()) * 0.7f + 1.8f));
                player.take((Entity)orb, 1);
                player.giveExperiencePoints(orb.value);
                orb.discard();
                didMoveEntity = true;
            }
            if (didMoveEntity) {
                ItemMagnetBehavior.drainEnergy(false, stack, this.energyDraw);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(@NotNull ItemTossEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.hasMagnet(event.getPlayer())) {
            event.getEntity().setPickUpDelay(60);
        }
    }

    private boolean hasMagnet(@NotNull Player player) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stackInSlot = inventory.getItem(i);
            if (!ItemMagnetBehavior.isMagnet(stackInSlot) || !ItemMagnetBehavior.isActive(stackInSlot)) continue;
            return true;
        }
        if (!GTCEu.Mods.isCuriosLoaded()) {
            return false;
        }
        return CuriosUtils.hasMagnetCurios(player);
    }

    private static boolean isMagnet(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IComponentItem) {
            IComponentItem metaItem = (IComponentItem)item;
            for (IItemComponent behavior : metaItem.getComponents()) {
                if (!(behavior instanceof ItemMagnetBehavior)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean drainEnergy(boolean simulate, @NotNull ItemStack stack, long amount) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= amount;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag isAdvanced) {
        lines.add((Component)Component.translatable((String)(ItemMagnetBehavior.isActive(itemStack) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled")));
    }

    public static enum Filter implements EnumSelectorWidget.SelectableEnum
    {
        SIMPLE(GTItems.ITEM_FILTER, "item_filter"),
        TAG(GTItems.TAG_FILTER, "item_tag_filter");

        public final ItemEntry<ComponentItem> item;
        public final String texture;

        private Filter(ItemEntry<ComponentItem> item, String texture) {
            this.item = item;
            this.texture = texture;
        }

        public ItemStack getFilter(ItemStack magnet) {
            CompoundTag tag = magnet.getOrCreateTag();
            ItemStack mockStack = new ItemStack(this.item);
            mockStack.setTag(tag.getCompound(ItemMagnetBehavior.FILTER_TAG));
            return mockStack;
        }

        public ItemFilter loadFilter(ItemStack magnet) {
            ItemStack stack = this.getFilter(magnet);
            return ItemFilter.loadFilter(stack);
        }

        public static Filter get(int ordinal) {
            return Filter.values()[ordinal];
        }

        @Override
        @NotNull
        public String getTooltip() {
            return this.item.asItem().getDescriptionId();
        }

        @Override
        @NotNull
        public IGuiTexture getIcon() {
            return new ResourceTexture("gtceu:textures/item/" + this.texture + ".png");
        }
    }

    private static class CuriosUtils {
        private CuriosUtils() {
        }

        public static boolean hasMagnetCurios(Player player) {
            return CuriosApi.getCuriosInventory((LivingEntity)player).map(curios -> curios.findFirstCurio(i -> ItemMagnetBehavior.isMagnet(i) && ItemMagnetBehavior.isActive(i)).isPresent()).orElse(false);
        }
    }
}

