/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.capability.LocalizedHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.prospecting.SPacketProspectBedrockFluid;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class PortableScannerBehavior
implements IInteractionItem,
IAddInformation {
    private int debugLevel = 0;

    public PortableScannerBehavior(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide() && !level.isEmptyBlock(pos) && player != null) {
            ArrayList<Component> list = new ArrayList<Component>();
            int energyCost = this.addScannerInfo(player, level, pos, this.getMode(stack), list);
            if (player.isCreative()) {
                energyCost = 0;
            }
            if (energyCost > 0 && !this.drainEnergy(stack, energyCost, true)) {
                player.sendSystemMessage((Component)Component.translatable((String)"behavior.prospector.not_enough_energy"));
                return InteractionResult.CONSUME;
            }
            this.drainEnergy(stack, energyCost, false);
            for (Component line : list) {
                player.sendSystemMessage(line);
            }
            GTSoundEntries.PORTABLE_SCANNER.play(level, null, player.position(), 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.getItemInHand(usedHand);
        if (player.isCrouching()) {
            if (!level.isClientSide) {
                this.setNextMode(heldItem);
                DisplayMode mode = this.getMode(heldItem);
                player.sendSystemMessage((Component)Component.translatable((String)"behavior.portable_scanner.mode.caption", (Object[])new Object[]{Component.translatable((String)mode.getLangKey())}));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    protected boolean drainEnergy(@Nonnull ItemStack stack, int amount, boolean simulate) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= (long)amount;
    }

    protected void setNextMode(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putInt("Mode", (tag.getInt("Mode") + 1) % DisplayMode.values().length);
    }

    @Nonnull
    protected DisplayMode getMode(ItemStack stack) {
        if (stack == ItemStack.EMPTY) {
            return DisplayMode.SHOW_ALL;
        }
        CompoundTag tag = stack.getTag();
        if (tag == null) {
            return DisplayMode.SHOW_ALL;
        }
        return DisplayMode.values()[tag.getInt("Mode") % DisplayMode.values().length];
    }

    public int addScannerInfo(Player player, Level level, BlockPos pos, DisplayMode mode, List<Component> list) {
        IDataInfoProvider dataInfoProvider;
        List<Component> debugInfo;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        int energyCost = 0;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_BLOCK_INFO) {
            list.add((Component)Component.translatable((String)"behavior.portable_scanner.position", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(pos.getX())).withStyle(ChatFormatting.AQUA), Component.translatable((String)FormattingUtil.formatNumbers(pos.getY())).withStyle(ChatFormatting.AQUA), Component.translatable((String)FormattingUtil.formatNumbers(pos.getZ())).withStyle(ChatFormatting.AQUA), Component.translatable((String)level.dimension().location().toString()).withStyle(ChatFormatting.AQUA)}));
            list.add((Component)Component.translatable((String)"behavior.portable_scanner.block_hardness", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(block.defaultDestroyTime())).withStyle(ChatFormatting.YELLOW), Component.translatable((String)FormattingUtil.formatNumbers(block.getExplosionResistance())).withStyle(ChatFormatting.YELLOW)}));
            if (this.debugLevel > 2) {
                state.getProperties().forEach(property -> list.add((Component)Component.translatable((String)"behavior.portable_scanner.state", (Object[])new Object[]{Component.translatable((String)property.getName()), Component.translatable((String)state.getValue(property).toString()).withStyle(ChatFormatting.AQUA)})));
            }
        }
        if (tileEntity instanceof IMachineBlockEntity) {
            Optional energyCap;
            IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)tileEntity;
            MetaMachine machine = machineBlockEntity.getMetaMachine();
            list.add((Component)Component.translatable((String)state.getBlock().getDescriptionId()).withStyle(ChatFormatting.BLUE));
            if (mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_MACHINE_INFO) {
                Optional fluidCap;
                if (machine.getOwner() != null) {
                    machine.getOwner().displayInfo(list);
                }
                if (machine.getDefinition().isAllowExtendedFacing()) {
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.machine_front_facing", (Object[])new Object[]{machine.getFrontFacing().getSerializedName()}));
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.machine_upwards_facing", (Object[])new Object[]{((Direction)machineBlockEntity.self().getBlockState().getValue((Property)GTBlockStateProperties.UPWARDS_FACING)).getSerializedName()}));
                }
                if ((fluidCap = tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).resolve()).isPresent()) {
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                    IFluidHandler fluidHandler = (IFluidHandler)fluidCap.get();
                    boolean allTanksEmpty = true;
                    for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                        FluidStack fluidStack = fluidHandler.getFluidInTank(i);
                        if (fluidStack.getFluid() == null || fluidStack.isEmpty()) continue;
                        energyCost += 500;
                        allTanksEmpty = false;
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.tank", (Object[])new Object[]{i, Component.translatable((String)FormattingUtil.formatNumbers(fluidStack.getAmount())).withStyle(ChatFormatting.GREEN), Component.translatable((String)FormattingUtil.formatNumbers(fluidHandler.getTankCapacity(i))).withStyle(ChatFormatting.YELLOW), Component.translatable((String)fluidStack.getTranslationKey()).withStyle(ChatFormatting.GOLD)}));
                    }
                    if (allTanksEmpty) {
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.tanks_empty"));
                    }
                }
                if (machine instanceof IMufflableMachine) {
                    IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)machine);
                    energyCost += 500;
                    if (mufflableMachine.isMuffled()) {
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.muffled").withStyle(ChatFormatting.GREEN));
                    }
                }
            }
            if ((mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_ELECTRICAL_INFO) && (energyCap = tileEntity.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER).resolve()).isPresent()) {
                IEnergyContainer energyContainer = (IEnergyContainer)energyCap.get();
                if (energyContainer.getInputVoltage() > 0L) {
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.energy_container_in", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(energyContainer.getInputVoltage())).withStyle(ChatFormatting.RED), Component.translatable((String)GTValues.VN[GTUtil.getTierByVoltage(energyContainer.getInputVoltage())]).withStyle(ChatFormatting.RED), Component.translatable((String)FormattingUtil.formatNumbers(energyContainer.getInputAmperage())).withStyle(ChatFormatting.RED)}));
                }
                if (energyContainer.getOutputVoltage() > 0L) {
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.energy_container_out", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(energyContainer.getOutputVoltage())).withStyle(ChatFormatting.RED), Component.translatable((String)GTValues.VN[GTUtil.getTierByVoltage(energyContainer.getOutputVoltage())]).withStyle(ChatFormatting.RED), Component.translatable((String)FormattingUtil.formatNumbers(energyContainer.getOutputAmperage())).withStyle(ChatFormatting.RED)}));
                }
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.energy_container_storage", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(energyContainer.getEnergyStored())).withStyle(ChatFormatting.GREEN), Component.translatable((String)FormattingUtil.formatNumbers(energyContainer.getEnergyCapacity())).withStyle(ChatFormatting.YELLOW)}));
            }
            if (mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_RECIPE_INFO) {
                Optional recipeLogicCap;
                if (machine instanceof IWorkable) {
                    IWorkable workableMachine = (IWorkable)((Object)machine);
                    energyCost += 400;
                    if (!workableMachine.isWorkingEnabled()) {
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.machine_disabled").withStyle(ChatFormatting.RED));
                    }
                    if (workableMachine.getMaxProgress() > 0) {
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.machine_progress", (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(workableMachine.getProgress())).withStyle(ChatFormatting.GREEN), Component.translatable((String)FormattingUtil.formatNumbers(workableMachine.getMaxProgress())).withStyle(ChatFormatting.YELLOW)}));
                    }
                }
                if ((recipeLogicCap = tileEntity.getCapability(GTCapability.CAPABILITY_RECIPE_LOGIC).resolve()).isPresent()) {
                    RecipeLogic recipeLogic = (RecipeLogic)recipeLogicCap.get();
                    GTRecipe recipe = recipeLogic.getLastRecipe();
                    if (recipeLogic.getStatus().equals((Object)RecipeLogic.Status.WAITING)) {
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                        list.add((Component)Component.translatable((String)"gtceu.multiblock.waiting"));
                        list.addAll(recipeLogic.getFancyTooltip());
                    } else if (recipe != null) {
                        list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                        EnergyStack.WithIO EUt = RecipeHelper.getRealEUtWithIO(recipe);
                        list.add((Component)Component.translatable((String)(EUt.isInput() ? "behavior.portable_scanner.workable_consumption" : "behavior.portable_scanner.workable_production"), (Object[])new Object[]{Component.translatable((String)FormattingUtil.formatNumbers(EUt.getTotalEU())).withStyle(ChatFormatting.RED), Component.translatable((String)FormattingUtil.formatNumbers(EUt.amperage())).withStyle(ChatFormatting.RED)}));
                    }
                }
            }
            IDataInfoProvider provider = null;
            if (tileEntity instanceof IDataInfoProvider) {
                provider = (IDataInfoProvider)tileEntity;
            } else if (machine instanceof IDataInfoProvider) {
                provider = (IDataInfoProvider)((Object)machine);
            }
            if (provider != null) {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                list.addAll(provider.getDataInfo(mode));
            }
        } else if (tileEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)tileEntity;
            list.add((Component)pipe.getPipeBlock().getName().withStyle(ChatFormatting.BLUE));
            if (tileEntity instanceof IDataInfoProvider) {
                IDataInfoProvider dataInfoProvider2 = (IDataInfoProvider)tileEntity;
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
                list.addAll(dataInfoProvider2.getDataInfo(mode));
            }
            if (tileEntity instanceof FluidPipeBlockEntity) {
                energyCost += 500;
            }
        } else if (tileEntity instanceof IDataInfoProvider) {
            IDataInfoProvider dataInfoProvider3 = (IDataInfoProvider)tileEntity;
            list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
            list.addAll(dataInfoProvider3.getDataInfo(mode));
        } else {
            list.add((Component)Component.translatable((String)state.getBlock().getDescriptionId()).withStyle(ChatFormatting.BLUE));
        }
        if ((mode == DisplayMode.SHOW_ALL || mode == DisplayMode.SHOW_ENVIRONMENTAL_INFO) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            list.add((Component)Component.translatable((String)"behavior.portable_scanner.divider"));
            BedrockFluidVeinSavedData veinData = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
            int chunkX = pos.getX() >> 4;
            int chunkZ = pos.getZ() >> 4;
            Fluid fluid = veinData.getFluidInChunk(chunkX, chunkZ);
            if (fluid != null) {
                FluidStack stack = new FluidStack(fluid, veinData.getOperationsRemaining(chunkX, chunkZ));
                double fluidPercent = (double)stack.getAmount() * 100.0 / 100000.0;
                ProspectorMode.FluidInfo fluidInfo = ProspectorMode.FluidInfo.fromVeinWorldEntry(veinData.getFluidVeinWorldEntry(chunkX, chunkZ));
                SPacketProspectBedrockFluid packet = new SPacketProspectBedrockFluid((ResourceKey<Level>)level.dimension(), pos, fluidInfo);
                GTNetwork.sendToPlayer((ServerPlayer)player, packet);
                if (player.isCreative()) {
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.bedrock_fluid.amount", (Object[])new Object[]{Component.translatable((String)stack.getTranslationKey()).withStyle(ChatFormatting.GOLD), Component.translatable((String)String.valueOf(veinData.getFluidYield(chunkX, chunkZ))).withStyle(ChatFormatting.GOLD), Component.translatable((String)String.valueOf(fluidPercent)).withStyle(ChatFormatting.YELLOW)}));
                } else {
                    list.add((Component)Component.translatable((String)"behavior.portable_scanner.bedrock_fluid.amount_unknown", (Object[])new Object[]{Component.translatable((String)String.valueOf(fluidPercent)).withStyle(ChatFormatting.YELLOW)}));
                }
            } else {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.bedrock_fluid.nothing"));
            }
            EnvironmentalHazardSavedData environmental = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
            EnvironmentalHazardSavedData.HazardZone environmentHazardZone = environmental.getZoneByContainedPos(pos);
            if (environmentHazardZone != null) {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.environmental_hazard", (Object[])new Object[]{Component.translatable((String)("gtceu.medical_condition." + environmentHazardZone.condition().name)), Component.literal((String)FormattingUtil.formatNumbers(environmentHazardZone.strength()))}));
            } else {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.environmental_hazard.nothing"));
            }
            LocalizedHazardSavedData local = LocalizedHazardSavedData.getOrCreate(serverLevel);
            LocalizedHazardSavedData.HazardZone localHazardZone = local.getZoneByContainedPos(pos);
            if (localHazardZone != null) {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.local_hazard", (Object[])new Object[]{Component.translatable((String)("gtceu.medical_condition." + localHazardZone.condition().name)), Component.literal((String)FormattingUtil.formatNumbers(localHazardZone.strength()))}));
            } else {
                list.add((Component)Component.translatable((String)"behavior.portable_scanner.local_hazard.nothing"));
            }
        }
        if (tileEntity instanceof IDataInfoProvider && (debugInfo = (dataInfoProvider = (IDataInfoProvider)tileEntity).getDebugInfo(player, this.debugLevel, mode)) != null) {
            list.addAll(debugInfo);
        }
        return energyCost;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.translatable((String)"metaitem.behavior.mode_switch.tooltip"));
        tooltipComponents.add((Component)Component.translatable((String)"behavior.portable_scanner.mode.caption", (Object[])new Object[]{Component.translatable((String)this.getMode(stack).getLangKey()).withStyle(ChatFormatting.AQUA)}));
    }

    public static enum DisplayMode {
        SHOW_ALL("behavior.portable_scanner.mode.show_all_info"),
        SHOW_BLOCK_INFO("behavior.portable_scanner.mode.show_block_info"),
        SHOW_MACHINE_INFO("behavior.portable_scanner.mode.show_machine_info"),
        SHOW_ELECTRICAL_INFO("behavior.portable_scanner.mode.show_electrical_info"),
        SHOW_RECIPE_INFO("behavior.portable_scanner.mode.show_recipe_info"),
        SHOW_ENVIRONMENTAL_INFO("behavior.portable_scanner.mode.show_environmental_info");

        private final String langKey;

        private DisplayMode(String langKey) {
            this.langKey = langKey;
        }

        @Generated
        public String getLangKey() {
            return this.langKey;
        }
    }
}

