/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.common.item.armor.QuarkTechSuite;
import com.gregtechceu.gtceu.core.IFireImmuneEntity;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AdvancedQuarkTechSuite
extends QuarkTechSuite
implements IJetpack {
    private long timer = 0L;
    private List<Pair<NonNullList<ItemStack>, IntList>> inventoryIndexMap;

    public AdvancedQuarkTechSuite(int energyPerUse, long capacity, int tier) {
        super(ArmorItem.Type.CHESTPLATE, energyPerUse, capacity, tier);
    }

    @Override
    public void onArmorTick(Level world, Player player, ItemStack item) {
        IElectricItem cont = GTCapabilityHelper.getElectricItem(item);
        if (cont == null) {
            return;
        }
        CompoundTag data = item.getOrCreateTag();
        if (!data.contains("enabled")) {
            data.putBoolean("enabled", true);
            data.putBoolean("hover", false);
            data.putByte("toggleTimer", (byte)0);
            data.putBoolean("canShare", false);
        }
        boolean jetpackEnabled = data.getBoolean("enabled");
        boolean hoverMode = data.getBoolean("hover");
        int toggleTimer = data.getByte("toggleTimer");
        boolean canShare = data.getBoolean("canShare");
        Object messageKey = null;
        if (toggleTimer == 0) {
            if (KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
                jetpackEnabled = !jetpackEnabled;
                messageKey = "metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable");
                data.putBoolean("enabled", jetpackEnabled);
            } else if (KeyBind.ARMOR_HOVER.isKeyDown(player)) {
                hoverMode = !hoverMode;
                messageKey = "metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable");
                data.putBoolean("hover", hoverMode);
            } else if (KeyBind.ARMOR_CHARGING.isKeyDown(player)) {
                boolean bl = canShare = !canShare;
                if (canShare && cont.getCharge() == 0L) {
                    messageKey = "metaarmor.qts.share.error";
                    canShare = false;
                } else {
                    messageKey = "metaarmor.qts.share." + (canShare ? "enable" : "disable");
                }
                data.putBoolean("canShare", canShare);
            }
            if (messageKey != null) {
                toggleTimer = 5;
                if (!world.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)messageKey), true);
                }
            }
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.putByte("toggleTimer", (byte)toggleTimer);
        this.performFlying(player, jetpackEnabled, hoverMode, item);
        if (this.type == ArmorItem.Type.CHESTPLATE && !player.fireImmune()) {
            ((IFireImmuneEntity)player).gtceu$setFireImmune(true);
            if (player.isOnFire()) {
                player.extinguishFire();
            }
        }
        if (canShare && !world.isClientSide) {
            if (this.timer % 100L == 0L) {
                this.inventoryIndexMap = ArmorUtils.getChargeableItem(player, cont.getTier());
            }
            if (this.inventoryIndexMap != null && !this.inventoryIndexMap.isEmpty()) {
                for (int i = 0; i < this.inventoryIndexMap.size(); ++i) {
                    Pair<NonNullList<ItemStack>, IntList> inventoryMap = this.inventoryIndexMap.get(i);
                    IntListIterator inventoryIterator = ((IntList)inventoryMap.getSecond()).iterator();
                    while (inventoryIterator.hasNext()) {
                        int slot = inventoryIterator.nextInt();
                        IElectricItem chargable = GTCapabilityHelper.getElectricItem((ItemStack)((NonNullList)inventoryMap.getFirst()).get(slot));
                        if (chargable == null || chargable == cont) {
                            inventoryIterator.remove();
                            continue;
                        }
                        long attemptedChargeAmount = chargable.getTransferLimit() * 10L;
                        if (chargable.getCharge() >= chargable.getMaxCharge() || !cont.canUse(attemptedChargeAmount) || this.timer % 10L != 0L) continue;
                        long delta = chargable.charge(attemptedChargeAmount, cont.getTier(), true, false);
                        if (delta > 0L) {
                            cont.discharge(delta, cont.getTier(), true, false, false);
                        }
                        if (chargable.getCharge() == chargable.getMaxCharge()) {
                            inventoryIterator.remove();
                        }
                        player.inventoryMenu.sendAllDataToRemote();
                    }
                    if (!((IntList)inventoryMap.getSecond()).isEmpty()) continue;
                    this.inventoryIndexMap.remove(inventoryMap);
                }
            }
        }
        ++this.timer;
        if (this.timer == Long.MAX_VALUE) {
            this.timer = 0L;
        }
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        CompoundTag data = itemStack.getOrCreateTag();
        boolean enabled = !data.contains("enabled") || data.getBoolean("enabled");
        MutableComponent state = enabled ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.translatable((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{state}));
        boolean canShare = data.contains("canShare") && data.getBoolean("canShare");
        state = canShare ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.translatable((String)"metaarmor.energy_share.tooltip", (Object[])new Object[]{state}));
        lines.add((Component)Component.translatable((String)"metaarmor.energy_share.tooltip.guide"));
        boolean hover = data.contains("hover") && data.getBoolean("hover");
        state = hover ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.translatable((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{state}));
    }

    @Override
    public InteractionResultHolder<ItemStack> onRightClick(Level world, Player player, InteractionHand hand) {
        ItemStack armor = player.getItemInHand(hand);
        if (armor.getItem() instanceof ArmorComponentItem && player.isShiftKeyDown()) {
            CompoundTag data = armor.getOrCreateTag();
            boolean canShare = data.contains("canShare") && data.getBoolean("canShare");
            IElectricItem cont = GTCapabilityHelper.getElectricItem(armor);
            if (cont == null) {
                return InteractionResultHolder.fail((Object)armor);
            }
            boolean bl = canShare = !canShare;
            if (!world.isClientSide) {
                if (canShare && cont.getCharge() == 0L) {
                    player.sendSystemMessage((Component)Component.translatable((String)"metaarmor.energy_share.error"));
                } else if (canShare) {
                    player.sendSystemMessage((Component)Component.translatable((String)"metaarmor.energy_share.enable"));
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"metaarmor.energy_share.disable"));
                }
            }
            canShare = canShare && cont.getCharge() != 0L;
            data.putBoolean("canShare", canShare);
            return InteractionResultHolder.success((Object)armor);
        }
        return super.onRightClick(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        AdvancedQuarkTechSuite.addCapacityHUD(item, this.HUD);
        IElectricItem cont = GTCapabilityHelper.getElectricItem(item);
        if (cont == null) {
            return;
        }
        if (!cont.canUse(this.energyPerUse)) {
            return;
        }
        CompoundTag data = item.getTag();
        if (data != null) {
            Object status;
            if (data.contains("enabled")) {
                status = data.getBoolean("enabled") ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
                MutableComponent result = Component.translatable((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{status});
                this.HUD.newString((Component)result);
            }
            if (data.contains("canShare")) {
                status = data.getBoolean("canShare") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
                this.HUD.newString((Component)Component.translatable((String)"mataarmor.hud.supply_mode", (Object[])new Object[]{Component.translatable((String)status)}));
            }
            if (data.contains("hover")) {
                status = data.getBoolean("hover") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
                this.HUD.newString((Component)Component.translatable((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{Component.translatable((String)status)}));
            }
        }
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/advanced_quark_tech_suite_1.png");
    }

    @Override
    public double getDamageAbsorption() {
        return 1.5;
    }

    @Override
    public boolean canUseEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = AdvancedQuarkTechSuite.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.canUse(amount);
    }

    @Override
    public void drainEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = AdvancedQuarkTechSuite.getIElectricItem(stack);
        if (container == null) {
            return;
        }
        container.discharge(amount, this.tier, true, false, false);
    }

    @Override
    public boolean hasEnergy(@NotNull ItemStack stack) {
        IElectricItem container = AdvancedQuarkTechSuite.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.getCharge() > 0L;
    }

    private static IElectricItem getIElectricItem(@NotNull ItemStack stack) {
        return GTCapabilityHelper.getElectricItem(stack);
    }

    @Override
    public double getSprintEnergyModifier() {
        return 6.0;
    }

    @Override
    public double getSprintSpeedModifier() {
        return 2.4;
    }

    @Override
    public double getVerticalHoverSpeed() {
        return 0.45;
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.0;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.15;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.9;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.21;
    }

    @Override
    public ParticleOptions getParticle() {
        return null;
    }

    @Override
    public float getFallDamageReduction() {
        return 8.0f;
    }
}

