/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ArmorProperty;
import com.gregtechceu.gtceu.client.renderer.item.ArmorItemRenderer;
import com.lowdragmc.lowdraglib.Platform;
import java.util.Objects;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTArmorItem
extends ArmorItem {
    public final Material material;
    public final ArmorProperty armorProperty;

    public GTArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties, Material material, ArmorProperty armorProperty) {
        super(armorMaterial, type, properties);
        this.material = material;
        this.armorProperty = armorProperty;
        if (Platform.isClient()) {
            ArmorItemRenderer.create((Item)this, type);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt1618$temp;
            if (index == 0 && (patt1618$temp = itemStack.getItem()) instanceof GTArmorItem) {
                GTArmorItem item = (GTArmorItem)patt1618$temp;
                Material material = item.material;
                return material.getLayerARGB(index);
            }
            return -1;
        };
    }

    @NotNull
    public String getDescriptionId() {
        return "item.gtceu.armor." + this.type.getName();
    }

    @NotNull
    public Component getDescription() {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public Component getName(ItemStack stack) {
        return this.getDescription();
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation id = this.armorProperty.getCustomTextureGetter().getCustomTexture(stack, entity, slot, Objects.equals(type, "overlay"));
        if (id != null) {
            return id.toString();
        }
        return null;
    }
}

