/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.utils.input.SyncedKeyMappings;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IJetpack {
    default public double getSprintEnergyModifier() {
        return 1.0;
    }

    default public double getSprintSpeedModifier() {
        return 1.0;
    }

    default public double getVerticalHoverSpeed() {
        return 0.18;
    }

    default public double getVerticalHoverSlowSpeed() {
        return 0.14;
    }

    default public double getVerticalAcceleration() {
        return 0.1;
    }

    default public double getVerticalSpeed() {
        return 0.22;
    }

    default public double getSidewaysSpeed() {
        return 0.0;
    }

    default public boolean removeMiningSpeedPenalty() {
        return true;
    }

    @Nullable
    default public ParticleOptions getParticle() {
        return ParticleTypes.LARGE_SMOKE;
    }

    default public float getFallDamageReduction() {
        return 0.0f;
    }

    public int getEnergyPerUse();

    public boolean canUseEnergy(ItemStack var1, int var2);

    public void drainEnergy(ItemStack var1, int var2);

    public boolean hasEnergy(ItemStack var1);

    default public void performFlying(@NotNull Player player, boolean flightEnabled, boolean hover, ItemStack stack) {
        double deltaY = player.getDeltaMovement().y();
        if (!(flightEnabled && hover || !(player.getY() < (double)(player.level().getMinBuildHeight() - 5)))) {
            IJetpack.performEHover(stack, player);
        } else if (!flightEnabled) {
            return;
        }
        boolean flyKeyDown = SyncedKeyMappings.VANILLA_JUMP.isKeyDown(player);
        boolean descendKeyDown = SyncedKeyMappings.VANILLA_SNEAK.isKeyDown(player);
        double currentAccel = this.getVerticalAcceleration() * (deltaY < 0.3 ? 2.5 : 1.0);
        if (!player.onGround() && player.getSleepingPos().isEmpty() && this.canUseEnergy(stack, this.getEnergyPerUse())) {
            double potentialY = 0.0;
            boolean editMotion = true;
            if (hover) {
                potentialY = flyKeyDown && descendKeyDown ? this.getVerticalHoverSlowSpeed() : (flyKeyDown ? this.getVerticalHoverSpeed() : (descendKeyDown ? -this.getVerticalHoverSpeed() : -this.getVerticalHoverSlowSpeed()));
                if (player.isFallFlying()) {
                    player.stopFallFlying();
                }
            } else if (flyKeyDown && descendKeyDown) {
                potentialY = 0.0;
            } else if (flyKeyDown) {
                potentialY = this.getVerticalSpeed() * (player.isInWater() ? 0.4 : 1.0);
            } else {
                editMotion = false;
            }
            if (editMotion) {
                potentialY = Math.min(deltaY + currentAccel, potentialY);
                IJetpack.setYMotion(player, potentialY);
            }
            float speedSideways = (float)(player.isShiftKeyDown() ? this.getSidewaysSpeed() * 0.5 : this.getSidewaysSpeed());
            float speedForward = (float)(player.isSprinting() ? (double)speedSideways * this.getSprintSpeedModifier() : (double)speedSideways);
            if (!player.isFallFlying()) {
                double dist;
                Vec3 movement = new Vec3(0.0, 0.0, 0.0);
                if (SyncedKeyMappings.VANILLA_FORWARD.isKeyDown(player)) {
                    movement = movement.add(0.0, 0.0, (double)speedForward);
                }
                if (SyncedKeyMappings.VANILLA_BACKWARD.isKeyDown(player)) {
                    movement = movement.add(0.0, 0.0, (double)(-speedSideways * 0.8f));
                }
                if (SyncedKeyMappings.VANILLA_LEFT.isKeyDown(player)) {
                    movement = movement.add((double)speedSideways, 0.0, 0.0);
                }
                if (SyncedKeyMappings.VANILLA_RIGHT.isKeyDown(player)) {
                    movement = movement.add((double)(-speedSideways), 0.0, 0.0);
                }
                if ((dist = movement.length()) >= 1.0E-7) {
                    player.moveRelative((float)dist, movement);
                    if (!editMotion) {
                        editMotion = true;
                    }
                }
            }
            if (editMotion) {
                int energyUsed = (int)Math.round((double)this.getEnergyPerUse() * (player.isSprinting() ? this.getSprintEnergyModifier() : 1.0));
                this.drainEnergy(stack, energyUsed);
                ArmorUtils.spawnParticle(player.level(), player, this.getParticle(), -0.6);
            }
            if (!player.level().isClientSide && (hover || flyKeyDown)) {
                player.fallDistance = 0.0f;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.aboveGroundTickCount = 0;
                }
            }
        }
    }

    private static void setYMotion(Player player, double value) {
        Vec3 motion = player.getDeltaMovement();
        player.setDeltaMovement(motion.x(), value, motion.z());
    }

    public static void performEHover(ItemStack stack, Player player) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putBoolean("enabled", true);
        tag.putBoolean("hover", true);
        player.displayClientMessage((Component)Component.translatable((String)"metaarmor.jetpack.emergency_hover_mode"), true);
        player.fallDistance = 0.0f;
        if (!player.level().isClientSide && player instanceof ServerPlayer) {
            ((ServerPlayer)player).connection.aboveGroundTickCount = 0;
        }
        player.inventoryMenu.sendAllDataToRemote();
    }

    private static void addYMotion(Player player, double value) {
        Vec3 motion = player.getDeltaMovement();
        player.addDeltaMovement(new Vec3(motion.x(), value, motion.z()));
    }
}

