/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDamageBehavior
implements IToolBehavior {
    private final List<EntityDamageFunction> shouldDoBonusList = new ArrayList<EntityDamageFunction>();
    private final String mobType;

    public EntityDamageBehavior(float bonus, Class<?> ... entities) {
        this(null, bonus, entities);
    }

    public EntityDamageBehavior(Object2FloatMap<Class<?>> entityDamageMap) {
        this(null, entityDamageMap);
    }

    public EntityDamageBehavior(String mobType, float bonus, Class<?> ... entities) {
        this.mobType = mobType;
        for (Class<?> entity : entities) {
            this.shouldDoBonusList.add(EntityDamageBehavior.damageForClass(entity, bonus));
        }
    }

    public EntityDamageBehavior(String mobType, Object2FloatMap<Class<?>> entityDamageMap) {
        this.mobType = mobType;
        for (Object2FloatMap.Entry entry : Object2FloatMaps.fastIterable(entityDamageMap)) {
            Class entity = (Class)entry.getKey();
            float bonus = entry.getFloatValue();
            this.shouldDoBonusList.add(EntityDamageBehavior.damageForClass(entity, bonus));
        }
    }

    @Override
    public void hitEntity(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        float damageBonus = this.getDamageBonus(target);
        if (damageBonus != 0.0f) {
            DamageSource damageSource;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.damageSources().playerAttack(player);
            } else {
                damageSource = attacker.damageSources().mobAttack(attacker);
            }
            DamageSource source = damageSource;
            target.hurt(source, damageBonus);
        }
    }

    private float getDamageBonus(@NotNull LivingEntity target) {
        for (EntityDamageFunction func : this.shouldDoBonusList) {
            float f = func.damageFor(target);
            if (!(f > 0.0f)) continue;
            return f;
        }
        return 0.0f;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.mobType != null && !this.mobType.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.behavior.damage_boost", (Object[])new Object[]{Component.translatable((String)("item.gtceu.tool.behavior.damage_boost_" + this.mobType))}));
        }
    }

    static EntityDamageFunction damageForClass(Class<?> clazz, float damage) {
        return e -> clazz.isAssignableFrom(e.getClass()) ? damage : 0.0f;
    }

    @FunctionalInterface
    private static interface EntityDamageFunction {
        public float damageFor(LivingEntity var1);
    }
}

