/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.common.block.explosive.GTExplosiveBlock;
import com.gregtechceu.gtceu.common.block.explosive.IndustrialTNTBlock;
import com.gregtechceu.gtceu.common.block.explosive.PowderbarrelBlock;
import com.gregtechceu.gtceu.utils.GradientUtil;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LighterBehavior
implements IDurabilityBar,
IInteractionItem,
IAddInformation {
    public static final String LIGHTER_OPEN = "lighterOpen";
    private static final String USES_LEFT = "usesLeft";
    private static final IntIntPair DURABILITY_BAR_COLORS = GradientUtil.getGradient(15761181, 10);
    private final boolean usesFluid;
    private final boolean hasMultipleUses;
    private final boolean canOpen;
    private Supplier<ItemStack> destroyItem = () -> ItemStack.EMPTY;
    private int maxUses = 0;
    private static boolean defaultsCacheInit = false;
    private static final Reference2BooleanMap<Class<?>> IMPLS_CACHE = new Reference2BooleanOpenHashMap();

    public LighterBehavior(boolean useFluid, boolean hasMultipleUses, boolean canOpen, Supplier<ItemStack> destroyItem, int maxUses) {
        this(useFluid, hasMultipleUses, canOpen);
        this.maxUses = maxUses;
        this.destroyItem = destroyItem;
    }

    public LighterBehavior(boolean useFluid, boolean hasMultipleUses, boolean canOpen) {
        this.usesFluid = useFluid;
        this.hasMultipleUses = hasMultipleUses;
        this.canOpen = canOpen;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        CompoundTag tag = itemStack.getOrCreateTag();
        if (this.canOpen && player.isCrouching()) {
            tag.putBoolean(LIGHTER_OPEN, !tag.getBoolean(LIGHTER_OPEN));
            itemStack.setTag(tag);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        CompoundTag tag = itemStack.getOrCreateTag();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(this.canOpen && !tag.getBoolean(LIGHTER_OPEN) || player != null && player.isShiftKeyDown())) {
            if (LighterBehavior.classImplementsOnCaughtFire(block.getClass())) {
                if (!this.consumeFuel(player, itemStack)) {
                    return InteractionResult.PASS;
                }
                state.onCaughtFire(level, pos, clickedFace, (LivingEntity)player);
                FluidState fluidState = level.getFluidState(pos);
                level.setBlock(pos, fluidState.createLegacyBlock(), 11);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (CampfireBlock.canLight((BlockState)state) || CandleBlock.canLight((BlockState)state) || CandleCakeBlock.canLight((BlockState)state)) {
                if (!this.consumeFuel(player, itemStack)) {
                    return InteractionResult.PASS;
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)AbstractCandleBlock.LIT, (Comparable)Boolean.valueOf(true)), 11);
                level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                level.gameEvent((Entity)player, GameEvent.BLOCK_CHANGE, pos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            BlockPos offset = pos.relative(clickedFace);
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)offset, (Direction)context.getHorizontalDirection())) {
                if (!this.consumeFuel(player, itemStack)) {
                    return InteractionResult.PASS;
                }
                level.playSound(player, offset, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState fireState = BaseFireBlock.getState((BlockGetter)level, (BlockPos)offset);
                level.setBlock(offset, fireState, 11);
                level.gameEvent((Entity)player, GameEvent.BLOCK_PLACE, pos);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, offset, itemStack);
                    itemStack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(context.getHand()));
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        CompoundTag tag = stack.getOrCreateTag();
        Level level = player.level();
        if ((!this.canOpen || tag.getBoolean(LIGHTER_OPEN)) && !player.isShiftKeyDown() && interactionTarget instanceof Creeper) {
            Creeper creeper = (Creeper)interactionTarget;
            if (!this.consumeFuel(player, stack)) {
                return InteractionResult.PASS;
            }
            level.playSound(player, (Entity)creeper, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            if (!level.isClientSide) {
                creeper.ignite();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean consumeFuel(@Nullable Player player, ItemStack stack) {
        if (player != null && player.isCreative()) {
            return true;
        }
        int usesLeft = this.getUsesLeft(stack) - 1;
        if (usesLeft >= 0) {
            this.setUsesLeft(player, stack, usesLeft);
            return true;
        }
        return false;
    }

    private int getUsesLeft(ItemStack stack) {
        if (this.usesFluid) {
            Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).resolve();
            if (handler.isEmpty()) {
                return 0;
            }
            FluidStack fluid = ((IFluidHandlerItem)handler.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            return fluid.getAmount();
        }
        if (this.hasMultipleUses) {
            CompoundTag compound = stack.getOrCreateTag();
            if (compound.contains(USES_LEFT)) {
                return compound.getInt(USES_LEFT);
            }
            compound.putInt(USES_LEFT, this.maxUses);
            return this.maxUses;
        }
        return stack.getCount();
    }

    private void setUsesLeft(Player player, @NotNull ItemStack stack, int usesLeft) {
        if (this.usesFluid) {
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
                FluidStack fluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!fluid.isEmpty()) {
                    handler.drain(fluid.getAmount() - usesLeft, IFluidHandler.FluidAction.EXECUTE);
                }
            });
        } else if (this.hasMultipleUses) {
            if (usesLeft <= 0) {
                stack.shrink(1);
                ItemStack brokenStack = this.destroyItem.get();
                if (!player.addItem(brokenStack)) {
                    player.drop(brokenStack, true);
                }
            } else {
                stack.getOrCreateTag().putInt(USES_LEFT, usesLeft);
            }
        } else {
            stack.setCount(usesLeft);
        }
    }

    @Override
    public float getDurabilityForDisplay(ItemStack stack) {
        if (this.usesFluid) {
            Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).resolve();
            if (handler.isEmpty()) {
                return 0.0f;
            }
            FluidStack fluid = ((IFluidHandlerItem)handler.get()).getFluidInTank(0);
            return (float)fluid.getAmount() / (float)((IFluidHandlerItem)handler.get()).getTankCapacity(0);
        }
        if (this.hasMultipleUses) {
            return (float)this.getUsesLeft(stack) / (float)this.maxUses;
        }
        return 0.0f;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return this.usesFluid || this.hasMultipleUses;
    }

    @Override
    public boolean showEmptyBar(ItemStack itemStack) {
        return this.usesFluid || this.hasMultipleUses;
    }

    @Override
    @Nullable
    public IntIntPair getDurabilityColorsForDisplay(ItemStack itemStack) {
        if (this.hasMultipleUses && this.usesFluid) {
            return DURABILITY_BAR_COLORS;
        }
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.translatable((String)(this.usesFluid ? "behaviour.lighter.fluid.tooltip" : "behaviour.lighter.tooltip.description")));
        tooltipComponents.add((Component)Component.translatable((String)"behaviour.lighter.tooltip.usage"));
        if (this.hasMultipleUses && !this.usesFluid) {
            tooltipComponents.add((Component)Component.translatable((String)"behaviour.lighter.uses", (Object[])new Object[]{this.getUsesLeft(stack)}));
        }
    }

    private static boolean classImplementsOnCaughtFire(Class<? extends Block> clazz) {
        boolean exists;
        if (!defaultsCacheInit) {
            defaultsCacheInit = true;
            LighterBehavior.initCacheDefaults();
        }
        if (IMPLS_CACHE.containsKey(clazz)) {
            return IMPLS_CACHE.getBoolean(clazz);
        }
        for (Class<? extends Block> cls = clazz; cls != Block.class; cls = cls.getSuperclass()) {
            if (!IMPLS_CACHE.containsKey(cls)) continue;
            boolean val = IMPLS_CACHE.getBoolean(cls);
            IMPLS_CACHE.put(clazz, val);
            return val;
        }
        try {
            Method onCaughtFire = clazz.getDeclaredMethod("onCaughtFire", BlockState.class, Level.class, BlockPos.class, Direction.class, LivingEntity.class);
            int modifiers = onCaughtFire.getModifiers();
            exists = !onCaughtFire.getDeclaringClass().isInterface() && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
            IMPLS_CACHE.put(onCaughtFire.getDeclaringClass(), exists);
        }
        catch (NoSuchMethodException e) {
            exists = false;
        }
        IMPLS_CACHE.put(clazz, exists);
        return exists;
    }

    private static void initCacheDefaults() {
        if (!LighterBehavior.classImplementsOnCaughtFire(TntBlock.class)) {
            throw new AssertionError((Object)"TntBlock doesn't implement IForgeBlock#onCaughtFire!Something is seriously wrong!Maybe check if the method name changed?");
        }
        LighterBehavior.classImplementsOnCaughtFire(GTExplosiveBlock.class);
        LighterBehavior.classImplementsOnCaughtFire(IndustrialTNTBlock.class);
        LighterBehavior.classImplementsOnCaughtFire(PowderbarrelBlock.class);
    }
}

