/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.rotation;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.common.item.tool.rotation.ICustomRotationBehavior;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;

public class CustomBlockRotations {
    private static final Map<Block, ICustomRotationBehavior> CUSTOM_BEHAVIOR_MAP = new Object2ObjectOpenHashMap();
    public static final ICustomRotationBehavior BLOCK_HORIZONTAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(BlockState state, Level world, BlockPos pos, BlockHitResult hitResult) {
            Direction gridSide = ICoverable.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide.getAxis() == Direction.Axis.Y) {
                return false;
            }
            if (gridSide != state.getValue((Property)HorizontalDirectionalBlock.FACING)) {
                state = (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)gridSide);
                world.setBlockAndUpdate(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showSideTip(BlockState state, Direction side) {
            return side.getAxis() != Direction.Axis.Y && state.getValue((Property)HorizontalDirectionalBlock.FACING) != side;
        }
    };
    public static final ICustomRotationBehavior BLOCK_DIRECTIONAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(BlockState state, Level world, BlockPos pos, BlockHitResult hitResult) {
            Direction gridSide = ICoverable.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide != state.getValue((Property)DirectionalBlock.FACING)) {
                state = (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)gridSide);
                world.setBlockAndUpdate(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showSideTip(BlockState state, Direction side) {
            return state.getValue((Property)DirectionalBlock.FACING) != side;
        }
    };

    @ApiStatus.Internal
    public static void init() {
        CustomRotations.init();
    }

    public static void registerCustomRotation(Block block, ICustomRotationBehavior behavior) {
        CUSTOM_BEHAVIOR_MAP.put(block, behavior);
    }

    public static ICustomRotationBehavior getCustomRotation(Block block) {
        return CUSTOM_BEHAVIOR_MAP.get(block);
    }

    private static enum CustomRotations {
        PISTON(Blocks.PISTON, BLOCK_DIRECTIONAL_BEHAVIOR),
        STICKY_PISTON(Blocks.STICKY_PISTON, BLOCK_DIRECTIONAL_BEHAVIOR),
        DROPPER(Blocks.DROPPER, BLOCK_DIRECTIONAL_BEHAVIOR),
        DISPENSER(Blocks.DISPENSER, BLOCK_DIRECTIONAL_BEHAVIOR),
        OBSERVER(Blocks.OBSERVER, BLOCK_DIRECTIONAL_BEHAVIOR),
        FURNACE(Blocks.FURNACE, BLOCK_HORIZONTAL_BEHAVIOR),
        PUMPKIN(Blocks.CARVED_PUMPKIN, BLOCK_HORIZONTAL_BEHAVIOR),
        LIT_PUMPKIN(Blocks.JACK_O_LANTERN, BLOCK_HORIZONTAL_BEHAVIOR),
        CHEST(Blocks.CHEST, BLOCK_HORIZONTAL_BEHAVIOR),
        TRAPPED_CHEST(Blocks.TRAPPED_CHEST, BLOCK_HORIZONTAL_BEHAVIOR),
        ENDER_CHEST(Blocks.ENDER_CHEST, BLOCK_HORIZONTAL_BEHAVIOR),
        HOPPER(Blocks.HOPPER, new ICustomRotationBehavior(){

            @Override
            public boolean customRotate(BlockState state, Level world, BlockPos pos, BlockHitResult hitResult) {
                Direction gridSide = ICoverable.determineGridSideHit(hitResult);
                if (gridSide == null || gridSide == Direction.UP) {
                    return false;
                }
                if (gridSide != state.getValue((Property)HopperBlock.FACING)) {
                    state = (BlockState)state.setValue((Property)HopperBlock.FACING, (Comparable)gridSide);
                    world.setBlockAndUpdate(pos, state);
                    return true;
                }
                return false;
            }

            @Override
            public boolean showSideTip(BlockState state, Direction side) {
                return side != Direction.UP && state.getValue((Property)HopperBlock.FACING) != side;
            }
        });


        private CustomRotations(Block block, ICustomRotationBehavior behavior) {
            CustomBlockRotations.registerCustomRotation(block, behavior);
        }

        private static void init() {
        }
    }
}

