/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardCleaner;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.blockentity.DuctPipeBlockEntity;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.hazard.SPacketRemoveHazardZone;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class AirScrubberMachine
extends SimpleTieredMachine
implements IEnvironmentalHazardCleaner {
    public static final float MIN_CLEANING_PER_OPERATION = 10.0f;
    private float cleaningPerOperation = 10.0f;
    private float removedLastSecond;

    public AirScrubberMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, GTMachineUtils.largeTankSizeFunction, args);
    }

    @Override
    public boolean regressWhenWaiting() {
        return false;
    }

    @Override
    public void cleanHazard(MedicalCondition condition, float amount) {
        if (this.recipeLogic.isActive()) {
            return;
        }
        GTRecipeBuilder builder = GTRecipeTypes.AIR_SCRUBBER_RECIPES.recipeBuilder(condition.name + "_autogen").duration(200).EUt(GTValues.VHA[1]);
        condition.recipeModifier.accept(builder);
        this.recipeLogic.checkMatchedRecipeAvailable(builder.buildRawRecipe());
    }

    @Override
    public boolean isRecipeLogicAvailable() {
        return ConfigHolder.INSTANCE.gameplay.environmentalHazards;
    }

    @Override
    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        if (super.beforeWorking(recipe) && recipe != null) {
            this.cleaningPerOperation = 10.0f * (float)(recipe.ocLevel + 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean onWorking() {
        if (!super.onWorking() || !ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return false;
        }
        if (this.getOffsetTimer() % 20L == 0L) {
            this.removedLastSecond = 0.0f;
            for (Direction dir : GTUtil.DIRECTIONS) {
                DuctPipeBlockEntity duct;
                BlockEntity blockEntity;
                BlockPos offset = this.getPos().relative(dir);
                if (GTCapabilityHelper.getHazardContainer(this.getLevel(), offset, dir.getOpposite()) == null || (blockEntity = this.getLevel().getBlockEntity(offset)) instanceof DuctPipeBlockEntity && !(duct = (DuctPipeBlockEntity)blockEntity).isConnected(dir.getOpposite())) continue;
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)this.getLevel();
            EnvironmentalHazardSavedData savedData = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
            ChunkPos pos = new ChunkPos(this.getPos());
            Object2FloatOpenHashMap relativePositions = new Object2FloatOpenHashMap();
            int radius = this.tier / 2;
            if (radius <= 0) {
                relativePositions.put((Object)pos, 1.0f);
            } else {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        relativePositions.put((Object)new ChunkPos(pos.x + x, pos.z + z), Mth.sqrt((float)Mth.abs((int)(x * z))) + 1.0f);
                    }
                }
            }
            for (ChunkPos rel : relativePositions.keySet()) {
                float distance = relativePositions.getFloat((Object)rel);
                savedData.getHazardZones().compute(rel, (chunkPos, zone) -> {
                    if (zone == null || zone.strength() <= 0.0f) {
                        return null;
                    }
                    float toClean = this.cleaningPerOperation / distance;
                    this.removedLastSecond += toClean;
                    zone.removeStrength(toClean);
                    if (zone.strength() <= 0.0f) {
                        if (serverLevel.hasChunk(chunkPos.x, chunkPos.z)) {
                            LevelChunk chunk = serverLevel.getChunk(chunkPos.x, chunkPos.z);
                            GTNetwork.sendToAllPlayersTrackingChunk(chunk, new SPacketRemoveHazardZone((ChunkPos)chunkPos));
                        }
                        return null;
                    }
                    return zone;
                });
            }
        }
        return true;
    }

    @Override
    @Generated
    public float getRemovedLastSecond() {
        return this.removedLastSecond;
    }
}

