/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IMonitorComponent;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHostTrait;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HullMachine
extends TieredPartMachine
implements IMonitorComponent {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(HullMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private final Object gridNodeHost = GTCEu.Mods.isAE2Loaded() ? new GridNodeHostTrait(this) : null;
    @Persisted
    protected NotifiableEnergyContainer energyContainer;

    public HullMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.reinitializeEnergyContainer();
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = new NotifiableEnergyContainer(this, tierVoltage * 16L, tierVoltage, 1L, tierVoltage, 1L);
        this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing());
    }

    @Override
    public void onLoad() {
        Object object;
        super.onLoad();
        if (GTCEu.Mods.isAE2Loaded() && (object = this.gridNodeHost) instanceof GridNodeHostTrait) {
            GridNodeHostTrait connectedBlockEntity = (GridNodeHostTrait)object;
            object = this.getLevel();
            if (object instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                level.getServer().tell((Runnable)new TickTask(0, connectedBlockEntity::init));
            }
        }
    }

    @Override
    public void onUnload() {
        Object object;
        super.onUnload();
        if (GTCEu.Mods.isAE2Loaded() && (object = this.gridNodeHost) instanceof GridNodeHostTrait) {
            GridNodeHostTrait connectedBlockEntity = (GridNodeHostTrait)object;
            connectedBlockEntity.getMainNode().destroy();
        }
    }

    @Override
    public void setFrontFacing(Direction facing) {
        Object object;
        super.setFrontFacing(facing);
        if (this.isFacingValid(facing) && GTCEu.Mods.isAE2Loaded() && (object = this.gridNodeHost) instanceof GridNodeHostTrait) {
            GridNodeHostTrait connectedBlockEntity = (GridNodeHostTrait)object;
            connectedBlockEntity.init();
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        Object object;
        super.saveCustomPersistedData(tag, forDrop);
        if (GTCEu.Mods.isAE2Loaded() && (object = this.gridNodeHost) instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity connectedBlockEntity = (IGridConnectedBlockEntity)object;
            CompoundTag nbt = new CompoundTag();
            connectedBlockEntity.getMainNode().saveToNBT(nbt);
            tag.put("grid_node", (Tag)nbt);
        }
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        Object object;
        super.loadCustomPersistedData(tag);
        if (GTCEu.Mods.isAE2Loaded() && (object = this.gridNodeHost) instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity connectedBlockEntity = (IGridConnectedBlockEntity)object;
            connectedBlockEntity.getMainNode().loadFromNBT(tag.getCompound("grid_node"));
        }
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    @Override
    public IGuiTexture getComponentIcon() {
        return GuiTextures.BUTTON_CHECK;
    }
}

