/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICentralMonitor;
import com.gregtechceu.gtceu.api.capability.IMonitorComponent;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMonitorModuleItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import com.gregtechceu.gtceu.common.machine.trait.CentralMonitorLogic;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.SCPacketMonitorGroupNBTChange;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CentralMonitorMachine
extends WorkableElectricMultiblockMachine
implements IMonitorComponent,
IDataInfoProvider,
IMachineLife,
ICentralMonitor {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CentralMonitorMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    private int leftDist = 0;
    @Persisted
    @DescSynced
    private int rightDist = 0;
    @Persisted
    @DescSynced
    private int upDist = 0;
    @Persisted
    @DescSynced
    private int downDist = 0;
    @Persisted
    @DescSynced
    @RequireRerender
    private final List<MonitorGroup> monitorGroups = new ArrayList<MonitorGroup>();
    private final Set<IMonitorComponent> selectedComponents = new HashSet<IMonitorComponent>();
    private final List<IMonitorComponent> selectedTargets = new ArrayList<IMonitorComponent>();
    private MultiblockState patternFindingState;
    private static TraceabilityPredicate MULTI_PREDICATE = null;

    public CentralMonitorMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    public static TraceabilityPredicate getMultiPredicate() {
        if (MULTI_PREDICATE == null) {
            MULTI_PREDICATE = Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(2).setPreviewCount(1).or(Predicates.abilities(PartAbility.DATA_ACCESS).setPreviewCount(1).or(Predicates.machines(GTMachines.BATTERY_BUFFER_4).setPreviewCount(0)).or(Predicates.machines(GTMachines.BATTERY_BUFFER_16).setPreviewCount(0)).setMaxGlobalLimited(4)).or(Predicates.machines(GTMachines.HULL)).or(Predicates.machines(GTMachines.MONITOR)).or(Predicates.machines(GTMachines.ADVANCED_MONITOR)).or(Predicates.blocks((Block)GTBlocks.CASING_ALUMINIUM_FROSTPROOF.get()));
        }
        return MULTI_PREDICATE;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.clearPatternFindingState();
    }

    @Override
    public CentralMonitorLogic getRecipeLogic() {
        return (CentralMonitorLogic)super.getRecipeLogic();
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new CentralMonitorLogic(this);
    }

    @Nullable
    public EnergyContainerList getFormedEnergyContainer() {
        return this.energyContainer;
    }

    public void tick() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        for (MonitorGroup group : this.monitorGroups) {
            Object object;
            ItemStack stack = group.getItemStackHandler().getStackInSlot(0);
            if (stack.isEmpty() || !((object = stack.getItem()) instanceof IComponentItem)) continue;
            IComponentItem componentItem = (IComponentItem)object;
            object = componentItem.getComponents().iterator();
            while (object.hasNext()) {
                IItemComponent component = (IItemComponent)object.next();
                if (!(component instanceof IMonitorModuleItem)) continue;
                IMonitorModuleItem module = (IMonitorModuleItem)component;
                module.tick(stack, this, group);
                GTNetwork.sendToAllPlayersTrackingChunk(level.getChunkAt(this.getPos()), new SCPacketMonitorGroupNBTChange(stack, group, this));
            }
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.clearPatternFindingState();
    }

    protected void clearPatternFindingState() {
        if (this.patternFindingState != null) {
            this.patternFindingState.clean();
        }
        this.patternFindingState = null;
    }

    protected MultiblockState getPatternFindingState() {
        if (this.patternFindingState == null) {
            this.patternFindingState = new MultiblockState(this.getLevel(), this.getPos());
            this.patternFindingState.clean();
        }
        return this.patternFindingState;
    }

    public boolean isValidMonitorBlock(Level level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        MultiblockState state = this.getPatternFindingState();
        if (!state.update(pos, CentralMonitorMachine.getMultiPredicate())) {
            return false;
        }
        state.io = IO.BOTH;
        return Stream.concat(state.predicate.common.stream(), state.predicate.limited.stream()).anyMatch(predicate -> predicate.test(state));
    }

    public void updateStructureDimensions() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        Direction front = this.getFrontFacing();
        Direction spin = this.getUpwardsFacing();
        Direction left = RelativeDirection.LEFT.getRelative(front, spin, false);
        Direction right = RelativeDirection.RIGHT.getRelative(front, spin, false);
        Direction up = RelativeDirection.UP.getRelative(front, spin, false);
        Direction down = RelativeDirection.DOWN.getRelative(front, spin, false);
        BlockPos.MutableBlockPos posLeft = this.getPos().mutable().move(left);
        BlockPos.MutableBlockPos posRight = this.getPos().mutable().move(right);
        BlockPos.MutableBlockPos posUp = this.getPos().mutable().move(up);
        BlockPos.MutableBlockPos posDown = this.getPos().mutable().move(down);
        this.leftDist = 0;
        this.rightDist = 0;
        this.upDist = 0;
        this.downDist = 0;
        while (this.isValidMonitorBlock(level, (BlockPos)posLeft)) {
            posLeft.move(left);
            ++this.leftDist;
        }
        while (this.isValidMonitorBlock(level, (BlockPos)posRight)) {
            posRight.move(right);
            ++this.rightDist;
        }
        while (this.isValidMonitorBlockRow(level, (BlockPos)posUp, this.leftDist, this.rightDist, left, right)) {
            posUp.move(up);
            ++this.upDist;
        }
        while (this.isValidMonitorBlockRow(level, (BlockPos)posDown, this.leftDist, this.rightDist, left, right)) {
            posDown.move(down);
            ++this.downDist;
        }
    }

    private boolean isValidMonitorBlockRow(Level level, BlockPos pos, int leftDist, int rightDist, Direction left, Direction right) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        mutable.move(left, leftDist);
        for (int i = 0; i < leftDist + rightDist; ++i) {
            if (!this.isValidMonitorBlock(level, (BlockPos)mutable)) {
                return false;
            }
            mutable.move(right);
        }
        return this.isValidMonitorBlock(level, (BlockPos)mutable);
    }

    @Override
    public BlockPattern getPattern() {
        this.updateStructureDimensions();
        if (this.leftDist + this.rightDist < 1 || this.upDist + this.downDist < 1) {
            this.leftDist = 3;
            this.rightDist = 0;
            this.upDist = 1;
            this.downDist = 1;
        }
        StringBuilder[] pattern = new StringBuilder[this.upDist + this.downDist + 1];
        for (int i = 0; i < this.upDist + this.downDist + 1; ++i) {
            pattern[i] = new StringBuilder(this.leftDist + this.rightDist + 1);
            for (int j = 0; j < this.leftDist + this.rightDist + 1; ++j) {
                if (i == this.downDist && j == this.rightDist) {
                    pattern[i].append('C');
                    continue;
                }
                pattern[i].append('B');
            }
        }
        String[] aisle = new String[this.upDist + this.downDist + 1];
        for (int i = 0; i < this.upDist + this.downDist + 1; ++i) {
            aisle[i] = pattern[i].toString();
        }
        return FactoryBlockPattern.start().aisle(aisle).where('B', CentralMonitorMachine.getMultiPredicate()).where('C', Predicates.controller(Predicates.blocks(this.getDefinition().get()))).build();
    }

    public BlockPos toRelative(BlockPos pos) {
        Direction front = this.getFrontFacing();
        Direction spin = this.getUpwardsFacing();
        boolean flipped = this.isFlipped();
        Direction right = RelativeDirection.RIGHT.getRelative(front, spin, flipped);
        Direction up = RelativeDirection.UP.getRelative(front, spin, flipped);
        BlockPos.MutableBlockPos tmp = this.getPos().mutable().move(right, this.rightDist).move(up, this.upDist);
        return new BlockPos(Math.abs(tmp.get(right.getAxis()) - pos.get(right.getAxis())), Math.abs(tmp.get(up.getAxis()) - pos.get(up.getAxis())), 0);
    }

    @Nullable
    public IMonitorComponent getComponent(int row, int col) {
        Level level = this.getLevel();
        if (level == null) {
            return null;
        }
        Direction front = this.getFrontFacing();
        Direction spin = this.getUpwardsFacing();
        boolean flipped = this.isFlipped();
        Direction left = RelativeDirection.LEFT.getRelative(front, spin, flipped);
        Direction up = RelativeDirection.UP.getRelative(front, spin, flipped);
        col = this.leftDist + this.rightDist - col;
        BlockPos pos = this.getPos().relative(left, this.leftDist - col).relative(up, this.upDist - row);
        return GTCapabilityHelper.getMonitorComponent(level, pos, null);
    }

    public boolean isMonitor(int row, int col) {
        IMonitorComponent component = this.getComponent(row, col);
        if (component == null) {
            return false;
        }
        return component.isMonitor();
    }

    private IGuiTexture getComponentTexture(int row, int col) {
        if (row < 0 || col < 0 || row > this.downDist + this.upDist + 1 || col > this.leftDist + this.rightDist + 1) {
            return GuiTextures.BLANK_TRANSPARENT;
        }
        IMonitorComponent component = this.getComponent(row, col);
        if (component == null) {
            return GuiTextures.BLANK_TRANSPARENT;
        }
        return component.getComponentIcon();
    }

    private boolean isInAnyGroup(IMonitorComponent component) {
        return this.monitorGroups.stream().anyMatch(group -> group.contains(component.getPos()));
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).addWorkingStatusLine();
        this.getDefinition().getAdditionalDisplay().accept(this, textList);
    }

    @Override
    public Widget createUIWidget() {
        this.updateStructureDimensions();
        this.selectedComponents.clear();
        WidgetGroup builder = (WidgetGroup)super.createUIWidget();
        WidgetGroup main = new WidgetGroup();
        DraggableScrollableWidgetGroup componentSelection = new DraggableScrollableWidgetGroup(0, 10, 200, 110);
        main.addWidget((Widget)componentSelection);
        WidgetGroup options = new WidgetGroup(-100, 20, 60, 20);
        WidgetGroup groupConfig = new WidgetGroup(10, 30, 100, 100);
        groupConfig.setVisible(false);
        ButtonWidget infoWidget = new ButtonWidget(200, 10, 20, 20, null);
        infoWidget.setButtonTexture(new IGuiTexture[]{GuiTextures.INFO_ICON});
        infoWidget.setHoverTooltips(GTStringUtils.toImmutable(LangHandler.getSingleOrMultiLang("gtceu.central_monitor.info_tooltip")));
        builder.addWidget((Widget)infoWidget);
        ArrayList<Object> configGroup = new ArrayList<Object>();
        configGroup.add(null);
        Consumer<MonitorGroup> openGroupConfig = group -> {
            configGroup.set(0, group);
            if (group == null) {
                main.setVisible(true);
                groupConfig.setVisible(false);
                return;
            }
            groupConfig.clearAllWidgets();
            groupConfig.addWidget((Widget)new LabelWidget(0, 5, () -> {
                String currentName = "";
                if (configGroup.get(0) != null) {
                    currentName = ((MonitorGroup)configGroup.get(0)).getName();
                }
                return Component.translatable((String)"gtceu.central_monitor.gui.currently_editing", (Object[])new Object[]{currentName}).getString();
            }));
            for (int i = 0; i < 8; ++i) {
                SlotWidget slot = new SlotWidget((IItemHandlerModifiable)group.getPlaceholderSlotsHandler(), i, -38, 16 * i + 46);
                slot.setHoverTooltips(GTStringUtils.toImmutable(LangHandler.getMultiLang("gtceu.gui.computer_monitor_cover.slot_tooltip", i + 1)));
                groupConfig.addWidget((Widget)slot);
            }
            SlotWidget slot = new SlotWidget((IItemHandlerModifiable)group.getItemStackHandler(), 0, 0, 20);
            WidgetGroup itemUI = new WidgetGroup(40, 20, 100, 100);
            Runnable changeListener = () -> {
                if (slot.getLastItem().is(slot.getItem().getItem())) {
                    return;
                }
                itemUI.clearAllWidgets();
                Item patt15492$temp = slot.getItem().getItem();
                if (patt15492$temp instanceof IComponentItem) {
                    IComponentItem item = (IComponentItem)patt15492$temp;
                    for (IItemComponent component : item.getComponents()) {
                        if (!(component instanceof IMonitorModuleItem)) continue;
                        IMonitorModuleItem module = (IMonitorModuleItem)component;
                        itemUI.addWidget(module.createUIWidget(slot.getItem(), this, (MonitorGroup)group));
                    }
                }
            };
            slot.setChangeListener(changeListener);
            changeListener.run();
            groupConfig.addWidget((Widget)itemUI);
            groupConfig.addWidget((Widget)slot);
            main.setVisible(false);
            groupConfig.setVisible(true);
        };
        builder.addWidget((Widget)groupConfig);
        DraggableScrollableWidgetGroup groupList = new DraggableScrollableWidgetGroup(-100, 50, 70, 80);
        ArrayList imageButtons = new ArrayList();
        HashMap<BlockPos, Runnable> rightClickCallbacks = new HashMap<BlockPos, Runnable>();
        int[] dataSlot = new int[]{1, 9};
        IntInputWidget dataSlotInput = new IntInputWidget(120, 20, 60, -20, () -> dataSlot[0], n -> {
            dataSlot[0] = Mth.clamp((int)n, (int)1, (int)dataSlot[1]);
        });
        dataSlotInput.setVisible(false);
        builder.addWidget((Widget)dataSlotInput);
        Consumer<MonitorGroup> addGroupToList = group -> {
            ButtonWidget label = new ButtonWidget(20, groupList.widgets.size() * 15 + 5, 60, 10, null);
            TextTexture text = new TextTexture(group.getName());
            text.setType(TextTexture.TextType.LEFT);
            label.setButtonTexture(new IGuiTexture[]{text});
            label.setOnPressCallback(click -> {
                group.getRelativePositions().forEach(pos -> {
                    BlockPos rel = this.toRelative((BlockPos)pos);
                    if (imageButtons.size() - 1 < rel.getY()) {
                        return;
                    }
                    if (((List)imageButtons.get(rel.getY())).size() - 1 < rel.getX()) {
                        return;
                    }
                    ((Consumer)((List)imageButtons.get(rel.getY())).get(rel.getX())).accept(null);
                });
                if (group.getTargetRaw() != null) {
                    rightClickCallbacks.getOrDefault(group.getTargetRaw(), () -> {}).run();
                }
            });
            groupList.addWidget((Widget)label);
            ButtonWidget configButton = new ButtonWidget(0, label.getSelfPositionY() - 3, 16, 16, (IGuiTexture)GuiTextures.IO_CONFIG_COVER_SETTINGS, click -> {
                if (configGroup.get(0) == null) {
                    openGroupConfig.accept((MonitorGroup)group);
                } else {
                    openGroupConfig.accept(null);
                }
            });
            groupList.addWidget((Widget)configButton);
        };
        this.monitorGroups.forEach(addGroupToList);
        builder.addWidget((Widget)groupList);
        main.addWidget((Widget)options);
        ButtonWidget removeFromGroupButton = new ButtonWidget(0, 0, 60, 20, null);
        removeFromGroupButton.setButtonTexture(new IGuiTexture[]{new TextTexture("gtceu.central_monitor.gui.remove_from_group")});
        removeFromGroupButton.setVisible(false);
        ButtonWidget setTargetButton = new ButtonWidget(0, 15, 60, 20, null);
        setTargetButton.setButtonTexture(new IGuiTexture[]{new TextTexture("gtceu.central_monitor.gui.set_target")});
        setTargetButton.setVisible(false);
        ButtonWidget createGroupButton = new ButtonWidget(0, 0, 60, 20, null);
        createGroupButton.setOnPressCallback(click -> {
            MonitorGroup group = new MonitorGroup(Component.translatable((String)"gtceu.gui.central_monitor.group_default_name", (Object[])new Object[]{this.monitorGroups.size() + 1}).getString());
            for (IMonitorComponent component : this.selectedComponents) {
                if (this.isInAnyGroup(component)) {
                    return;
                }
                group.add(component.getPos());
            }
            this.monitorGroups.add(group);
            addGroupToList.accept(group);
            createGroupButton.setVisible(false);
            removeFromGroupButton.setVisible(true);
            Iterator<IMonitorComponent> it = this.selectedComponents.iterator();
            while (it.hasNext()) {
                IMonitorComponent c = it.next();
                BlockPos rel = this.toRelative(c.getPos());
                ((Consumer)((List)imageButtons.get(rel.getY())).get(rel.getX())).accept(it);
            }
            if (!this.selectedTargets.isEmpty()) {
                rightClickCallbacks.getOrDefault(this.selectedTargets.get(0).getPos(), () -> {}).run();
            }
        });
        setTargetButton.setOnPressCallback(click -> {
            MonitorGroup group = null;
            for (MonitorGroup group2 : this.monitorGroups) {
                for (IMonitorComponent component : this.selectedComponents) {
                    if (!group2.contains(component.getPos())) continue;
                    group = group2;
                    break;
                }
                if (group == null) continue;
                break;
            }
            if (group == null) {
                return;
            }
            if (this.selectedTargets.isEmpty()) {
                group.setTarget(null);
            } else {
                group.setTarget(this.selectedTargets.get(0).getPos());
                group.setDataSlot(dataSlot[0] - 1);
            }
        });
        removeFromGroupButton.setOnPressCallback(click -> {
            for (MonitorGroup group : this.monitorGroups) {
                for (IMonitorComponent component : this.selectedComponents) {
                    group.remove(component.getPos());
                }
            }
            Iterator<MonitorGroup> itg = this.monitorGroups.iterator();
            while (itg.hasNext()) {
                MonitorGroup group;
                group = itg.next();
                if (!group.isEmpty()) continue;
                this.clearInventory((IItemHandlerModifiable)group.getItemStackHandler());
                this.clearInventory((IItemHandlerModifiable)group.getPlaceholderSlotsHandler());
                itg.remove();
            }
            groupList.clearAllWidgets();
            this.monitorGroups.forEach(addGroupToList);
            removeFromGroupButton.setVisible(false);
            createGroupButton.setVisible(true);
            Iterator<IMonitorComponent> it = this.selectedComponents.iterator();
            while (it.hasNext()) {
                IMonitorComponent c = it.next();
                BlockPos rel = this.toRelative(c.getPos());
                if (imageButtons.size() - 1 < rel.getY() || ((List)imageButtons.get(rel.getY())).size() - 1 < rel.getX()) continue;
                ((Consumer)((List)imageButtons.get(rel.getY())).get(rel.getX())).accept(it);
            }
            if (!this.selectedTargets.isEmpty()) {
                rightClickCallbacks.getOrDefault(this.selectedTargets.get(0).getPos(), () -> {}).run();
            }
        });
        createGroupButton.setButtonTexture(new IGuiTexture[]{new TextTexture("gtceu.central_monitor.gui.create_group")});
        createGroupButton.setVisible(false);
        options.addWidget((Widget)removeFromGroupButton);
        options.addWidget((Widget)createGroupButton);
        options.addWidget((Widget)setTargetButton);
        int startX = 20;
        int startY = 30;
        for (int row = 0; row <= this.downDist + this.upDist; ++row) {
            imageButtons.add(new ArrayList());
            for (int col = 0; col <= this.leftDist + this.rightDist; ++col) {
                IGuiTexture texture = this.getComponentTexture(row, col);
                GuiTextureGroup textures = new GuiTextureGroup(new IGuiTexture[]{texture, new ColorBorderTexture(2, 0xFFFFFF)});
                IMonitorComponent component = this.getComponent(row, col);
                if (component == null) {
                    ((List)GTUtil.getLast(imageButtons)).add(it -> {});
                    continue;
                }
                ButtonWidget img = new ButtonWidget(startX + 16 * col, startY + 16 * row, 16, 16, (IGuiTexture)textures, null);
                Consumer<Iterator> callback = it -> {
                    if (!component.isMonitor()) {
                        return;
                    }
                    if (this.selectedComponents.contains(component)) {
                        if (it == null) {
                            this.selectedComponents.remove(component);
                        } else {
                            it.remove();
                        }
                        if (!this.selectedTargets.isEmpty() && this.selectedTargets.get(0) == component) {
                            ColorRectTexture rect = new ColorRectTexture(Color.BLUE);
                            textures.setTextures(new IGuiTexture[]{rect, texture});
                        } else {
                            textures.setTextures(new IGuiTexture[]{texture});
                        }
                        createGroupButton.setVisible(this.selectedComponents.stream().noneMatch(this::isInAnyGroup));
                        removeFromGroupButton.setVisible(this.selectedComponents.stream().allMatch(this::isInAnyGroup));
                        setTargetButton.setVisible(removeFromGroupButton.isVisible());
                        if (this.selectedComponents.isEmpty()) {
                            createGroupButton.setVisible(false);
                            removeFromGroupButton.setVisible(false);
                            setTargetButton.setVisible(false);
                        }
                    } else {
                        boolean inAnyGroup = this.isInAnyGroup(component);
                        if (this.selectedComponents.isEmpty() && !inAnyGroup) {
                            createGroupButton.setVisible(true);
                        }
                        if (inAnyGroup) {
                            createGroupButton.setVisible(false);
                        }
                        if (this.selectedComponents.isEmpty() && inAnyGroup) {
                            removeFromGroupButton.setVisible(true);
                            setTargetButton.setVisible(true);
                        }
                        if (!inAnyGroup) {
                            removeFromGroupButton.setVisible(false);
                            setTargetButton.setVisible(false);
                        }
                        this.selectedComponents.add(component);
                        ColorRectTexture rect = new ColorRectTexture(this.selectedTargets.isEmpty() || this.selectedTargets.get(0) != component ? Color.RED : Color.PINK);
                        textures.setTextures(new IGuiTexture[]{rect, texture});
                    }
                    if (this.isInAnyGroup(component)) {
                        this.monitorGroups.forEach(group -> {
                            if (group.contains(component.getPos())) {
                                img.setHoverTooltips(new Component[]{Component.translatable((String)"gtceu.gui.central_monitor.group", (Object[])new Object[]{group.getName()})});
                            }
                        });
                    } else {
                        img.setHoverTooltips(new Component[]{Component.translatable((String)"gtceu.gui.central_monitor.group", (Object[])new Object[]{Component.translatable((String)"gtceu.gui.central_monitor.none")})});
                    }
                };
                Runnable rightClickCallback = () -> {
                    if (!this.selectedTargets.isEmpty()) {
                        if (this.selectedTargets.get(0).getPos() == component.getPos()) {
                            this.selectedTargets.clear();
                            if (this.selectedComponents.contains(component)) {
                                ColorRectTexture rect = new ColorRectTexture(Color.RED);
                                textures.setTextures(new IGuiTexture[]{rect, texture});
                            } else {
                                textures.setTextures(new IGuiTexture[]{texture});
                            }
                            dataSlotInput.setVisible(false);
                            return;
                        }
                        try {
                            ((Runnable)rightClickCallbacks.get(this.selectedTargets.get(0).getPos())).run();
                        }
                        catch (StackOverflowError e) {
                            GTCEu.LOGGER.error("Stack overflow when right-clicking monitor component {} at {} (selectedTarget is {} at {})", (Object)component, (Object)component.getPos(), (Object)this.selectedTargets.get(0), (Object)this.selectedTargets.get(0).getPos());
                        }
                    }
                    this.selectedTargets.add(component);
                    ColorRectTexture rect = this.selectedComponents.contains(component) ? new ColorRectTexture(Color.PINK) : new ColorRectTexture(Color.BLUE);
                    textures.setTextures(new IGuiTexture[]{rect, texture});
                    if (component.getDataItems() != null) {
                        IItemHandler dataItems = component.getDataItems();
                        MonitorGroup selectedGroup = null;
                        block2: for (MonitorGroup group : this.monitorGroups) {
                            for (IMonitorComponent c : this.selectedComponents) {
                                if (!group.contains(c.getPos())) continue;
                                if (selectedGroup == null || selectedGroup == group) {
                                    selectedGroup = group;
                                    continue;
                                }
                                selectedGroup = null;
                                continue block2;
                            }
                        }
                        if (selectedGroup != null) {
                            dataSlot[0] = selectedGroup.getDataSlot() + 1;
                        }
                        dataSlot[1] = dataItems.getSlots();
                        dataSlotInput.setVisible(true);
                    }
                };
                if (this.isInAnyGroup(component)) {
                    this.monitorGroups.forEach(group -> {
                        if (group.contains(component.getPos())) {
                            img.setHoverTooltips(new Component[]{Component.translatable((String)"gtceu.gui.central_monitor.group", (Object[])new Object[]{group.getName()})});
                        }
                    });
                } else {
                    img.setHoverTooltips(new Component[]{Component.translatable((String)"gtceu.gui.central_monitor.group", (Object[])new Object[]{Component.translatable((String)"gtceu.gui.central_monitor.none")})});
                }
                img.setOnPressCallback(click -> {
                    if (click.button == 0) {
                        callback.accept(null);
                    } else if (click.button == 1) {
                        rightClickCallback.run();
                    }
                });
                componentSelection.addWidget((Widget)img);
                ((List)GTUtil.getLast(imageButtons)).add(callback);
                rightClickCallbacks.put(component.getPos(), rightClickCallback);
            }
        }
        builder.addWidget((Widget)main);
        return builder;
    }

    @Override
    public IGuiTexture getComponentIcon() {
        return ResourceTexture.fromSpirit((ResourceLocation)GTCEu.id("block/multiblock/network_switch/overlay_front_active"));
    }

    @Override
    @NotNull
    public List<Component> getDebugInfo(Player player, int logLevel, PortableScannerBehavior.DisplayMode mode) {
        return List.of(Component.translatable((String)"gtceu.central_monitor.size", (Object[])new Object[]{this.leftDist, this.rightDist, this.upDist, this.downDist}));
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        return List.of(Component.translatable((String)"gtceu.central_monitor.size", (Object[])new Object[]{this.leftDist, this.rightDist, this.upDist, this.downDist}));
    }

    @Override
    public void onMachineRemoved() {
        for (MonitorGroup group : this.monitorGroups) {
            this.clearInventory((IItemHandlerModifiable)group.getItemStackHandler());
            this.clearInventory((IItemHandlerModifiable)group.getPlaceholderSlotsHandler());
        }
    }

    @Generated
    public int getLeftDist() {
        return this.leftDist;
    }

    @Generated
    public int getRightDist() {
        return this.rightDist;
    }

    @Generated
    public int getUpDist() {
        return this.upDist;
    }

    @Generated
    public int getDownDist() {
        return this.downDist;
    }

    @Override
    @Generated
    public List<MonitorGroup> getMonitorGroups() {
        return this.monitorGroups;
    }
}

