/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMufflerMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.machine.electric.HullMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.BedrockOreMinerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FluidDrillMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.LargeMinerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeCombustionEngineMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeTurbineMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DiodePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.CokeOvenMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveBlastFurnaceMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitivePumpMachine;
import com.gregtechceu.gtceu.common.machine.trait.CleanroomLogic;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CleanroomMachine
extends WorkableElectricMultiblockMachine
implements ICleanroomProvider,
IDisplayUIMachine,
IDataInfoProvider {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CleanroomMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    public static final int CLEAN_AMOUNT_THRESHOLD = 95;
    public static final int MIN_CLEAN_AMOUNT = 0;
    public static final int MIN_RADIUS = 2;
    public static final int MIN_DEPTH = 4;
    @Persisted
    private int lDist = 0;
    @Persisted
    private int rDist = 0;
    @Persisted
    private int bDist = 0;
    @Persisted
    private int fDist = 0;
    @Persisted
    private int hDist = 0;
    @Nullable
    private CleanroomType cleanroomType = null;
    @Persisted
    private int cleanAmount;
    @Nullable
    private EnergyContainerList inputEnergyContainers;
    @Nullable
    private Collection<ICleanroomReceiver> cleanroomReceivers;

    public CleanroomMachine(IMachineBlockEntity metaTileEntityId) {
        super(metaTileEntityId, new Object[0]);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new CleanroomLogic(this);
    }

    @Override
    @NotNull
    public CleanroomLogic getRecipeLogic() {
        return (CleanroomLogic)super.getRecipeLogic();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.initializeAbilities();
        IFilterType filterType = (IFilterType)this.getMultiblockState().getMatchContext().get("FilterType");
        this.cleanroomType = filterType != null ? filterType.getCleanroomType() : CleanroomType.CLEANROOM;
        if (this.cleanroomReceivers != null) {
            this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(null));
            this.cleanroomReceivers = null;
        }
        Set receivers = this.getMultiblockState().getMatchContext().getOrCreate("cleanroomReceiver", Sets::newHashSet);
        this.cleanroomReceivers = ImmutableSet.copyOf((Collection)receivers);
        this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(this));
        int area = (this.lDist + this.rDist + 1) * (this.bDist + this.fDist + 1);
        double duration = Math.pow(area, 0.8) * (double)(this.hDist + 1);
        this.getRecipeLogic().setDuration(Math.max(100, (int)duration));
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.inputEnergyContainers = null;
        this.cleanAmount = 0;
        if (this.cleanroomReceivers != null) {
            this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(null));
            this.cleanroomReceivers = null;
        }
    }

    @Override
    public boolean shouldAddPartToController(IMultiPart part) {
        Collection<BlockPos> cache = this.getMultiblockState().getCache();
        for (Direction side : GTUtil.DIRECTIONS) {
            if (cache.contains(part.self().getPos().relative(side))) continue;
            return true;
        }
        return false;
    }

    protected void initializeAbilities() {
        ArrayList energyContainers = new ArrayList();
        Long2ObjectMap ioMap = this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io;
            if (CleanroomMachine.isPartIgnored(part) || (io = (IO)ioMap.getOrDefault(part.self().getPos().asLong(), (Object)IO.BOTH)) == IO.NONE || io == IO.OUT) continue;
            List<RecipeHandlerList> handlerLists = part.getRecipeHandlers();
            for (RecipeHandlerList handlerList : handlerLists) {
                if (!handlerList.isValid(io)) continue;
                handlerList.getCapability(EURecipeCapability.CAP).stream().filter(IEnergyContainer.class::isInstance).map(IEnergyContainer.class::cast).forEach(energyContainers::add);
            }
            if (!(part instanceof IMaintenanceMachine)) continue;
            IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)part;
            this.getRecipeLogic().setMaintenanceMachine(maintenanceMachine);
        }
        this.inputEnergyContainers = new EnergyContainerList(energyContainers);
        this.getRecipeLogic().setEnergyContainer(this.inputEnergyContainers);
        this.tier = Math.min(14, GTUtil.getFloorTierByVoltage(this.getMaxVoltage()));
    }

    private static boolean isPartIgnored(IMultiPart part) {
        if (part instanceof DiodePartMachine) {
            return true;
        }
        return part instanceof HullMachine;
    }

    public void updateStructureDimensions() {
        int i;
        Level world = this.getLevel();
        if (world == null) {
            return;
        }
        Direction front = this.getFrontFacing();
        Direction back = front.getOpposite();
        Direction left = front.getCounterClockWise();
        Direction right = left.getOpposite();
        BlockPos.MutableBlockPos lPos = this.getPos().mutable();
        BlockPos.MutableBlockPos rPos = this.getPos().mutable();
        BlockPos.MutableBlockPos fPos = this.getPos().mutable();
        BlockPos.MutableBlockPos bPos = this.getPos().mutable();
        BlockPos.MutableBlockPos hPos = this.getPos().mutable();
        int lDist = 0;
        int rDist = 0;
        int bDist = 0;
        int fDist = 0;
        int hDist = 0;
        for (i = 1; i < 8; ++i) {
            if (lDist == 0 && this.isBlockEdge(world, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && this.isBlockEdge(world, rPos, right)) {
                rDist = i;
            }
            if (bDist == 0 && this.isBlockEdge(world, bPos, back)) {
                bDist = i;
            }
            if (fDist == 0 && this.isBlockEdge(world, fPos, front)) {
                fDist = i;
            }
            if (lDist != 0 && rDist != 0 && bDist != 0 && fDist != 0) break;
        }
        for (i = 1; i < 15; ++i) {
            if (this.isBlockFloor(world, hPos, Direction.DOWN)) {
                hDist = i;
            }
            if (hDist != 0) break;
        }
        if (Math.abs(lDist - rDist) > 1 || Math.abs(bDist - fDist) > 1) {
            this.isFormed = false;
            return;
        }
        if (lDist < 2 || rDist < 2 || bDist < 2 || fDist < 2 || hDist < 4) {
            this.isFormed = false;
            return;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.bDist = bDist;
        this.fDist = fDist;
        this.hDist = hDist;
    }

    public boolean isBlockEdge(@NotNull Level world, @NotNull BlockPos.MutableBlockPos pos, @NotNull Direction direction) {
        BlockState state = world.getBlockState((BlockPos)pos.move(direction));
        return state == this.getCasingState() || state == this.getGlassState();
    }

    public boolean isBlockFloor(@NotNull Level world, @NotNull BlockPos.MutableBlockPos pos, @NotNull Direction direction) {
        BlockState state = world.getBlockState((BlockPos)pos.move(direction));
        return state == this.getCasingState() || state == this.getGlassState() || state.is(CustomTags.CLEANROOM_FLOORS);
    }

    @Override
    @NotNull
    public BlockPattern getPattern() {
        int j;
        int i;
        if (this.getLevel() != null) {
            this.updateStructureDimensions();
        }
        if (this.lDist < 2) {
            this.lDist = 2;
        }
        if (this.rDist < 2) {
            this.rDist = 2;
        }
        if (this.bDist < 2) {
            this.bDist = 2;
        }
        if (this.fDist < 2) {
            this.fDist = 2;
        }
        if (this.hDist < 4) {
            this.hDist = 4;
        }
        if (this.getFrontFacing() == Direction.EAST || this.getFrontFacing() == Direction.WEST) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder[] floorLayer = new StringBuilder[this.fDist + this.bDist + 1];
        ArrayList<StringBuilder[]> wallLayers = new ArrayList<StringBuilder[]>();
        StringBuilder[] ceilingLayer = new StringBuilder[this.fDist + this.bDist + 1];
        for (i = 0; i < floorLayer.length; ++i) {
            floorLayer[i] = new StringBuilder(this.lDist + this.rDist + 1);
            ceilingLayer[i] = new StringBuilder(this.lDist + this.rDist + 1);
        }
        for (i = 0; i < this.hDist - 1; ++i) {
            wallLayers.add(new StringBuilder[this.fDist + this.bDist + 1]);
            for (j = 0; j < this.fDist + this.bDist + 1; ++j) {
                StringBuilder s;
                ((StringBuilder[])wallLayers.get((int)i))[j] = s = new StringBuilder(this.lDist + this.rDist + 1);
            }
        }
        for (i = 0; i < this.lDist + this.rDist + 1; ++i) {
            for (j = 0; j < this.fDist + this.bDist + 1; ++j) {
                int k;
                if (i == 0 || i == this.lDist + this.rDist || j == 0 || j == this.fDist + this.bDist) {
                    floorLayer[j].append('A');
                    for (k = 0; k < this.hDist - 1; ++k) {
                        ((StringBuilder[])wallLayers.get(k))[j].append('W');
                    }
                    ceilingLayer[j].append('D');
                    continue;
                }
                if (i == this.lDist && j == this.fDist) {
                    floorLayer[j].append('K');
                } else {
                    floorLayer[j].append('E');
                }
                for (k = 0; k < this.hDist - 1; ++k) {
                    ((StringBuilder[])wallLayers.get(k))[j].append(' ');
                }
                if (i == this.lDist && j == this.fDist) {
                    ceilingLayer[j].append('C');
                    continue;
                }
                ceilingLayer[j].append('F');
            }
        }
        String[] f = new String[this.bDist + this.fDist + 1];
        for (int i2 = 0; i2 < floorLayer.length; ++i2) {
            f[i2] = floorLayer[i2].toString();
        }
        String[] m = new String[this.bDist + this.fDist + 1];
        for (int i3 = 0; i3 < ((StringBuilder[])wallLayers.get(0)).length; ++i3) {
            m[i3] = ((StringBuilder[])wallLayers.get(0))[i3].toString();
        }
        String[] c = new String[this.bDist + this.fDist + 1];
        for (int i4 = 0; i4 < ceilingLayer.length; ++i4) {
            c[i4] = ceilingLayer[i4].toString();
        }
        int area = (this.lDist + this.rDist + 1) * (this.bDist + this.fDist + 1);
        TraceabilityPredicate wallPredicate = Predicates.states(this.getCasingState(), this.getGlassState());
        TraceabilityPredicate basePredicate = Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(2).or(Predicates.blocks(GTMachines.MAINTENANCE_HATCH.get(), GTMachines.AUTO_MAINTENANCE_HATCH.get()).setMinGlobalLimited(ConfigHolder.INSTANCE.machines.enableMaintenance ? 1 : 0).setMaxGlobalLimited(1)).or(Predicates.abilities(PartAbility.PASSTHROUGH_HATCH).setMaxGlobalLimited(area / 4));
        return FactoryBlockPattern.start(RelativeDirection.LEFT, RelativeDirection.FRONT, RelativeDirection.UP).aisle(f).aisle(m).setRepeatable(wallLayers.size()).aisle(c).where('C', Predicates.controller(Predicates.blocks(this.getDefinition().get()))).where('F', Predicates.cleanroomFilters()).where('D', Predicates.states(this.getCasingState())).where(' ', this.innerPredicate()).where('E', wallPredicate.or(basePredicate).or(this.getValidFloorBlocks().setMaxGlobalLimited(4))).where('K', wallPredicate.or(this.getValidFloorBlocks())).where('W', wallPredicate.or(basePredicate).or(CleanroomMachine.doorPredicate().setMaxGlobalLimited(8))).where('A', wallPredicate.or(basePredicate)).build();
    }

    @NotNull
    protected BlockState getCasingState() {
        return GTBlocks.PLASTCRETE.getDefaultState();
    }

    @NotNull
    protected BlockState getGlassState() {
        return GTBlocks.CLEANROOM_GLASS.getDefaultState();
    }

    @NotNull
    protected static TraceabilityPredicate doorPredicate() {
        return Predicates.custom(blockWorldState -> blockWorldState.getBlockState().is(CustomTags.CLEANROOM_DOORS), () -> new BlockInfo[]{new BlockInfo(Blocks.IRON_DOOR.defaultBlockState()), new BlockInfo((BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))});
    }

    private TraceabilityPredicate getValidFloorBlocks() {
        return Predicates.blockTag(CustomTags.CLEANROOM_FLOORS);
    }

    @NotNull
    protected TraceabilityPredicate innerPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            ICleanroomReceiver receiver;
            IMachineBlockEntity machineBlockEntity;
            MetaMachine machine;
            Set receivers = blockWorldState.getMatchContext().getOrCreate("cleanroomReceiver", Sets::newHashSet);
            BlockEntity blockEntity = blockWorldState.getTileEntity();
            if (blockEntity instanceof IMachineBlockEntity && this.isMachineBanned(machine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine())) {
                return false;
            }
            if (blockEntity != null && (receiver = GTCapabilityHelper.getCleanroomReceiver(blockWorldState.getWorld(), blockWorldState.getPos(), null)) != null) {
                receivers.add(receiver);
            }
            return true;
        }, null){

            @Override
            public boolean isAny() {
                return true;
            }

            @Override
            public boolean addCache() {
                return true;
            }
        };
    }

    protected boolean isMachineBanned(MetaMachine machine) {
        if (machine instanceof ICleanroomProvider) {
            return true;
        }
        if (machine instanceof IMufflerMachine) {
            return true;
        }
        if (machine instanceof SimpleGeneratorMachine) {
            return true;
        }
        if (machine instanceof LargeCombustionEngineMachine) {
            return true;
        }
        if (machine instanceof LargeTurbineMachine) {
            return true;
        }
        if (machine instanceof LargeMinerMachine) {
            return true;
        }
        if (machine instanceof FluidDrillMachine) {
            return true;
        }
        if (machine instanceof BedrockOreMinerMachine) {
            return true;
        }
        if (machine instanceof CokeOvenMachine) {
            return true;
        }
        if (machine instanceof PrimitiveBlastFurnaceMachine) {
            return true;
        }
        return machine instanceof PrimitivePumpMachine;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        if (this.isFormed()) {
            long maxVoltage = this.getMaxVoltage();
            if (maxVoltage > 0L) {
                String voltageName = GTValues.VNF[GTUtil.getFloorTierByVoltage(maxVoltage)];
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
            }
            if (this.cleanroomType != null) {
                textList.add((Component)Component.translatable((String)this.cleanroomType.getTranslationKey()));
            }
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.running"));
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                double maxInSec = (float)this.recipeLogic.getDuration() / 20.0f;
                double currentInSec = (float)this.recipeLogic.getProgress() / 20.0f;
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.progress", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)currentInSec)), String.format("%.2f", Float.valueOf((float)maxInSec)), currentProgress}));
            } else {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.waiting").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            }
            if (this.isClean()) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.cleanroom.clean_state"));
            } else {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.cleanroom.dirty_state"));
            }
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.cleanroom.clean_amount", (Object[])new Object[]{this.cleanAmount}));
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.dimensions.0"));
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.dimensions.1", (Object[])new Object[]{this.lDist + this.rDist + 1, this.hDist + 1, this.fDist + this.bDist + 1}));
        } else {
            MutableComponent tooltip = Component.translatable((String)"gtceu.multiblock.invalid_structure.tooltip").withStyle(ChatFormatting.GRAY);
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.invalid_structure").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tooltip))));
        }
    }

    @Override
    public Set<CleanroomType> getTypes() {
        return this.cleanroomType == null ? Set.of() : Set.of(this.cleanroomType);
    }

    public void adjustCleanAmount(int amount) {
        this.cleanAmount = Mth.clamp((int)(this.cleanAmount + amount), (int)0, (int)100);
    }

    @Override
    public boolean isClean() {
        return this.cleanAmount >= 95;
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_MACHINE_INFO) {
            return Collections.singletonList(Component.translatable((String)(this.isClean() ? "gtceu.multiblock.cleanroom.clean_state" : "gtceu.multiblock.cleanroom.dirty_state")));
        }
        return new ArrayList<Component>();
    }

    @Override
    public long getMaxVoltage() {
        if (this.inputEnergyContainers == null) {
            return 1L;
        }
        return this.inputEnergyContainers.getInputVoltage();
    }

    @Override
    public boolean isWorkingEnabled() {
        return true;
    }

    @Override
    public void setWorkingEnabled(boolean ignored) {
    }

    @Nullable
    @Generated
    public EnergyContainerList getInputEnergyContainers() {
        return this.inputEnergyContainers;
    }

    @Nullable
    @Generated
    public Collection<ICleanroomReceiver> getCleanroomReceivers() {
        return this.cleanroomReceivers;
    }
}

