/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.DummyCleanroom;
import com.gregtechceu.gtceu.common.machine.multiblock.part.AutoMaintenanceHatchPartMachine;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CleaningMaintenanceHatchPartMachine
extends AutoMaintenanceHatchPartMachine {
    private final ICleanroomProvider DUMMY_CLEANROOM;
    private final CleanroomType cleanroomType;

    public CleaningMaintenanceHatchPartMachine(IMachineBlockEntity holder, CleanroomType cleanroomType) {
        super(holder);
        this.cleanroomType = cleanroomType;
        this.DUMMY_CLEANROOM = DummyCleanroom.createForTypes(Collections.singletonList(cleanroomType));
    }

    @Override
    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)((Object)controller);
            receiver.setCleanroom(this.DUMMY_CLEANROOM);
        }
    }

    @Override
    public void removedFromController(IMultiController controller) {
        ICleanroomReceiver receiver;
        super.removedFromController(controller);
        if (controller instanceof ICleanroomReceiver && (receiver = (ICleanroomReceiver)((Object)controller)).getCleanroom() == this.DUMMY_CLEANROOM) {
            receiver.setCleanroom(null);
        }
    }

    @Override
    public int getTier() {
        return this.cleanroomType == CleanroomType.CLEANROOM ? 8 : 9;
    }

    @Generated
    public CleanroomType getCleanroomType() {
        return this.cleanroomType;
    }
}

