/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DiodePartMachine
extends TieredIOPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DiodePartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    public static final EnumProperty<AmpMode> AMP_MODE_PROPERTY = GTMachineModelProperties.DIODE_AMP_MODE;
    public static int MAX_AMPS = 16;
    @Persisted
    protected NotifiableEnergyContainer energyContainer;
    @DescSynced
    @Persisted(key="amp_mode")
    @UpdateListener(methodName="onAmpUpdated")
    private int amps;

    public DiodePartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier, IO.BOTH);
        long tierVoltage = GTValues.V[this.getTier()];
        this.amps = 1;
        this.energyContainer = new NotifiableEnergyContainer(this, tierVoltage * (long)MAX_AMPS * 2L, tierVoltage, MAX_AMPS, tierVoltage, MAX_AMPS);
        this.reinitializeEnergyContainer();
    }

    private void cycleAmpMode() {
        int n = this.amps = this.amps == this.getMaxAmperage() ? 1 : this.amps << 1;
        if (!this.getLevel().isClientSide) {
            this.reinitializeEnergyContainer();
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    protected int getMaxAmperage() {
        return MAX_AMPS;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.reinitializeEnergyContainer();
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer.resetBasicInfo(tierVoltage * (long)MAX_AMPS * 2L, tierVoltage, this.amps, tierVoltage, this.amps);
        this.energyContainer.setSideInputCondition(s -> s != this.getFrontFacing());
        this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
    }

    @Override
    public int tintColor(int index) {
        if (index == 2 || index == 3) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        return true;
    }

    @Override
    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        this.cycleAmpMode();
        if (!this.isRemote()) {
            this.scheduleRenderUpdate();
            playerIn.sendSystemMessage((Component)Component.translatable((String)"gtceu.machine.diode.message", (Object[])new Object[]{this.amps}));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onAmpUpdated(int newValue, int oldValue) {
        this.scheduleRenderUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        if (!this.isRemote()) {
            this.setRenderState((MachineRenderState)((Object)this.getRenderState().setValue((Property)GTMachineModelProperties.DIODE_AMP_MODE, (Comparable)((Object)AmpMode.getByValue(this.amps)))));
            super.scheduleRenderUpdate();
        }
    }

    @Generated
    public int getAmps() {
        return this.amps;
    }

    public static enum AmpMode implements StringRepresentable
    {
        MODE_1A("1a", 1),
        MODE_2A("2a", 2),
        MODE_4A("4a", 4),
        MODE_8A("8a", 8),
        MODE_16A("16a", 16);

        public static final AmpMode[] VALUES;
        private final String serializedName;
        private final int ampValue;

        private AmpMode(String serializedName, int ampValue) {
            this.serializedName = serializedName;
            this.ampValue = ampValue;
        }

        public AmpMode cycle() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public static AmpMode getByValue(int amps) {
            return switch (amps) {
                case 2 -> MODE_2A;
                case 4 -> MODE_4A;
                case 8 -> MODE_8A;
                case 16 -> MODE_16A;
                default -> MODE_1A;
            };
        }

        @Generated
        public String getSerializedName() {
            return this.serializedName;
        }

        @Generated
        public int getAmpValue() {
            return this.ampValue;
        }

        static {
            VALUES = AmpMode.values();
        }
    }
}

