/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnergyHatchPartMachine
extends TieredIOPartMachine
implements IExplosionMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(EnergyHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableEnergyContainer energyContainer;
    protected TickableSubscription explosionSub;
    protected int amperage;

    public EnergyHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, int amperage, Object ... args) {
        super(holder, tier, io);
        this.amperage = amperage;
        this.energyContainer = this.createEnergyContainer(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        NotifiableEnergyContainer container;
        if (this.io == IO.OUT) {
            container = NotifiableEnergyContainer.emitterContainer(this, GTValues.V[this.tier] * 64L * (long)this.amperage, GTValues.V[this.tier], this.amperage);
            container.setSideOutputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
            container.setCapabilityValidator(s -> s == null || s == this.getFrontFacing());
        } else {
            container = NotifiableEnergyContainer.receiverContainer(this, GTValues.V[this.tier] * 16L * (long)this.amperage, GTValues.V[this.tier], this.amperage);
            container.setSideInputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
            container.setCapabilityValidator(s -> s == null || s == this.getFrontFacing());
        }
        return container;
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote() && ConfigHolder.INSTANCE.machines.shouldWeatherOrTerrainExplosion && this.shouldWeatherOrTerrainExplosion()) {
            this.explosionSub = this.subscribeServerTick(this::checkExplosion);
            this.checkExplosion();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.explosionSub != null) {
            this.explosionSub.unsubscribe();
            this.explosionSub = null;
        }
    }

    protected void checkExplosion() {
        if (this.energyContainer.getEnergyStored() > 0L) {
            this.checkWeatherOrTerrainExplosion(this.tier, this.tier * 10);
        }
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public static long getHatchEnergyCapacity(int tier, int amperage) {
        return GTValues.V[tier] * 64L * (long)amperage;
    }

    @Generated
    public int getAmperage() {
        return this.amperage;
    }
}

