/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IFluidRenderMulti;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveWorkableMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PrimitiveBlastFurnaceMachine
extends PrimitiveWorkableMachine
implements IUIMachine,
IFluidRenderMulti {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PrimitiveBlastFurnaceMachine.class, PrimitiveWorkableMachine.MANAGED_FIELD_HOLDER);
    private TickableSubscription hurtSubscription;
    @DescSynced
    @RequireRerender
    @NotNull
    private Set<BlockPos> fluidBlockOffsets = new HashSet<BlockPos>();

    public PrimitiveBlastFurnaceMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP), IO.IN, IO.NONE);
    }

    @Override
    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP), IO.OUT, IO.NONE);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.unsubscribe(this.hurtSubscription);
        this.hurtSubscription = null;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        IFluidRenderMulti.super.onStructureFormed();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        IFluidRenderMulti.super.onStructureInvalid();
    }

    @Override
    public void notifyStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        super.notifyStatusChanged(oldStatus, newStatus);
        if (newStatus == RecipeLogic.Status.WORKING) {
            this.hurtSubscription = this.subscribeServerTick(this.hurtSubscription, this::hurtEntitiesAndBreakSnow);
        } else if (oldStatus == RecipeLogic.Status.WORKING && this.hurtSubscription != null) {
            this.unsubscribe(this.hurtSubscription);
            this.hurtSubscription = null;
        }
    }

    @Override
    @NotNull
    public Set<BlockPos> saveOffsets() {
        return Collections.singleton(new BlockPos(this.getFrontFacing().getOpposite().getNormal()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.isFormed) {
            boolean shouldZ;
            BlockPos pos = this.getPos();
            Direction facing = this.getFrontFacing().getOpposite();
            float xPos = (float)facing.getStepX() * 0.76f + (float)pos.getX() + 0.5f;
            float yPos = (float)facing.getStepY() * 0.76f + (float)pos.getY() + 0.25f;
            float zPos = (float)facing.getStepZ() * 0.76f + (float)pos.getZ() + 0.5f;
            Direction up = RelativeDirection.UP.getRelative(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
            int sign = up.getAxisDirection().getStep();
            boolean shouldX = up.getAxis() == Direction.Axis.X;
            boolean shouldY = up.getAxis() == Direction.Axis.Y;
            boolean bl = shouldZ = up.getAxis() == Direction.Axis.Z;
            float speed = ((float)(shouldY ? facing.getStepY() : (shouldX ? facing.getStepX() : facing.getStepZ())) * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat()) * (float)sign;
            if (this.getOffsetTimer() % 20L == 0L) {
                this.getLevel().addParticle((ParticleOptions)ParticleTypes.LAVA, (double)xPos, (double)yPos, (double)zPos, shouldX ? (double)(speed * 2.0f) : 0.0, shouldY ? (double)(speed * 2.0f) : 0.0, shouldZ ? (double)(speed * 2.0f) : 0.0);
            }
            if (this.isActive()) {
                this.getLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)xPos, (double)yPos, (double)zPos, shouldX ? (double)speed : 0.0, shouldY ? (double)speed : 0.0, shouldZ ? (double)speed : 0.0);
            }
        }
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.PRIMITIVE_BACKGROUND}).widget((Widget)new LabelWidget(5, 5, this.getBlockState().getBlock().getDescriptionId())).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.importItems.storage, 0, 52, 20, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_INGOT_OVERLAY}))).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.importItems.storage, 1, 52, 38, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_DUST_OVERLAY}))).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.importItems.storage, 2, 52, 56, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY}))).widget((Widget)new ProgressWidget(this.recipeLogic::getProgressPercent, 77, 39, 20, 15, GuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR)).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.exportItems.storage, 0, 104, 38, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_INGOT_OVERLAY}))).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.exportItems.storage, 1, 122, 38, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_DUST_OVERLAY}))).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.exportItems.storage, 2, 140, 38, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_DUST_OVERLAY}))).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.getInventory(), (IGuiTexture)GuiTextures.PRIMITIVE_SLOT, 7, 84, true));
    }

    @Override
    public void animateTick(RandomSource random) {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.getX() + 0.5f;
            float z = (float)pos.getZ() + 0.5f;
            Direction facing = this.getFrontFacing();
            float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f;
            float y = (float)pos.getY() + GTValues.RNG.nextFloat() * 0.375f + 0.3f;
            if (facing.getAxis() == Direction.Axis.X) {
                x = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.getAxis() == Direction.Axis.Z) {
                z = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            if (ConfigHolder.INSTANCE.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                this.getLevel().playLocalSound((double)x, (double)y, (double)z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            this.getLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            this.getLevel().addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    private void hurtEntitiesAndBreakSnow() {
        BlockPos middlePos = this.self().getPos().offset(this.getFrontFacing().getOpposite().getNormal());
        this.getLevel().getEntities(null, new AABB(middlePos)).forEach(e -> e.hurt(e.damageSources().lava(), 3.0f));
        if (this.getOffsetTimer() % 10L == 0L) {
            BlockState state = this.getLevel().getBlockState(middlePos);
            GTUtil.tryBreakSnow(this.getLevel(), middlePos, state, true);
        }
    }

    @Override
    @NotNull
    @Generated
    public Set<BlockPos> getFluidBlockOffsets() {
        return this.fluidBlockOffsets;
    }

    @Override
    @Generated
    public void setFluidBlockOffsets(@NotNull Set<BlockPos> fluidBlockOffsets) {
        if (fluidBlockOffsets == null) {
            throw new NullPointerException("fluidBlockOffsets is marked non-null but is null");
        }
        this.fluidBlockOffsets = fluidBlockOffsets;
    }
}

