/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrateMachine
extends MetaMachine
implements IUIMachine,
IMachineLife,
IDropSaveMachine,
IInteractedMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CrateMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    public static final BooleanProperty TAPED_PROPERTY = GTMachineModelProperties.IS_TAPED;
    private final Material material;
    private final int inventorySize;
    @RequireRerender
    @Persisted
    @DescSynced
    private boolean isTaped;
    @Persisted
    public final NotifiableItemStackHandler inventory;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public CrateMachine(IMachineBlockEntity holder, Material material, int inventorySize) {
        super(holder);
        this.material = material;
        this.inventorySize = inventorySize;
        this.inventory = new NotifiableItemStackHandler(this, inventorySize, IO.BOTH);
    }

    public ModularUI createUI(Player entityPlayer) {
        int xOffset = this.inventorySize >= 90 ? 162 : 0;
        int yOverflow = xOffset > 0 ? 18 : 9;
        int yOffset = this.inventorySize > 3 * yOverflow ? (this.inventorySize - 3 * yOverflow - (this.inventorySize - 3 * yOverflow) % yOverflow) / yOverflow * 18 : 0;
        ModularUI modularUI = new ModularUI(176 + xOffset, 166 + yOffset, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(5, 5, this.getBlockState().getBlock().getDescriptionId())).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.getInventory(), (IGuiTexture)GuiTextures.SLOT, 7 + xOffset / 2, 82 + yOffset, true));
        int x = 0;
        int y = 0;
        for (int slot = 0; slot < this.inventorySize; ++slot) {
            modularUI.widget((Widget)new SlotWidget(this.inventory, slot, x * 18 + 7, y * 18 + 17).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            if (++x != yOverflow) continue;
            x = 0;
            ++y;
        }
        return modularUI;
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && !this.isTaped && (stack.is(GTItems.DUCT_TAPE.asItem()) || stack.is(GTItems.BASIC_TAPE.asItem()))) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.isTaped = true;
            this.setRenderState((MachineRenderState)((Object)this.getRenderState().setValue((Property)GTMachineModelProperties.IS_TAPED, Boolean.valueOf(this.isTaped))));
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    public void onMachinePlaced(@Nullable LivingEntity player, ItemStack stack) {
        IMachineLife.super.onMachinePlaced(player, stack);
        CompoundTag tag = stack.getTag();
        if (tag != null) {
            if (tag.contains("taped") && tag.getBoolean("taped")) {
                this.inventory.storage.deserializeNBT(tag.getCompound("inventory"));
            }
            this.setRenderState((MachineRenderState)((Object)this.getRenderState().setValue((Property)GTMachineModelProperties.IS_TAPED, Boolean.valueOf(this.isTaped))));
        }
    }

    @Override
    public void saveToItem(CompoundTag tag) {
        if (this.isTaped) {
            IDropSaveMachine.super.saveToItem(tag);
            tag.putBoolean("taped", this.isTaped);
            tag.put("inventory", (Tag)this.inventory.storage.serializeNBT());
        }
    }

    @Override
    public boolean saveBreak() {
        return this.isTaped;
    }

    @Override
    public void onMachineRemoved() {
        if (!this.isTaped) {
            this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
        }
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getInventorySize() {
        return this.inventorySize;
    }

    @Generated
    public boolean isTaped() {
        return this.isTaped;
    }
}

