/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectorWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ArrayUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CreativeEnergyContainerMachine
extends TieredMachine
implements ILaserContainer,
IUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeEnergyContainerMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private long voltage = 0L;
    @Persisted
    private int amps = 1;
    @Persisted
    private int setTier = 0;
    @Persisted
    private boolean active = false;
    @Persisted
    private boolean source = true;
    @Persisted
    private long energyIOPerSec = 0L;
    private long lastAverageEnergyIOPerTick = 0L;
    private long ampsReceived = 0L;
    private boolean doExplosion = false;

    public CreativeEnergyContainerMachine(IMachineBlockEntity holder) {
        super(holder, 14);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscribeServerTick(this::updateEnergyTick);
    }

    protected void updateEnergyTick() {
        if (this.getOffsetTimer() % 20L == 0L) {
            this.setIOSpeed(this.energyIOPerSec / 20L);
            this.energyIOPerSec = 0L;
            if (this.doExplosion) {
                this.getLevel().explode(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
                this.doExplosion = false;
            }
        }
        this.ampsReceived = 0L;
        if (!this.active || !this.source || this.voltage <= 0L || this.amps <= 0) {
            return;
        }
        int ampsUsed = 0;
        for (Direction facing : GTUtil.DIRECTIONS) {
            Direction opposite = facing.getOpposite();
            IEnergyContainer container = GTCapabilityHelper.getEnergyContainer(this.getLevel(), this.getPos().relative(facing), opposite);
            if (container == null) {
                container = GTCapabilityHelper.getLaser(this.getLevel(), this.getPos().relative(facing), opposite);
            }
            if (container != null && container.inputsEnergy(opposite) && container.getEnergyCanBeInserted() > 0L && (ampsUsed = (int)((long)ampsUsed + container.acceptEnergyFromNetwork(opposite, this.voltage, this.amps - ampsUsed))) >= this.amps) break;
        }
        this.energyIOPerSec += (long)ampsUsed * this.voltage;
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        if (this.source || !this.active || this.ampsReceived >= (long)this.amps) {
            return 0L;
        }
        if (voltage > this.voltage) {
            if (this.doExplosion) {
                return 0L;
            }
            this.doExplosion = true;
            return Math.min(amperage, this.getInputAmperage() - this.ampsReceived);
        }
        long amperesAccepted = Math.min(amperage, this.getInputAmperage() - this.ampsReceived);
        if (amperesAccepted > 0L) {
            this.ampsReceived += amperesAccepted;
            this.energyIOPerSec += amperesAccepted * voltage;
            return amperesAccepted;
        }
        return 0L;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return !this.source;
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return this.source;
    }

    @Override
    public long changeEnergy(long differenceAmount) {
        if (this.source || !this.active) {
            return 0L;
        }
        this.energyIOPerSec += differenceAmount;
        return differenceAmount;
    }

    @Override
    public long getEnergyStored() {
        return 69L;
    }

    @Override
    public long getEnergyCapacity() {
        return 420L;
    }

    @Override
    public long getInputAmperage() {
        return this.source ? 0L : (long)this.amps;
    }

    @Override
    public long getInputVoltage() {
        return this.source ? 0L : this.voltage;
    }

    @Override
    public long getOutputVoltage() {
        return this.source ? this.voltage : 0L;
    }

    @Override
    public long getOutputAmperage() {
        return this.source ? (long)this.amps : 0L;
    }

    public void setIOSpeed(long energyIOPerSec) {
        if (this.lastAverageEnergyIOPerTick != energyIOPerSec) {
            this.lastAverageEnergyIOPerTick = energyIOPerSec;
        }
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(7, 32, "gtceu.creative.energy.voltage")).widget((Widget)new TextFieldWidget(9, 47, 152, 16, () -> String.valueOf(this.voltage), value -> {
            this.voltage = Long.parseLong(value);
            this.setTier = GTUtil.getTierByVoltage(this.voltage);
        }).setNumbersOnly(0L, Long.MAX_VALUE)).widget((Widget)new LabelWidget(7, 74, "gtceu.creative.energy.amperage")).widget((Widget)new ButtonWidget(7, 87, 20, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("-")}), cd -> {
            this.amps = --this.amps == -1 ? 0 : this.amps;
        })).widget((Widget)new TextFieldWidget(31, 89, 114, 16, () -> String.valueOf(this.amps), value -> {
            this.amps = Integer.parseInt(value);
        }).setNumbersOnly(0, Integer.MAX_VALUE)).widget((Widget)new ButtonWidget(149, 87, 20, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("+")}), cd -> {
            if (this.amps < Integer.MAX_VALUE) {
                ++this.amps;
            }
        })).widget((Widget)new LabelWidget(7, 110, () -> "Average Energy I/O per tick: " + this.lastAverageEnergyIOPerTick)).widget((Widget)new SwitchWidget(7, 139, 77, 20, (clickData, value) -> {
            this.active = value;
        }).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})).setPressed(this.active)).widget((Widget)new SwitchWidget(85, 139, 77, 20, (clickData, value) -> {
            this.source = value;
            if (this.source) {
                this.voltage = 0L;
                this.amps = 0;
                this.setTier = 0;
            } else {
                this.voltage = GTValues.V[14];
                this.amps = Integer.MAX_VALUE;
                this.setTier = 14;
            }
        }).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.energy.sink")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.energy.source")})).setPressed(this.source)).widget((Widget)new SelectorWidget(7, 7, 50, 20, Arrays.stream(GTValues.VNF).toList(), -1).setOnChanged(tier -> {
            this.setTier = ArrayUtils.indexOf((Object[])GTValues.VNF, (Object)tier);
            this.voltage = GTValues.VEX[this.setTier];
        }).setSupplier(() -> GTValues.VNF[this.setTier]).setButtonBackground(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON}).setBackground((IGuiTexture)ColorPattern.BLACK.rectTexture()).setValue(GTValues.VNF[this.setTier]));
    }
}

