/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.miner;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.common.machine.trait.miner.MinerLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class LargeMinerLogic
extends MinerLogic {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeMinerLogic.class, MinerLogic.MANAGED_FIELD_HOLDER);
    private static final int CHUNK_LENGTH = 16;
    private static final LootItemFunction DROP_MULTIPLIER = ApplyBonusCount.addOreBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE).build();
    private int voltageTier;
    private int overclockAmount = 0;
    @Persisted
    private boolean isChunkMode;
    @Persisted
    private boolean isSilkTouchMode;

    public LargeMinerLogic(IRecipeLogicMachine machine, int fortune, int speed, int maximumRadius) {
        super(machine, fortune, speed, maximumRadius);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void initPos(@NotNull BlockPos pos, int currentRadius) {
        if (!this.isChunkMode) {
            super.initPos(pos, currentRadius);
        } else {
            Direction dir = super.getDir();
            ServerLevel world = (ServerLevel)this.getMachine().getLevel();
            ChunkAccess origin = world.getChunk(pos);
            ChunkPos startPos = world.getChunk(origin.getPos().x - currentRadius / 16, origin.getPos().z - currentRadius / 16).getPos();
            this.x = startPos.getMinBlockX();
            this.y = dir == Direction.UP ? pos.getY() + 1 : pos.getY() - 1;
            this.z = startPos.getMinBlockZ();
            this.startX = startPos.getMinBlockX();
            this.startY = pos.getY();
            this.startZ = startPos.getMinBlockZ();
            this.mineX = startPos.getMinBlockX();
            this.mineY = dir == Direction.UP ? pos.getY() + 1 : pos.getY() - 1;
            this.mineZ = startPos.getMinBlockZ();
            this.pipeY = dir == Direction.UP ? pos.getY() + 1 : pos.getY() - 1;
        }
    }

    private int getDropCountMultiplier() {
        return 5;
    }

    public void setChunkMode(boolean isChunkMode) {
        if (!this.isWorking()) {
            this.isChunkMode = isChunkMode;
            if (!this.getMachine().isRemote()) {
                this.resetArea(true);
            }
        }
    }

    public void setSilkTouchMode(boolean isSilkTouchMode) {
        if (!this.isWorking()) {
            this.isSilkTouchMode = isSilkTouchMode;
        }
    }

    @Override
    public BlockPos getMiningPos() {
        return this.getMachine().getPos().relative(this.getMachine().getFrontFacing().getOpposite());
    }

    @Override
    protected boolean hasPostProcessing() {
        return !this.isSilkTouchMode;
    }

    @Override
    protected void dropPostProcessing(NonNullList<ItemStack> blockDrops, List<ItemStack> outputs, BlockState blockState, LootParams.Builder builder) {
        if (this.getDropCountMultiplier() <= 0) {
            super.dropPostProcessing(blockDrops, outputs, blockState, builder);
            return;
        }
        ItemStack fortunePick = this.pickaxeTool.copy();
        fortunePick.enchant(Enchantments.BLOCK_FORTUNE, this.getDropCountMultiplier());
        LootParams params = builder.withParameter(LootContextParams.TOOL, (Object)fortunePick).create(LootContextParamSets.BLOCK);
        LootContext context = new LootContext.Builder(params).create(null);
        for (ItemStack outputStack : outputs) {
            if (ChemicalHelper.getPrefix((ItemLike)outputStack.getItem()) == TagPrefix.crushed) {
                outputStack = (ItemStack)DROP_MULTIPLIER.apply((Object)outputStack, (Object)context);
            }
            blockDrops.add((Object)outputStack);
        }
    }

    @Generated
    public void setVoltageTier(int voltageTier) {
        this.voltageTier = voltageTier;
    }

    @Override
    @Generated
    public int getVoltageTier() {
        return this.voltageTier;
    }

    @Generated
    public int getOverclockAmount() {
        return this.overclockAmount;
    }

    @Generated
    public void setOverclockAmount(int overclockAmount) {
        this.overclockAmount = overclockAmount;
    }

    @Generated
    public boolean isChunkMode() {
        return this.isChunkMode;
    }

    @Override
    @Generated
    public boolean isSilkTouchMode() {
        return this.isSilkTouchMode;
    }
}

