/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.miner;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.IgnoreEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.misc.ItemRecipeHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.transfer.item.NotifiableAccountedInvWrapper;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLogic
extends RecipeLogic
implements IRecipeCapabilityHolder {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MinerLogic.class, RecipeLogic.MANAGED_FIELD_HOLDER);
    private static final short MAX_SPEED = Short.MAX_VALUE;
    private static final byte POWER = 5;
    private static final byte TICK_TOLERANCE = 20;
    private static final double DIVIDEND = 32767.0 * Math.pow(20.0, 5.0);
    protected final IMiner miner;
    @Nullable
    private NotifiableAccountedInvWrapper cachedItemHandler = null;
    private final int fortune;
    private final int speed;
    private final int maximumRadius;
    public ItemStack pickaxeTool;
    private final LinkedList<BlockPos> blocksToMine = new LinkedList();
    @Persisted
    protected int x = Integer.MAX_VALUE;
    @Persisted
    protected int y = Integer.MAX_VALUE;
    @Persisted
    protected int z = Integer.MAX_VALUE;
    @Persisted
    protected int startX = Integer.MAX_VALUE;
    @Persisted
    protected int startZ = Integer.MAX_VALUE;
    @Persisted
    protected int startY = Integer.MAX_VALUE;
    @Persisted
    protected int pipeY = Integer.MAX_VALUE;
    @Persisted
    protected int mineX = Integer.MAX_VALUE;
    @Persisted
    protected int mineZ = Integer.MAX_VALUE;
    @Persisted
    protected int mineY = Integer.MAX_VALUE;
    private int minBuildHeight = Integer.MAX_VALUE;
    private int maxBuildHeight = Integer.MAX_VALUE;
    @Persisted
    private int pipeLength = 0;
    @Persisted
    private int currentRadius;
    @Persisted
    private boolean isDone;
    private boolean isInventoryFull;
    private final Map<IO, List<RecipeHandlerList>> capabilitiesProxy;
    protected final Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> capabilitiesFlat;
    private final ItemRecipeHandler inputItemHandler;
    private final ItemRecipeHandler outputItemHandler;
    private final IgnoreEnergyRecipeHandler inputEnergyHandler;
    private Direction dir = Direction.DOWN;

    public MinerLogic(@NotNull IRecipeLogicMachine machine, int fortune, int speed, int maximumRadius) {
        super(machine);
        this.miner = (IMiner)machine;
        this.fortune = fortune;
        this.speed = speed;
        this.currentRadius = maximumRadius;
        this.maximumRadius = maximumRadius;
        this.isDone = false;
        this.pickaxeTool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).get()).get();
        this.capabilitiesProxy = new EnumMap<IO, List<RecipeHandlerList>>(IO.class);
        this.capabilitiesFlat = new EnumMap(IO.class);
        this.inputItemHandler = new ItemRecipeHandler(IO.IN, machine.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP));
        this.outputItemHandler = new ItemRecipeHandler(IO.OUT, machine.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP));
        this.inputEnergyHandler = new IgnoreEnergyRecipeHandler();
        RecipeHandlerList inHandlers = RecipeHandlerList.of(IO.IN, this.inputItemHandler, this.inputEnergyHandler);
        RecipeHandlerList outHandlers = RecipeHandlerList.of(IO.OUT, this.outputItemHandler);
        this.addHandlerList(inHandlers);
        this.addHandlerList(outHandlers);
    }

    @Override
    public void resetRecipeLogic() {
        super.resetRecipeLogic();
        this.resetArea(false);
        this.cachedItemHandler = null;
        this.pipeLength = 0;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void inValid() {
        super.inValid();
        this.cachedItemHandler = null;
        this.pipeLength = 0;
    }

    private static BlockState findMiningReplacementBlock(Level level) {
        try {
            return BlockStateParser.parseForBlock((HolderLookup)level.holderLookup(Registries.BLOCK), (String)ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith, (boolean)false).blockState();
        }
        catch (CommandSyntaxException ignored) {
            GTCEu.LOGGER.error("failed to parse replaceMinedBlocksWith, invalid BlockState: {}", (Object)ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith);
            return Blocks.COBBLESTONE.defaultBlockState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void serverTick() {
        block11: {
            BlockState blockState;
            NonNullList blockDrops;
            ServerLevel serverLevel;
            block12: {
                block10: {
                    Level level;
                    if (this.isSuspend() || !((level = this.getMachine().getLevel()) instanceof ServerLevel)) break block10;
                    serverLevel = (ServerLevel)level;
                    if (!this.checkCanMine()) break block10;
                    if (!this.isInventoryFull()) {
                        this.miner.drainInput(false);
                        this.setStatus(RecipeLogic.Status.WORKING);
                    } else if (this.isWorking()) {
                        this.setWaiting((Component)Component.translatable((String)"gtceu.recipe_logic.insufficient_out").append(": ").append((Component)ItemRecipeCapability.CAP.getName()));
                    }
                    if (this.dir == Direction.DOWN && this.mineY < this.pipeY || this.dir == Direction.UP && this.mineY > this.pipeY) {
                        BlockPos miningPos = this.getMiningPos();
                        BlockPos pipePos = new BlockPos(miningPos.getX(), this.pipeY, miningPos.getZ());
                        if (serverLevel.getBlockState(pipePos).getDestroySpeed((BlockGetter)serverLevel, pipePos) < 0.0f) {
                            this.isDone = true;
                            this.setStatus(RecipeLogic.Status.IDLE);
                            return;
                        }
                        serverLevel.destroyBlock(pipePos, false);
                        this.pipeY = this.dir == Direction.UP ? ++this.pipeY : --this.pipeY;
                        this.incrementPipeLength();
                    }
                    this.checkBlocksToMine();
                    if (this.getMachine().getOffsetTimer() % (long)this.speed != 0L || this.blocksToMine.isEmpty()) break block11;
                    blockDrops = NonNullList.create();
                    blockState = serverLevel.getBlockState(this.blocksToMine.getFirst());
                    break block12;
                }
                this.setStatus(RecipeLogic.Status.IDLE);
                if (this.subscription == null) return;
                this.subscription.unsubscribe();
                this.subscription = null;
                return;
            }
            while (!blockState.is(Tags.Blocks.ORES)) {
                this.blocksToMine.removeFirst();
                if (this.blocksToMine.isEmpty()) break;
                blockState = serverLevel.getBlockState(this.blocksToMine.getFirst());
            }
            if (!this.blocksToMine.isEmpty() & blockState.is(Tags.Blocks.ORES)) {
                LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)blockState).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atLowerCornerOf((Vec3i)((Vec3i)this.blocksToMine.getFirst()))).withParameter(LootContextParams.TOOL, (Object)this.getPickaxeTool());
                this.getSmallOreBlockDrops((NonNullList<ItemStack>)blockDrops, blockState, builder);
                if (this.isSilkTouchMode()) {
                    this.getSilkTouchDrops((NonNullList<ItemStack>)blockDrops, blockState, builder);
                } else {
                    this.getRegularBlockDrops((NonNullList<ItemStack>)blockDrops, blockState, builder);
                }
                if (this.hasPostProcessing()) {
                    this.doPostProcessing((NonNullList<ItemStack>)blockDrops, blockState, builder);
                }
                this.mineAndInsertItems((NonNullList<ItemStack>)blockDrops, serverLevel);
            }
        }
        if (!this.blocksToMine.isEmpty()) return;
        this.x = this.mineX;
        this.y = this.mineY;
        this.z = this.mineZ;
        this.blocksToMine.addAll(this.getBlocksToMine());
        if (!this.blocksToMine.isEmpty()) return;
        this.isDone = true;
        this.setStatus(RecipeLogic.Status.IDLE);
    }

    protected boolean checkCanMine() {
        if (!this.isDone && this.checkCoordinatesInvalid()) {
            this.initPos(this.getMiningPos(), this.currentRadius);
        }
        return !this.isDone && this.miner.drainInput(true);
    }

    protected void onMineOperation() {
    }

    protected void getSmallOreBlockDrops(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
    }

    protected boolean hasPostProcessing() {
        return false;
    }

    protected boolean isSilkTouchMode() {
        return false;
    }

    protected void getRegularBlockDrops(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        blockDrops.addAll((Collection)blockState.getDrops(builder));
    }

    protected int getVoltageTier() {
        return 0;
    }

    protected boolean doPostProcessing(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        ItemStack oreDrop = new ItemStack((ItemLike)blockState.getBlock());
        if (oreDrop.isEmpty()) {
            return false;
        }
        this.inputItemHandler.storage.setStackInSlot(0, oreDrop);
        this.outputItemHandler.storage.clear();
        Iterator<GTRecipe> matches = this.machine.getRecipeType().searchRecipe(this, r -> RecipeHelper.matchContents(this, r).isSuccess());
        while (matches.hasNext()) {
            long eut;
            GTRecipe match = matches.next();
            if (match == null || GTUtil.getTierByVoltage(eut = match.getInputEUt().getTotalEU()) > this.getVoltageTier() || !RecipeHelper.handleRecipeIO(this, match, IO.OUT, this.chanceCaches).isSuccess()) continue;
            blockDrops.clear();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (int i = 0; i < this.outputItemHandler.storage.getSlots(); ++i) {
                ItemStack stack = this.outputItemHandler.storage.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                result.add(stack);
            }
            this.dropPostProcessing(blockDrops, result, blockState, builder);
            return true;
        }
        return false;
    }

    protected void dropPostProcessing(NonNullList<ItemStack> blockDrops, List<ItemStack> outputs, BlockState blockState, LootParams.Builder builder) {
        blockDrops.addAll(outputs);
    }

    protected void getSilkTouchDrops(NonNullList<ItemStack> blockDrops, BlockState blockState, LootParams.Builder builder) {
        blockDrops.add((Object)new ItemStack((ItemLike)blockState.getBlock()));
    }

    protected NotifiableAccountedInvWrapper getCachedItemHandler() {
        if (this.cachedItemHandler == null) {
            this.cachedItemHandler = new NotifiableAccountedInvWrapper((IItemHandlerModifiable[])this.machine.getCapabilitiesFlat(IO.OUT, ItemRecipeCapability.CAP).stream().map(IItemHandlerModifiable.class::cast).toArray(IItemHandlerModifiable[]::new));
        }
        return this.cachedItemHandler;
    }

    private void mineAndInsertItems(NonNullList<ItemStack> blockDrops, ServerLevel world) {
        NotifiableAccountedInvWrapper handler = this.getCachedItemHandler();
        if (handler != null) {
            if (GTTransferUtils.addItemsToItemHandler((IItemHandlerModifiable)handler, true, blockDrops)) {
                GTTransferUtils.addItemsToItemHandler((IItemHandlerModifiable)handler, false, blockDrops);
                world.setBlock(this.blocksToMine.getFirst(), MinerLogic.findMiningReplacementBlock((Level)world), 3);
                this.mineX = this.blocksToMine.getFirst().getX();
                this.mineZ = this.blocksToMine.getFirst().getZ();
                this.mineY = this.blocksToMine.getFirst().getY();
                this.blocksToMine.removeFirst();
                this.onMineOperation();
                this.isInventoryFull = false;
            } else {
                this.isInventoryFull = true;
            }
        }
    }

    public void initPos(@NotNull BlockPos pos, int currentRadius) {
        this.x = pos.getX() - currentRadius;
        this.z = pos.getZ() - currentRadius;
        this.y = this.dir == Direction.UP ? pos.getY() + 1 : pos.getY() - 1;
        this.startX = pos.getX() - currentRadius;
        this.startZ = pos.getZ() - currentRadius;
        this.startY = pos.getY();
        this.pipeY = this.dir == Direction.UP ? pos.getY() + 1 : pos.getY() - 1;
        this.mineX = pos.getX() - currentRadius;
        this.mineZ = pos.getZ() - currentRadius;
        this.mineY = this.dir == Direction.UP ? pos.getY() + 1 : pos.getY() - 1;
        this.onRemove();
    }

    private boolean checkCoordinatesInvalid() {
        return this.x == Integer.MAX_VALUE && this.y == Integer.MAX_VALUE && this.z == Integer.MAX_VALUE;
    }

    public void checkBlocksToMine() {
        if (this.blocksToMine.isEmpty()) {
            this.blocksToMine.addAll(this.getBlocksToMine());
        }
    }

    public void resetArea(boolean checkToMine) {
        this.initPos(this.getMiningPos(), this.currentRadius);
        if (this.isDone) {
            this.setWorkingEnabled(false);
        }
        this.isDone = false;
        if (checkToMine) {
            this.blocksToMine.clear();
            this.checkBlocksToMine();
        }
    }

    private LinkedList<BlockPos> getBlocksToMine() {
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        Level level = this.getMachine().getLevel();
        assert (level != null);
        double quotient = MinerLogic.getQuotient(MinerLogic.getMeanTickTime(level));
        int calcAmount = quotient < 1.0 ? 1 : (int)Math.min(quotient, 32767.0);
        int calculated = 0;
        if (this.minBuildHeight == Integer.MAX_VALUE) {
            this.minBuildHeight = level.getMinBuildHeight();
        }
        if (this.maxBuildHeight == Integer.MAX_VALUE) {
            this.maxBuildHeight = level.getMaxBuildHeight();
        }
        while (calculated < calcAmount) {
            if (this.y > this.minBuildHeight && this.y < this.maxBuildHeight) {
                if (this.z <= this.startZ + this.currentRadius * 2) {
                    if (this.x <= this.startX + this.currentRadius * 2) {
                        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
                        BlockState state = level.getBlockState(blockPos);
                        if (state.getDestroySpeed((BlockGetter)level, blockPos) >= 0.0f && level.getBlockEntity(blockPos) == null && state.is(Tags.Blocks.ORES)) {
                            blocks.addLast(blockPos);
                        }
                        ++this.x;
                    } else {
                        this.x = this.startX;
                        ++this.z;
                    }
                } else {
                    this.z = this.startZ;
                    this.y = this.dir == Direction.UP ? ++this.y : --this.y;
                }
            } else {
                return blocks;
            }
            if (blocks.isEmpty()) continue;
            ++calculated;
        }
        return blocks;
    }

    private static long mean(@NotNull long[] values) {
        if ((long)values.length == 0L) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private static double getMeanTickTime(@NotNull Level world) {
        return (double)MinerLogic.mean(Objects.requireNonNull(world.getServer()).tickTimes) * 1.0E-6;
    }

    private static double getQuotient(double base) {
        return DIVIDEND / Math.pow(base, 5.0);
    }

    private void incrementPipeLength() {
        ++this.pipeLength;
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getMiningPos().relative(this.dir, this.pipeLength);
            serverLevel.setBlockAndUpdate(pos, GTBlocks.MINER_PIPE.getDefaultState());
        }
    }

    public BlockPos getMiningPos() {
        return this.getMachine().getPos();
    }

    public void onRemove() {
        this.pipeLength = 0;
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getMiningPos().relative(this.dir);
            while (serverLevel.getBlockState(pos).is((Block)GTBlocks.MINER_PIPE.get())) {
                serverLevel.removeBlock(pos, false);
                pos = pos.relative(this.dir);
            }
        }
    }

    @Generated
    public int getFortune() {
        return this.fortune;
    }

    @Generated
    public int getSpeed() {
        return this.speed;
    }

    @Generated
    public int getMaximumRadius() {
        return this.maximumRadius;
    }

    @Generated
    public ItemStack getPickaxeTool() {
        return this.pickaxeTool;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public int getZ() {
        return this.z;
    }

    @Generated
    public int getStartX() {
        return this.startX;
    }

    @Generated
    public int getStartZ() {
        return this.startZ;
    }

    @Generated
    public int getStartY() {
        return this.startY;
    }

    @Generated
    public int getPipeY() {
        return this.pipeY;
    }

    @Generated
    public int getMineX() {
        return this.mineX;
    }

    @Generated
    public int getMineZ() {
        return this.mineZ;
    }

    @Generated
    public int getMineY() {
        return this.mineY;
    }

    @Generated
    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    @Generated
    public int getMaxBuildHeight() {
        return this.maxBuildHeight;
    }

    @Generated
    public int getPipeLength() {
        return this.pipeLength;
    }

    @Generated
    public int getCurrentRadius() {
        return this.currentRadius;
    }

    @Generated
    public void setCurrentRadius(int currentRadius) {
        this.currentRadius = currentRadius;
    }

    @Generated
    public boolean isDone() {
        return this.isDone;
    }

    @Generated
    public boolean isInventoryFull() {
        return this.isInventoryFull;
    }

    @Override
    @Generated
    public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }

    @Override
    @Generated
    public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat() {
        return this.capabilitiesFlat;
    }

    @Generated
    public void setDir(Direction dir) {
        this.dir = dir;
    }

    @Generated
    public Direction getDir() {
        return this.dir;
    }
}

