/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.integration.map.ClientCacheManager;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SCPacketShareProspection
implements GTNetwork.INetPacket {
    private UUID sender;
    private UUID receiver;
    private String cacheName;
    private String key;
    private boolean isDimCache;
    private ResourceKey<Level> dimension;
    private CompoundTag data;
    private boolean first;

    public SCPacketShareProspection() {
    }

    public SCPacketShareProspection(FriendlyByteBuf buf) {
        this.sender = buf.readUUID();
        this.receiver = buf.readUUID();
        this.cacheName = buf.readUtf();
        this.key = buf.readUtf();
        this.isDimCache = buf.readBoolean();
        this.dimension = buf.readResourceKey(Registries.DIMENSION);
        this.data = buf.readNbt();
        this.first = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.sender);
        buf.writeUUID(this.receiver);
        buf.writeUtf(this.cacheName);
        buf.writeUtf(this.key);
        buf.writeBoolean(this.isDimCache);
        buf.writeResourceKey(this.dimension);
        buf.writeNbt(this.data);
        buf.writeBoolean(this.first);
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            if (this.first) {
                Component playerName;
                PlayerInfo senderInfo = Objects.requireNonNull(Minecraft.getInstance().getConnection()).getPlayerInfo(this.sender);
                if (senderInfo == null) {
                    return;
                }
                Object object = playerName = senderInfo.getTabListDisplayName() != null ? senderInfo.getTabListDisplayName() : Component.literal((String)senderInfo.getProfile().getName());
                assert (Minecraft.getInstance().player != null);
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"command.gtceu.share_prospection_data.notification", (Object[])new Object[]{playerName}));
            }
            ClientCacheManager.processProspectionShare(this.cacheName, this.key, this.isDimCache, this.dimension, this.data);
        } else {
            SCPacketShareProspection newPacket = new SCPacketShareProspection(this.sender, this.receiver, this.cacheName, this.key, this.isDimCache, this.dimension, this.data, this.first);
            GTNetwork.sendToPlayer(GTCEu.getMinecraftServer().getPlayerList().getPlayer(this.receiver), newPacket);
        }
    }

    @Generated
    public SCPacketShareProspection(UUID sender, UUID receiver, String cacheName, String key, boolean isDimCache, ResourceKey<Level> dimension, CompoundTag data, boolean first) {
        this.sender = sender;
        this.receiver = receiver;
        this.cacheName = cacheName;
        this.key = key;
        this.isDimCache = isDimCache;
        this.dimension = dimension;
        this.data = data;
        this.first = first;
    }
}

