/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.api.cosmetics.CapeRegistry;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SPacketNotifyCapeChange
implements GTNetwork.INetPacket {
    public UUID uuid;
    public ResourceLocation cape;

    public SPacketNotifyCapeChange(FriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        this.cape = buf.readBoolean() ? buf.readResourceLocation() : null;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
        buf.writeBoolean(this.cape != null);
        if (this.cape != null) {
            buf.writeResourceLocation(this.cape);
        }
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            CapeRegistry.giveRawCape(this.uuid, this.cape);
        }
    }

    @Generated
    public SPacketNotifyCapeChange() {
    }

    @Generated
    public SPacketNotifyCapeChange(UUID uuid, ResourceLocation cape) {
        this.uuid = uuid;
        this.cape = cape;
    }
}

