/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.Logger;

public class SPacketSyncFluidVeins
implements GTNetwork.INetPacket {
    private final Map<ResourceLocation, BedrockFluidDefinition> veins;

    public SPacketSyncFluidVeins() {
        this.veins = new HashMap<ResourceLocation, BedrockFluidDefinition>();
    }

    public SPacketSyncFluidVeins(FriendlyByteBuf buf) {
        this();
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        Stream.generate(() -> {
            ResourceLocation id = buf.readResourceLocation();
            CompoundTag tag = buf.readAnySizeNbt();
            BedrockFluidDefinition def = (BedrockFluidDefinition)BedrockFluidDefinition.FULL_CODEC.parse((DynamicOps)ops, (Object)tag).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            return Map.entry(id, def);
        }).limit(buf.readVarInt()).forEach(entry -> this.veins.put((ResourceLocation)entry.getKey(), (BedrockFluidDefinition)entry.getValue()));
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        int size = this.veins.size();
        buf.writeVarInt(size);
        for (Map.Entry<ResourceLocation, BedrockFluidDefinition> entry : this.veins.entrySet()) {
            buf.writeResourceLocation(entry.getKey());
            CompoundTag tag = (CompoundTag)BedrockFluidDefinition.FULL_CODEC.encodeStart((DynamicOps)ops, (Object)entry.getValue()).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            buf.writeNbt(tag);
        }
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        ClientProxy.CLIENT_FLUID_VEINS.clear();
        ClientProxy.CLIENT_FLUID_VEINS.putAll(this.veins);
    }

    @Generated
    public SPacketSyncFluidVeins(Map<ResourceLocation, BedrockFluidDefinition> veins) {
        this.veins = veins;
    }
}

