/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import java.util.Arrays;
import net.minecraft.world.level.Level;

public class AveragingPerTickCounter {
    private final long defaultValue;
    private final long[] values;
    private long lastUpdatedWorldTime = 0L;
    private int currentIndex = 0;
    private boolean dirty = true;
    private double lastAverage = 0.0;

    public AveragingPerTickCounter() {
        this(0L, 20);
    }

    public AveragingPerTickCounter(long defaultValue, int length) {
        this.defaultValue = defaultValue;
        this.values = new long[length];
        Arrays.fill(this.values, defaultValue);
    }

    private void checkValueState(Level world) {
        if (world == null) {
            return;
        }
        long currentWorldTime = world.getGameTime();
        if (currentWorldTime != this.lastUpdatedWorldTime) {
            long dif = currentWorldTime - this.lastUpdatedWorldTime;
            if (dif >= (long)this.values.length || dif < 0L) {
                Arrays.fill(this.values, this.defaultValue);
                this.currentIndex = 0;
            } else {
                int i = this.currentIndex + 1;
                while ((long)i <= (long)this.currentIndex + dif) {
                    this.values[i % this.values.length] = this.defaultValue;
                    ++i;
                }
                this.currentIndex = (int)((long)this.currentIndex + dif);
                if (this.currentIndex >= this.values.length) {
                    this.currentIndex %= this.values.length;
                }
            }
            this.lastUpdatedWorldTime = currentWorldTime;
            this.dirty = true;
        }
    }

    public long getLast(Level world) {
        this.checkValueState(world);
        return this.values[this.currentIndex];
    }

    public double getAverage(Level world) {
        this.checkValueState(world);
        if (!this.dirty) {
            return this.lastAverage;
        }
        this.dirty = false;
        this.lastAverage = (double)Arrays.stream(this.values).sum() / (double)this.values.length;
        return this.lastAverage;
    }

    public void increment(Level world, long value) {
        this.checkValueState(world);
        int n = this.currentIndex;
        this.values[n] = this.values[n] + value;
    }

    public void set(Level world, long value) {
        this.checkValueState(world);
        this.values[this.currentIndex] = value;
    }
}

