/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.Node;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNetWalker;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyRoutePath;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;

public class EnergyNet
extends PipeNet<WireProperties> {
    private final Map<BlockPos, List<EnergyRoutePath>> NET_DATA = new HashMap<BlockPos, List<EnergyRoutePath>>();
    private long lastEnergyFluxPerSec;
    private long energyFluxPerSec;
    private long lastTime;

    protected EnergyNet(LevelPipeNet<WireProperties, ? extends EnergyNet> world) {
        super(world);
    }

    public List<EnergyRoutePath> getNetData(BlockPos pipePos) {
        List<EnergyRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = EnergyNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(EnergyRoutePath::getDistance));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<WireProperties>> transferredNodes, PipeNet<WireProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((EnergyNet)parentNet).NET_DATA.clear();
    }

    @Override
    protected void writeNodeData(WireProperties nodeData, CompoundTag tagCompound) {
        tagCompound.putLong("voltage", nodeData.getVoltage());
        tagCompound.putInt("amperage", nodeData.getAmperage());
        tagCompound.putInt("loss", nodeData.getLossPerBlock());
    }

    @Override
    protected WireProperties readNodeData(CompoundTag tagCompound) {
        long voltage = tagCompound.getLong("voltage");
        int amperage = tagCompound.getInt("amperage");
        int lossPerBlock = tagCompound.getInt("loss");
        return new WireProperties(voltage, amperage, lossPerBlock);
    }

    public long getEnergyFluxPerSec() {
        ServerLevel world = this.getLevel();
        if (world != null && !world.isClientSide && world.getGameTime() - this.lastTime >= 20L) {
            this.lastTime = world.getGameTime();
            this.clearCache();
        }
        return this.lastEnergyFluxPerSec;
    }

    public void addEnergyFluxPerSec(long energy) {
        this.energyFluxPerSec += energy;
    }

    public void clearCache() {
        this.lastEnergyFluxPerSec = this.energyFluxPerSec;
        this.energyFluxPerSec = 0L;
    }
}

