/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.gregtechceu.gtceu.common.cover.data.FilterMode;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemRoutePath;
import com.gregtechceu.gtceu.common.pipelike.item.ItemRoutePathSet;
import com.gregtechceu.gtceu.utils.FacingPos;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemNetHandler
implements IItemHandlerModifiable {
    private ItemPipeNet network;
    private final ItemPipeBlockEntity pipe;
    private final Direction facing;
    private final Object2IntOpenHashMap<FacingPos> simulatedTransfersGlobalRoundRobin = new Object2IntOpenHashMap();
    private int simulatedTransfers = 0;

    public ItemNetHandler(ItemPipeNet net, ItemPipeBlockEntity pipe, Direction facing) {
        this.network = net;
        this.pipe = pipe;
        this.facing = facing;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        List<ItemRoutePath> routePaths;
        if (stack.isEmpty()) {
            return stack;
        }
        if (this.network == null || this.pipe == null || this.pipe.isInValid() || this.pipe.isBlocked(this.facing)) {
            return stack;
        }
        this.simulatedTransfers = this.pipe.getTransferredItems();
        this.simulatedTransfersGlobalRoundRobin.clear();
        this.simulatedTransfersGlobalRoundRobin.putAll(this.pipe.getTransferred());
        CoverBehavior pipeCover = this.pipe.getCoverContainer().getCoverAtSide(this.facing);
        CoverBehavior tileCover = this.getCoverOnNeighbour(this.pipe.getPipePos(), this.facing);
        ConveyorCover conveyor = null;
        if (pipeCover instanceof ConveyorCover && tileCover instanceof ConveyorCover) {
            return stack;
        }
        if (!ItemNetHandler.checkImportCover(tileCover, false, stack)) {
            return stack;
        }
        if (pipeCover instanceof ConveyorCover) {
            ConveyorCover pipeConveyor;
            conveyor = pipeConveyor = (ConveyorCover)pipeCover;
        }
        if (tileCover instanceof ConveyorCover) {
            ConveyorCover tileConveyor;
            conveyor = tileConveyor = (ConveyorCover)tileCover;
        }
        if ((routePaths = this.network.getNetData(this.pipe.getPipePos(), this.facing, ItemRoutePathSet.FULL)).isEmpty()) {
            return stack;
        }
        ArrayList<ItemRoutePath> routePathsCopy = new ArrayList<ItemRoutePath>(routePaths);
        if (conveyor == null) {
            return this.distributeHighestPriority(routePathsCopy, stack, simulate);
        }
        switch (conveyor.getDistributionMode()) {
            case INSERT_FIRST: {
                stack = this.distributeHighestPriority(routePathsCopy, stack, simulate);
                break;
            }
            case ROUND_ROBIN_GLOBAL: {
                stack = this.distributeEqually(routePathsCopy, stack, simulate);
                break;
            }
            case ROUND_ROBIN_PRIO: {
                stack = this.distributeEquallyNoRestrictive(stack, simulate);
            }
        }
        return stack;
    }

    private ItemStack distributeHighestPriority(List<ItemRoutePath> copy, ItemStack stack, boolean simulate) {
        for (ItemRoutePath inv : copy) {
            stack = this.insertIntoTarget(inv, stack, simulate, false);
            if (!stack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    private ItemStack distributeEquallyNoRestrictive(ItemStack stack, boolean simulate) {
        ArrayList<ItemRoutePath> routePathsNonRestrictedCopy = new ArrayList<ItemRoutePath>(this.network.getNetData(this.pipe.getPipePos(), this.facing, ItemRoutePathSet.NONRESTRICTED));
        ItemStack remainsNonRestricted = routePathsNonRestrictedCopy.isEmpty() ? stack : this.distributeEqually(routePathsNonRestrictedCopy, stack, simulate);
        if (!remainsNonRestricted.isEmpty()) {
            ArrayList<ItemRoutePath> routePathsRestrictiveCopy = new ArrayList<ItemRoutePath>(this.network.getNetData(this.pipe.getPipePos(), this.facing, ItemRoutePathSet.RESTRICTED));
            return this.distributeEqually(routePathsRestrictiveCopy, remainsNonRestricted, simulate);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack distributeEqually(List<ItemRoutePath> copy, ItemStack stack, boolean simulate) {
        ArrayList<EnhancedRoundRobinData> transferred = new ArrayList<EnhancedRoundRobinData>();
        IntArrayList steps = new IntArrayList();
        int min = Integer.MAX_VALUE;
        for (ItemRoutePath inv : copy) {
            ItemStack simStack = stack.copy();
            int ins = stack.getCount() - this.insertIntoTarget(inv, simStack, true, true).getCount();
            if (ins <= 0) continue;
            int didTransfer = this.didTransferTo(inv, simulate);
            EnhancedRoundRobinData data2 = new EnhancedRoundRobinData(inv, ins, didTransfer);
            transferred.add(data2);
            min = Math.min(min, didTransfer);
            if (steps.contains(didTransfer)) continue;
            steps.add(didTransfer);
        }
        if (transferred.isEmpty() || steps.isEmpty()) {
            return stack;
        }
        if (!simulate && min < Integer.MAX_VALUE) {
            this.decrementBy(min);
        }
        transferred.sort(Comparator.comparingInt(data -> data.transferred));
        steps.sort(Integer::compare);
        if (((EnhancedRoundRobinData)transferred.get((int)0)).transferred != steps.getInt(0)) {
            return stack;
        }
        int amount = stack.getCount();
        int c = amount / transferred.size();
        int m = amount % transferred.size();
        ArrayList transferredCopy = new ArrayList(transferred);
        int nextStep = steps.removeInt(0);
        block1: while (amount > 0 && !transferredCopy.isEmpty()) {
            Iterator iterator = transferredCopy.iterator();
            while (iterator.hasNext()) {
                EnhancedRoundRobinData data3 = (EnhancedRoundRobinData)iterator.next();
                if (nextStep >= 0 && data3.transferred >= nextStep) break;
                int toInsert = nextStep <= 0 ? (amount <= m ? 1 : Math.min(c, amount)) : Math.min(amount, nextStep - data3.transferred);
                if (data3.toTransfer + toInsert >= data3.maxInsertable) {
                    data3.toTransfer = data3.maxInsertable;
                    iterator.remove();
                } else {
                    data3.toTransfer += toInsert;
                }
                data3.transferred += toInsert;
                if ((amount -= toInsert) != 0) continue;
                break block1;
            }
            for (EnhancedRoundRobinData data4 : transferredCopy) {
                if (data4.transferred >= nextStep) continue;
                continue block1;
            }
            if (steps.isEmpty()) {
                if (nextStep < 0) continue;
                c = amount / transferredCopy.size();
                m = amount % transferredCopy.size();
                nextStep = -1;
                continue;
            }
            nextStep = steps.removeInt(0);
        }
        int inserted = 0;
        for (EnhancedRoundRobinData data5 : transferred) {
            ItemStack toInsert = stack.copy();
            toInsert.setCount(data5.toTransfer);
            int ins = data5.toTransfer - this.insertIntoTarget(data5.routePath, toInsert, simulate, false).getCount();
            inserted += ins;
            this.transferTo(data5.routePath, simulate, ins);
        }
        ItemStack remainder = stack.copy();
        remainder.shrink(inserted);
        return remainder;
    }

    private ItemStack insertIntoTarget(ItemRoutePath routePath, ItemStack stack, boolean simulate, boolean ignoreLimit) {
        RobotArmCover robotArm;
        int allowed;
        int n = allowed = ignoreLimit ? stack.getCount() : this.checkTransferable(routePath.getProperties().getTransferRate(), stack.getCount(), simulate);
        if (allowed == 0 || !routePath.matchesFilters(stack)) {
            return stack;
        }
        CoverBehavior pipeCover = routePath.getTargetPipe().getCoverContainer().getCoverAtSide(routePath.getTargetFacing());
        CoverBehavior tileCover = this.getCoverOnNeighbour(routePath.getTargetPipe().getPipePos(), routePath.getTargetFacing());
        if (pipeCover != null) {
            ItemStackHandler defaultHandler = new ItemStackHandler(1);
            defaultHandler.setStackInSlot(0, stack.copy());
            IItemHandlerModifiable itemHandler = pipeCover.getItemHandlerCap((IItemHandlerModifiable)defaultHandler);
            if (itemHandler == null || itemHandler != defaultHandler && (allowed = itemHandler.extractItem(0, allowed, true).getCount()) <= 0) {
                return stack;
            }
        }
        IItemHandler neighbourHandler = routePath.getHandler((Level)this.network.getLevel());
        if (pipeCover instanceof RobotArmCover && (robotArm = (RobotArmCover)pipeCover).getIo() == IO.OUT) {
            return this.insertOverRobotArm(neighbourHandler, robotArm, stack, simulate, allowed, ignoreLimit);
        }
        if (tileCover instanceof RobotArmCover && (robotArm = (RobotArmCover)tileCover).getIo() == IO.IN) {
            return this.insertOverRobotArm(neighbourHandler, robotArm, stack, simulate, allowed, ignoreLimit);
        }
        return this.insertIntoDestination(neighbourHandler, stack, simulate, allowed, ignoreLimit);
    }

    private ItemStack insertIntoDestination(IItemHandler handler, ItemStack stack, boolean simulate, int allowed, boolean ignoreLimit) {
        if (stack.getCount() == allowed) {
            ItemStack re = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
            if (!ignoreLimit) {
                this.transfer(simulate, stack.getCount() - re.getCount());
            }
            return re;
        }
        ItemStack toInsert = stack.copy();
        toInsert.setCount(Math.min(allowed, stack.getCount()));
        int r = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)toInsert, (boolean)simulate).getCount();
        if (!ignoreLimit) {
            this.transfer(simulate, toInsert.getCount() - r);
        }
        ItemStack remainder = stack.copy();
        remainder.setCount(r + (stack.getCount() - toInsert.getCount()));
        return remainder;
    }

    private ItemStack insertOverRobotArm(IItemHandler handler, RobotArmCover arm, ItemStack stack, boolean simulate, int allowed, boolean ignoreLimit) {
        int rate = arm.getFilterHandler().getFilter().testItemCount(stack);
        switch (arm.getTransferMode()) {
            case TRANSFER_ANY: {
                return this.insertIntoDestination(handler, stack, simulate, allowed, ignoreLimit);
            }
            case KEEP_EXACT: {
                int count;
                if (rate == Integer.MAX_VALUE) {
                    rate = arm.getGlobalTransferLimit();
                }
                if ((count = rate - ItemNetHandler.countStack(handler, stack, arm)) <= 0) {
                    return stack;
                }
                count = Math.min(allowed, Math.min(stack.getCount(), count));
                return this.insertIntoDestination(handler, stack, simulate, count, ignoreLimit);
            }
            case TRANSFER_EXACT: {
                int max = allowed + arm.getBuffer();
                int count = Math.min(max, Math.min(rate, stack.getCount()));
                if (count < rate) {
                    arm.buffer(allowed);
                    return stack;
                }
                arm.clearBuffer();
                if (this.insertIntoDestination(handler, stack, true, count, ignoreLimit).getCount() != stack.getCount() - count) {
                    return stack;
                }
                return this.insertIntoDestination(handler, stack, simulate, count, ignoreLimit);
            }
        }
        return stack;
    }

    public static int countStack(IItemHandler handler, ItemStack stack, RobotArmCover arm) {
        SimpleItemFilter simple;
        if (arm == null) {
            return 0;
        }
        int count = 0;
        ItemFilter filter = arm.getFilterHandler().getFilter();
        boolean ignoreNBT = filter instanceof SimpleItemFilter && (simple = (SimpleItemFilter)filter).isIgnoreNbt();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.isEmpty() || ignoreNBT && !ItemStack.isSameItem((ItemStack)stack, (ItemStack)slot) || !ignoreNBT && !ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)slot) || !arm.getFilterHandler().getFilter().test(slot)) continue;
            count += slot.getCount();
        }
        return count;
    }

    public static boolean checkImportCover(@Nullable CoverBehavior cover, boolean onPipe, ItemStack stack) {
        if (cover instanceof ItemFilterCover) {
            ItemFilterCover filter = (ItemFilterCover)cover;
            return filter.getFilterMode() != FilterMode.FILTER_BOTH && (filter.getFilterMode() != FilterMode.FILTER_INSERT || !onPipe) && (filter.getFilterMode() != FilterMode.FILTER_EXTRACT || onPipe) || filter.getItemFilter().test(stack);
        }
        return true;
    }

    public CoverBehavior getCoverOnNeighbour(BlockPos pos, Direction handlerFacing) {
        Level level = this.pipe.getLevel();
        if (level == null) {
            return null;
        }
        BlockEntity tile = this.pipe.getLevel().getBlockEntity(pos.relative(handlerFacing));
        if (tile == null) {
            return null;
        }
        ICoverable coverable = GTCapabilityHelper.getCoverable(this.pipe.getLevel(), pos.relative(handlerFacing), handlerFacing.getOpposite());
        if (coverable == null) {
            return null;
        }
        return coverable.getCoverAtSide(handlerFacing.getOpposite());
    }

    private int checkTransferable(float rate, int amount, boolean simulate) {
        int max = (int)((double)(rate * 64.0f) + 0.5);
        if (simulate) {
            return Math.max(0, Math.min(max - this.simulatedTransfers, amount));
        }
        return Math.max(0, Math.min(max - this.pipe.getTransferredItems(), amount));
    }

    private void transfer(boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfers += amount;
        } else {
            this.pipe.addTransferredItems(amount);
        }
    }

    private void transferTo(ItemRoutePath handler, boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfersGlobalRoundRobin.addTo((Object)handler.toFacingPos(), amount);
        } else {
            this.pipe.getTransferred().mergeInt((Object)handler.toFacingPos(), amount, Integer::sum);
        }
    }

    private int didTransferTo(ItemRoutePath handler, boolean simulate) {
        if (simulate) {
            return this.simulatedTransfersGlobalRoundRobin.getOrDefault((Object)handler.toFacingPos(), 0);
        }
        return this.pipe.getTransferred().getOrDefault((Object)handler.toFacingPos(), 0);
    }

    private void decrementBy(int amount) {
        for (Object2IntMap.Entry entry : this.pipe.getTransferred().object2IntEntrySet()) {
            entry.setValue(entry.getIntValue() - amount);
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @Generated
    public ItemPipeNet getNetwork() {
        return this.network;
    }

    @Generated
    public void setNetwork(ItemPipeNet network) {
        this.network = network;
    }

    @Generated
    public Direction getFacing() {
        return this.facing;
    }

    private static class EnhancedRoundRobinData {
        private final ItemRoutePath routePath;
        private final int maxInsertable;
        private int transferred;
        private int toTransfer = 0;

        private EnhancedRoundRobinData(ItemRoutePath routePath, int maxInsertable, int transferred) {
            this.maxInsertable = maxInsertable;
            this.transferred = transferred;
            this.routePath = routePath;
        }
    }
}

